/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.modelbinder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.BinderHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBindedModelProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IWatchedModelProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.BindedModelProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.Binder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.annotation.ModelBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Annotation;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Body;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Clazz;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ComposerHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Field;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Visibility;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;

public class WatchedModelProxyGenerator extends Generator{

	private JClassType type;
	private ComposerHelper composerHelper;
	private String simpleClassName;
	private String realTypeName;
	private Method constructor;


	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {
		this.realTypeName	  = typeName;

		try {
			simpleClassName 		= type.getSimpleSourceName() + "_WatchedModelProxy";

			composerHelper = new ComposerHelper(context, logger, type.getPackage().getName(), simpleClassName);
			composerHelper.setSuperClass(typeName);
			composerHelper.addInterface(IWatchedModelProxy.class);

			createFields();

			createContructor();

			createInnerBindedModelProxyInterface();

			composerHelper.commit();

		} catch (NotFoundException e) {
			e.printStackTrace();
			throw new UnableToCompleteException();
		} catch (Exception e) {
			e.printStackTrace();
			throw new UnableToCompleteException();
		}

		return composerHelper.getCreatedClassName();
	}

	
	private void createInnerBindedModelProxyInterface() throws NotFoundException {
		ModelBinder modelBinder = type.getAnnotation(ModelBinder.class);
		JClassType binderType 	= type.getOracle().getType(modelBinder.binder().getCanonicalName());
		Binder binderAnnotation = binderType.getAnnotation(Binder.class);

		Clazz clazz = new Clazz(Visibility.PUBLIC, binderAnnotation.bindedModel().getSimpleName()+type.getSimpleSourceName()+"Proxy", true);
		clazz.addSuperClass(IBindedModelProxy.class);

		Annotation bindedModelProxyAnnotation = new Annotation(BindedModelProxy.class.getCanonicalName());
		bindedModelProxyAnnotation.addParameter("type="+binderAnnotation.bindedModel().getCanonicalName()+".class");

		clazz.addAnnotation(bindedModelProxyAnnotation);

		composerHelper.addInnerClass(clazz);

		constructor.getBody().append(String.format("this.bindedModelProxy = GWT.create(%s.class)", clazz.getName()));
		constructor.getBody().append("this.bindedModelProxy.setBindedModel(bindedModel)");
	}

	
	private void createFields(){
		//add fields
		Field binderField 			= new Field(Visibility.PRIVATE, IBinder.class, "binder");
		Field bindedModelField 		= new Field(Visibility.PRIVATE,Object.class,"bindedModel");
		Field bindedModelProxyField	= new Field(Visibility.PRIVATE,IBindedModelProxy.class,"bindedModelProxy");

		composerHelper.addField(binderField);
		composerHelper.addField(bindedModelField);
		composerHelper.addField(bindedModelProxyField);

		//create fields getters and setters
		Method binderFieldGetter = binderField.getGetter(true);
		Method bindedModelGetter = bindedModelField.getGetter(true);
		Method bindedModelSetter = bindedModelField.getSetter(true,false);
		Method bindedModelProxyGetter = bindedModelProxyField.getGetter(true);

		//change ref of bindedModel in handler
		bindedModelSetter.getBody().append("this.binderHandler.setBindedModel(bindedModel)");
		bindedModelSetter.getBody().prepend("this."+binderField.getName()+"."+"initializeWatchedModel(this,"+bindedModelField.getName()+")");

		composerHelper.addMethod(binderFieldGetter);
		composerHelper.addMethod(bindedModelGetter);
		composerHelper.addMethod(bindedModelSetter);
		composerHelper.addMethod(bindedModelProxyGetter);
	}


	private void createContructor() throws Exception{
		Field binderHandlerField = new Field(Visibility.PRIVATE,BinderHandler.class,"binderHandler");
		composerHelper.addField(binderHandlerField);
		constructor  	= new Method(Visibility.PUBLIC, simpleClassName);

		Body body = new Body();
		ModelBinder modelBinder = type.getAnnotation(ModelBinder.class);

		if (modelBinder==null) throw new IllegalStateException(realTypeName+" must be annotatated with "+ModelBinder.class);
		composerHelper.addImport(GWT.class);

		JClassType binderType 	= type.getOracle().getType(modelBinder.binder().getCanonicalName());
		Binder binderAnnotation = binderType.getAnnotation(Binder.class);

		if (binderAnnotation==null) throw new IllegalStateException(binderType+" must be annotated with "+Binder.class);

		body.append("this.binder = GWT.create("+modelBinder.binder().getCanonicalName()+".class)");
		body.append("this.bindedModel = new "+binderAnnotation.bindedModel().getCanonicalName()+"()");
		body.append("this.binder.onInstantiation(this,this.bindedModel)");

		//add required imports

		composerHelper.addImport(Object.class);
		//composerHelper.addImport(Undo);

		//add listener
		body.instantiate(binderHandlerField, "this","binder","bindedModel");

		body.append("this.addHandler(binderHandler)");

		constructor.setBody(body);

		composerHelper.addMethod(constructor);
	}
	
	
	public void setType(JClassType type) {
		this.type = type;
	}


}
