/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.scope;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelscope.annotation.Resolve;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelscope.annotation.Scope;
import com.google.gwt.core.ext.typeinfo.JClassType;

public class ScopeBuilder {

	private JClassType classType;
	
	private HashMap<Class<?>, List<Node>> nodesByEnlosingType;
	private Scope scopeAnnotation;
	
	public ScopeBuilder(JClassType classType) {
		this.classType = classType;
		this.nodesByEnlosingType = new HashMap<Class<?>, List<Node>>();
	}
	
	public JClassType getClassType() {
		return classType;
	}
	
	
	private void buildNodes() throws ScopeBuilderException{
		
		this.scopeAnnotation = this.classType.getAnnotation(Scope.class);
		
		if (scopeAnnotation==null) throw new ScopeBuilderException(this.classType+" must be annotated with "+Scope.class);
		
		for(Resolve r : scopeAnnotation.resolvers()){
			
			Node node = new Node();
			
			node.setType(r.fieldType());
			node.setName(r.fieldName());
			node.setParent(r.enclosingType());
			node.setCollection(r.isCollection());
			
			List<Node> nodes = nodesByEnlosingType.get(r.enclosingType());
			
			if (nodes==null){
				nodes = new ArrayList<Node>();
			}
			
			nodes.add(node);
			
			nodesByEnlosingType.put(r.enclosingType(), nodes);
			
		}
		
	}
	
	
	private Node getRootNode(){
		
		Node rootNode = new Node();
		rootNode.setType(scopeAnnotation.model());
		
		addChildren(rootNode);
		
		return rootNode;
	}
	
	private void addChildren(Node node){
		
		List<Node> nodesChildren = nodesByEnlosingType.get(node.getType());
		
		
		if (nodesChildren!=null){
			
			node.getChildren().addAll(nodesChildren);
			
			for(Node child:nodesChildren){
				addChildren(child);
			}
			
		}
		
	}
	
	public com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.scope.Scope getScope() throws ScopeBuilderException{
		
		buildNodes();
		
		com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.scope.Scope scope = new com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.scope.Scope();
		
		scope.setModel(scopeAnnotation.model());
		
		scope.setRootNode(getRootNode());
		
		
		return scope;
	}
	
}
