/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.uibinder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.HasEditorProxyImpl;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IHasEditorProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.ITemplate;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IWidgetInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.annotation.Editor.Widget;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.CheckBoxInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.TextBoxInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ComposerHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Field;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JClassTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Visibility;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;

public class HasEditorProxyGenerator extends Generator{
	
	
	private ComposerHelper composerHelper;
	private JClassType type;
	private String className;
	private Field proxyImplField;
	
	
	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {
		
		String superClassName 	= typeName; 
		
		this.className			= type.getSimpleSourceName()+"_HasEditorProxy";
		this.composerHelper   	= new ComposerHelper(context, logger, type.getPackage().getName(), className);
		this.composerHelper.addInterface(IHasEditorProxy.class);
		this.composerHelper.setSuperClass(superClassName);	
		
		generateConstructor();
		
		generateGetEditorMethod();
		
		this.composerHelper.commit();
		
		return this.composerHelper.getCreatedClassName();
	}
	
	
	private void generateConstructor() {
	    proxyImplField = new Field(Visibility.PRIVATE, HasEditorProxyImpl.class, "proxyImpl");
		
	    composerHelper.addField(proxyImplField);
	    
		Method constructor  = new Method(Visibility.PUBLIC, className);
		constructor.getBody().append("super()");
		
		constructor.getBody().instantiate(proxyImplField, "this");
		
		Editor editorAnnotation = type.getAnnotation(Editor.class);
		if (editorAnnotation==null) throw new IllegalStateException(type+" must be annotated with "+Editor.class);
		
		//instantiate template
		constructor.getBody().append(String.format("%s template = new %s()", editorAnnotation.template().getCanonicalName(),editorAnnotation.template().getCanonicalName()));
		constructor.getBody().append("template.setEditorModel(this)");
		//set template
		constructor.getBody().append("proxyImpl.setTemplate(template)");
		
		this.composerHelper.addMethod(constructor);
	}
	
	
	private void generateGetEditorMethod() {
		Method getEditorMethod = new Method(Visibility.PUBLIC, ITemplate.class, "getEditor");
		getEditorMethod.isOverride(true);
		getEditorMethod.addParameter(getEditorMethod.new Parameter(Object.class, "dataProvider"));
		
		//register instantiation handlers and labels
		JClassTypeHelper helper = new JClassTypeHelper(type);
		
		int cptPosition = 0;
		for(JField field:helper.getAllFields()) {
			Widget widget = field.getAnnotation(Widget.class);
			
			if (widget!=null){
				//register label
				getEditorMethod.getBody().append(String.format("proxyImpl.registerLabel(\"%s\",\"%s\")",field.getName(), widget.label()));

				//register position
				int order = widget.order();
				if (order==-1){
					order = 10000 + cptPosition++ ;
				}

				getEditorMethod.getBody().append(String.format("proxyImpl.registerPosition(\"%s\",%s)", field.getName(),order));
				
				//register instantiation handler
				Class<? extends IWidgetInstantiationHandler> ihClazz = (Class<? extends IWidgetInstantiationHandler>) widget.instantiationHandler() ;
				
				if (ihClazz==IWidgetInstantiationHandler.class){
					ihClazz = getPrimitiveInstantiationHandler(JTypeHelper.getClass(field.getType()));
				}
				
				if (ihClazz==null){
					throw new IllegalStateException("Instantiation handler is null for field "+field.getName());
				}
				
				String iHVarName = field.getName()+"instantiationHandler";
				getEditorMethod.getBody().instantiate(ihClazz, iHVarName);
				//set data provider and editor model on instantiation handler 
				getEditorMethod.getBody().append(iHVarName+".setDataProvider(dataProvider)");
				getEditorMethod.getBody().append(iHVarName+".setEditorModel(this)");
				
				getEditorMethod.getBody().append(String.format("proxyImpl.registerWidgetInstantiationHandler(\"%s\",(%s)%s)", field.getName(),IWidgetInstantiationHandler.class.getCanonicalName(),iHVarName));
			}

		}
		
		
		
		getEditorMethod.getBody().append(String.format("return %s.getEditor(dataProvider)", proxyImplField.getName()));
		composerHelper.addMethod(getEditorMethod);
	}
	
	
	private Class<? extends IWidgetInstantiationHandler<?>> getPrimitiveInstantiationHandler(Class<?> type){
		if (type==Boolean.class || type==boolean.class){
			return CheckBoxInstantiationHandler.class;
		}else if (type==String.class){
			return TextBoxInstantiationHandler.class;
		}else if (Number.class.isAssignableFrom(type)){
			return TextBoxInstantiationHandler.class;
		}
		return null;
	}
	
	
	public void setType(JClassType type) {
		this.type = type;
	}
	
}
