/**
 * api - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.api.components.menu;

public interface IMainMenuComponent extends IMenuComponent{
	
	//FILE
	IMenuButtonItem getFileButton();
	
	IMenuItem getNewItem();
	
	IMenuItem getOpenItem();
	
	IMenuItem getSaveItem();
	
	IMenuItem getImportItem();
	
	IMenuItem getExportItem();
	
	void addFileButton();
	
	//EDIT
	IMenuButtonItem getEditButton();
	
	IMenuItem getCopyItem();
	
	IMenuItem getPasteItem();
	
	IMenuItem getDeleteItem();
	
	IMenuItem getSelectAllItem();
	
	void addEditButton();
	
	//PROJECT
	IMenuButtonItem getProjectButton();
	
	IMenuItem getValidateProjectItem();
	
	IMenuItem getEditProjectItem();
	
	void addProjectButton();
	
	//HELP
	IMenuButtonItem getHelpButton();
	
	IMenuItem getWelcomeItem();
	
	void addHelpButton();
}
