/**
 * api - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.api.core.events;

import net.customware.gwt.presenter.client.EventBus;
import net.customware.gwt.presenter.client.place.PlaceChangedHandler;

import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.events.IPluginManagerHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.ISystemContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.IUserContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.events.IProjectHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.request.IRequestHandler;

public interface IEditorEventBus extends EventBus{

	void addProjectHandler(IProjectHandler handler);
	
	void addProjectConfigurationHandler(IProjectConfigurationHandler handler);
	
	void addPluginManagerHandler(IPluginManagerHandler handler);
	
	void addContentPanelPlaceHolderHandler(IContentPanelPlaceHolderHandler handler);
	
	void addRequestHandler(IRequestHandler handler);
	
	void addPlaceChangeHandler(PlaceChangedHandler handler);
	
	void addPluginHandler();
	
	void addLayoutHandler();
	
	void addComponentHandler();
	
	void addMenuComponentHandler();
	
	void addEditorHandler(IEditorHandler handler);
	
	void addUserContentHandler(IUserContentHandler handler);
	
	void addSystemContentHandler(ISystemContentHandler handler);
}
