/**
 * domain - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.impl.domain.project;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.google.gwt.user.client.rpc.IsSerializable;

public class ProjectFile implements IProjectFile ,IsSerializable{
	
	private String id;
	private String path;
	private String name;
	private IProjectType projectType;
	private IProjectInstanceFormat format;
	private IProjectInstance instance;
	private List<IProjectInstanceMetaData> metadata;
	
	public ProjectFile() {
		
		this.metadata = new ArrayList<IProjectInstanceMetaData>();
		
	}
	
	@Override
	public String getAbsolutePath() {
		return path;
	}

	
	@Override
	public String getName() {
		return name;
	}

	@Override
	public void setName(String name) {
		this.name = name;
	}


	@Override
	public void setAbsolutePath(String path) {
		this.path = path;
	}

	@Override
	public IProjectType getProjectType() {
		return projectType;
	}

	@Override
	public void setProjectType(IProjectType projectType) {
		this.projectType = projectType;
	}

	@Override
	public IProjectInstanceFormat getFormat() {
		return format;
	}

	@Override
	public void setFormat(IProjectInstanceFormat format) {
		this.format = format;
	}

	@Override
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
	}

	@Override
	public IProjectInstance getProjectInstance() {
		return instance;
	}

	@Override
	public void setProjectInstance(IProjectInstance instance) {
		this.instance = instance;
	}

	@Override
	public void addMetaData(IProjectInstanceMetaData metaData) {
		this.metadata.add(metaData);
	}

	@Override
	public List<IProjectInstanceMetaData> getMetaDatas() {
		return metadata;
	}

	@Override
	public void removeMetaData(IProjectInstanceMetaData medaData) {
		this.metadata.add(medaData);
	}

}
