/**
 * domain - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.impl.domain.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.google.gwt.user.client.rpc.IsSerializable;

public class ProjectType implements IProjectType ,IsSerializable{
	
	private String description;
	private String name;
	private List<IProjectType> subProjectTypes;
	private String id;
	private String loaderQname;
	private String writerQname;
	private IProjectInstanceFormat format;
	private List<IProjectInstanceFormat> importFormats;
	private List<IProjectInstanceFormat> exportFormats;
	private HashMap<IProjectInstanceFormat, String> metaDataLoaderQnames;
	
	public ProjectType() {
		
	}
	
	public ProjectType(String id,String name,String description) {
		this.id					= id;
		this.subProjectTypes 	= new ArrayList<IProjectType>();
		this.name 				= name;
		this.description 		= description;
		this.metaDataLoaderQnames = new HashMap<IProjectInstanceFormat, String>();
	}
	
	public ProjectType(String id,String name,String description,List<IProjectInstanceFormat> importFormats,List<IProjectInstanceFormat> exportFormats) {
		this(id,name,description);
		this.importFormats = importFormats;
		this.exportFormats = exportFormats;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public String getName() {
		return name;
	}

	public void setSubProjectTypes(List<IProjectType> subProjectTypes) {
		this.subProjectTypes = subProjectTypes;
	}
	
	@Override
	public List<IProjectType> getSubProjectType() {
		return subProjectTypes;
	}

	@Override
	public void addSubProjectType(IProjectType subProjectType) {
		this.subProjectTypes.add(subProjectType);
	}
	
	@Override
	public boolean equals(Object obj) {
		return this.getId().equals(((ProjectType)obj).getId());
	}
	
	@Override
	public int hashCode() {
		return this.getName().hashCode();
	}
	
	public void setId(String id) {
		this.id = id;
	}
	
	@Override
	public String getId() {
		return id;
	}

	@Override
	public String getProjectInstanceLoaderQname() {
		return loaderQname;
	}



	@Override
	public String getProjectInstanceWriteQname() {
		return writerQname;
	}

	@Override
	public IProjectInstanceFormat getProjectTypeFormat() {
		return format;
	}
	
	public void setLoaderQname(String loaderQname) {
		this.loaderQname = loaderQname;
	}
	
	public void setWriterQname(String writerQname) {
		this.writerQname = writerQname;
	}
	
	public void setFormat(IProjectInstanceFormat format) {
		this.format = format;
	}

	@Override
	public List<IProjectInstanceFormat> getExportFormats() {
		return exportFormats;
	}

	@Override
	public List<IProjectInstanceFormat> getImportFormats() {
		return importFormats;
	}

	public void setImportFormats(List<IProjectInstanceFormat> importFormats) {
		this.importFormats = importFormats;
	}

	public void setExportFormats(List<IProjectInstanceFormat> exportFormats) {
		this.exportFormats = exportFormats;
	}
	
	public void addMetaDataLoaderQname(IProjectInstanceFormat format,String qname){
		this.metaDataLoaderQnames.put(format, qname);
	}
	
	@Override
	public HashMap<IProjectInstanceFormat, String> getMetaDataLoaderQnames() {
		return metaDataLoaderQnames;
	}
	
	
	
	
}
