/**
 * ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.component.menu;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenu;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuButtonItem;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItem;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemAction;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemClickHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemGroup;
import com.google.gwt.user.client.ui.Image;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;


public class GWTExtMenuComponentButton extends ToolbarButton implements IMenuButtonItem{
	
	private IMenu menu;
	private IMenuItemAction action;
	private IMenuItemGroup group;
	private IMenuItemClickHandler clickHandler;
	private boolean enabled;
	
	public GWTExtMenuComponentButton() {
		
		this.addListener(new ButtonListenerAdapter(){
			@Override
			public void onClick(Button button, EventObject e) {
			
				getClickHandler().onClick();
				
			}
		});

	}

	public GWTExtMenuComponentButton(String text) {
		super(text);
	}
	
	public GWTExtMenuComponentButton(Image img){
		this();
		this.setIcon(img.getUrl());
	}
	
	
	@Override
	public IMenu getMenu() {
		return menu;
	}

	@Override
	public void setMenu(IMenu menu) {
		this.menu = new GWTExtMenu();
		
		if (menu!=null){
			for(IMenuItem m:menu.getMenuItems()){
				
				this.menu.addMenuItem(m);
				
			}
		}
		
		this.setMenu((com.gwtext.client.widgets.menu.Menu)menu);
		
	}

	@Override
	public IMenuItemAction getAction() {
		return action;
	}

	@Override
	public IMenuItemGroup getGroup() {
		return group;
	}

	@Override
	public void setAction(IMenuItemAction action) {
		this.action = action;
	}

	@Override
	public void setGroup(IMenuItemGroup group) {
		this.group = group;
	}

	@Override
	public IMenuItemClickHandler getClickHandler() {
		return clickHandler;
	}

	@Override
	public void setClickHandler(IMenuItemClickHandler clickHandler) {
		this.clickHandler = clickHandler;
	}

	@Override
	public void setEnabled(boolean b) {
		this.enabled = b;
		if (b==false){
			this.setDisabled(true);
			
		}else{
			this.setDisabled(false);
		}
	}
	
	@Override
	public boolean isEnabled() {
		return this.enabled;
	}

}
