/**
 * ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.component.menu;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IQualifiedName;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IMenuItemHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenu;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItem;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemAction;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemClickHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemGroup;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.menu.BaseItem;
import com.gwtext.client.widgets.menu.event.BaseItemListenerAdapter;

public class GWTExtMenuItem extends com.gwtext.client.widgets.menu.MenuItem implements IMenuItem{
	
	private GWTExtMenu subMenu;
	private IMenuItemClickHandler clickHandler;
	private IMenuItemAction action;
	private IMenuItemGroup group;
	private boolean enable;
	
	public GWTExtMenuItem() {
		//this.subMenu = new GWTExtMenu();
		//this.setMenu(subMenu);
	}
	
	public GWTExtMenuItem(String text) {
		this();
		this.setText(text);

		this.addListener(new BaseItemListenerAdapter(){
			
			@Override
			public void onClick(BaseItem item, EventObject e) {
			
				getClickHandler().onClick();
			
			}
			
		});
	}
	
	@Override
	public void addHandler(IMenuItemHandler handler) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public IMenuItemClickHandler getClickHandler() {
		return clickHandler;
	}

	

	@Override
	public IQualifiedName getQualifiedName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setClickHandler(IMenuItemClickHandler clickHandler) {
		this.clickHandler = clickHandler;
	}

	

	@Override
	public void setQualifiedName(IQualifiedName qname) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void setSubMenu(IMenu menu) {
		
		this.subMenu = new GWTExtMenu();

		
		if (menu!=null){
			for(IMenuItem m:menu.getMenuItems()){
				
				this.subMenu.addMenuItem(m);
				
			}
		}
		
		this.setMenu(subMenu);	

	}


	@Override
	public IMenu getSubMenu() {
		return this.subMenu;
	}

	@Override
	public IMenuItemAction getAction() {
		return action;
	}

	@Override
	public IMenuItemGroup getGroup() {
		return group;
	}

	@Override
	public void setAction(IMenuItemAction action) {
		this.action = action;
	}

	@Override
	public void setGroup(IMenuItemGroup group) {
		this.group = group;
	}

	@Override
	public boolean isEnable() {
		return this.enable;
	}

	@Override
	public void setEnable(boolean b) {
		if (b==false){
			this.setDisabled(true);
		}else{
			this.setDisabled(false);
		}
		this.enable = b;
	}



}
