/**
 * ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.component.menu;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMainMenuComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuButtonItem;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItem;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events.ComponentLoadedEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.menu.MenuComponent;
import com.gwtext.client.widgets.Toolbar;


public class MainMenuComponent extends MenuComponent implements IMainMenuComponent{
	

	private Toolbar toolbar;
	
	
	private IMenuButtonItem fileButton;
	private IMenuButtonItem editButton;
	private IMenuButtonItem helpButton;
	private IMenuButtonItem projectButton;
	
	//File
	private IMenuItem newItem;
	private IMenuItem openItem;
	private IMenuItem saveItem;
	private IMenuItem importItem;
	private IMenuItem exportItem;

	//Edit
	private IMenuItem copyItem;
	private IMenuItem pasteItem;
	private IMenuItem deleteItem;
	private IMenuItem selectAllItem;
	
	//Project
	private IMenuItem validateItem;
	private IMenuItem editProjectItem;	
	
	//Help
	private IMenuItem welcomeItem;

	
	
	public MainMenuComponent() {
		super();

		this.toolbar   = new Toolbar();

		initWidget(toolbar);
	}
	
	
	@Override
	public String getId() {
		return this.getElement().getId();
	}
	
	@Override
	protected void onLoad() {
		super.onLoad();
		this.fireEvent(new ComponentLoadedEvent());
		

	}

	@Override
	public void addMenuButton(IMenuButtonItem button) {
		
		GWTExtMenuComponentButton mcb = new GWTExtMenuComponentButton();
		mcb.setText(button.getText());
		mcb.setMenu(button.getMenu());
		
		this.toolbar.addButton(mcb);
		
		super.addMenuButton(mcb);
	}

	@Override
	public IMenuItem getExportItem() {
		
		if (exportItem==null){
			this.exportItem = new GWTExtMenuItem("Export");
			
		}
		
		return exportItem;
	}

	@Override
	public IMenuButtonItem getFileButton() {
		
		if (fileButton==null){
			this.fileButton = new GWTExtMenuComponentButton("File");
		}
		
		return fileButton;
	}

	@Override
	public IMenuItem getImportItem() {
		
		if (importItem==null){
			this.importItem = new GWTExtMenuItem("Import");
		}
		
		return importItem;
	}

	@Override
	public IMenuItem getNewItem() {
		
		if (newItem==null){
			this.newItem = new GWTExtMenuItem("New");
		}
		
		return newItem;
	}

	@Override
	public IMenuItem getOpenItem() {
		
		if (openItem==null){
			this.openItem = new GWTExtMenuItem("Open");
		}
		
		return openItem;
	}

	@Override
	public IMenuItem getSaveItem() {
		
		if (saveItem==null){
			this.saveItem = new GWTExtMenuItem("Save");
		}
		
		return saveItem;
	}

	@Override
	public void addFileButton() {
		
		GWTExtMenu menu = new GWTExtMenu();

		menu.addMenuItem(getNewItem());
		menu.addMenuItem(getOpenItem());
		menu.addMenuItem(getSaveItem());
		menu.addMenuItem(getImportItem());
		menu.addMenuItem(getExportItem());
		
		getFileButton().setMenu(menu);
	

		
		this.addMenuButton(fileButton);
		
	}


	@Override
	public void addEditButton() {
		
		GWTExtMenu menu = new GWTExtMenu();
		
		menu.addMenuItem(getCopyItem());
		menu.addMenuItem(getPasteItem());
		menu.addMenuItem(getDeleteItem());
		menu.addMenuItem(getSelectAllItem());
		
		getEditButton().setMenu(menu);
		
		this.addMenuButton(editButton);
	}


	@Override
	public void addHelpButton() {
	
		GWTExtMenu menu = new GWTExtMenu();
		
		menu.addMenuItem(getWelcomeItem());
		
		getHelpButton().setMenu(menu);
		
		this.addMenuButton(helpButton);
	}


	@Override
	public void addProjectButton() {
		
		GWTExtMenu menu = new GWTExtMenu();
		
		menu.addMenuItem(getValidateProjectItem());
		menu.addMenuItem(getEditProjectItem());
		
		getProjectButton().setMenu(menu);
		
		this.addMenuButton(projectButton);
	}


	@Override
	public IMenuItem getCopyItem() {
		
		if (copyItem==null){
			this.copyItem = new GWTExtMenuItem("Copy");
		}
		
		return copyItem;
	}


	@Override
	public IMenuItem getDeleteItem() {
		
		if (deleteItem==null){
			this.deleteItem = new GWTExtMenuItem("Delete");
		}
		
		return deleteItem;
	}


	@Override
	public IMenuButtonItem getEditButton() {
		
		if (editButton==null){
			this.editButton = new GWTExtMenuComponentButton("Edit");
		}
		
		return editButton;
	}


	@Override
	public IMenuItem getEditProjectItem() {
		
		if (editProjectItem==null){
			this.editProjectItem = new GWTExtMenuItem("Edit");
		}
		
		
		return editProjectItem;
	}


	@Override
	public IMenuButtonItem getHelpButton() {
		
		if  (helpButton==null){
			this.helpButton = new GWTExtMenuComponentButton("Help");
		}
		
		return helpButton;
	}


	@Override
	public IMenuItem getPasteItem() {
		
		if (pasteItem==null){
			this.pasteItem = new GWTExtMenuItem("Paste");
		}
		
		return pasteItem;
	}


	@Override
	public IMenuButtonItem getProjectButton() {
		
		if (projectButton==null){
			this.projectButton = new GWTExtMenuComponentButton("Project");
		}
		
		return projectButton;
	}


	@Override
	public IMenuItem getSelectAllItem() {
		
		if (selectAllItem==null){
			this.selectAllItem = new GWTExtMenuItem("Select All");
		}
		
		return selectAllItem;
	}


	@Override
	public IMenuItem getValidateProjectItem() {
		
		if (validateItem==null){
			this.validateItem = new GWTExtMenuItem("Validate");
		}
		
		return validateItem;
	}


	@Override
	public IMenuItem getWelcomeItem() {
		
		if (welcomeItem==null){
			this.welcomeItem = new GWTExtMenuItem("Welcome");
		}
		
		return welcomeItem;
	}	
	
}
