/**
 * ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.component.toolbar;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuButtonItem;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemGroup;
import com.ebmwebsourcing.geasytools.webeditor.api.components.toolbar.IToolbarComponent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.menu.DefaultMenuItemActionCategories;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.menu.MenuComponent;
import com.ebmwebsourcing.geasytools.webeditor.ui.component.menu.GWTExtMenuComponentButton;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Image;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;

public class ToolbarComponent extends MenuComponent implements IToolbarComponent{

	private Toolbar toolbar;

	private GWTExtMenuComponentButton deleteBtn;
	private GWTExtMenuComponentButton validateBtn;
	private GWTExtMenuComponentButton copyBtn;
	private GWTExtMenuComponentButton cutBtn;
	private GWTExtMenuComponentButton pasteBtn;
	private GWTExtMenuComponentButton exportBtn;
	private GWTExtMenuComponentButton importBtn;
	private GWTExtMenuComponentButton saveBtn;
	private GWTExtMenuComponentButton openBtn;
	
	private LinkedHashMap<IMenuItemGroup, List<IMenuButtonItem>> btnsByCategory;

	
	public ToolbarComponent() {
		super();
		
		this.toolbar = new Toolbar();
		
		this.btnsByCategory = new LinkedHashMap<IMenuItemGroup, List<IMenuButtonItem>>();

		initWidget(toolbar);
	}

	@Override
	public String getId() {
		return this.getElement().getId();
	}
	
	@Override
	public void addMenuButton(IMenuButtonItem button) {
		
		//check if this btn group doesnt exist yet
		List<IMenuButtonItem> componentBtns = btnsByCategory.get(button.getGroup());
		
		if (componentBtns==null){
			
			componentBtns = new ArrayList<IMenuButtonItem>(); 
			
		}
		
		componentBtns.add(button);
		
		btnsByCategory.put(button.getGroup(), componentBtns);
		
		super.addMenuButton(button);
	}
	
	@Override
	public IMenuButtonItem getCopyMenuItem() {
		
		if (copyBtn==null){
			this.copyBtn = new GWTExtMenuComponentButton(new Image(GWT.getModuleBaseURL()+"/images/ico/copy.png"));
			this.copyBtn.setGroup(DefaultMenuItemActionCategories.EDIT);
			this.copyBtn.setTitle("Copy");
		}
		
		return copyBtn;
	}

	@Override
	public IMenuButtonItem getCutMenuItem() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IMenuButtonItem getDeleteBtn() {

		if (deleteBtn==null){
			this.deleteBtn = new GWTExtMenuComponentButton(new Image(GWT.getModuleBaseURL()+"/images/ico/delete.png"));
			this.deleteBtn.setGroup(DefaultMenuItemActionCategories.EDIT);
			this.deleteBtn.setTitle("Delete selected element");
		}
		
		return deleteBtn;
	}

	@Override
	public IMenuButtonItem getExportMenuItem() {
		if (exportBtn==null){
			this.exportBtn = new GWTExtMenuComponentButton(new Image(GWT.getModuleBaseURL()+"/images/ico/export.png"));
			this.exportBtn.setGroup(DefaultMenuItemActionCategories.FILE);
			this.exportBtn.setTitle("Export actual project");
		}
		
		return exportBtn;
	}

	@Override
	public IMenuButtonItem getNewMenuItem() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IMenuButtonItem getPasteMenuItem() {
		if (pasteBtn==null){
			this.pasteBtn = new GWTExtMenuComponentButton(new Image(GWT.getModuleBaseURL()+"/images/ico/paste.png"));
			this.pasteBtn.setGroup(DefaultMenuItemActionCategories.EDIT);
			this.pasteBtn.setTitle("Paste");
		}
		
		return pasteBtn;
	}

	@Override
	public IMenuButtonItem getSaveMenuItem() {
		if (saveBtn==null){
			this.saveBtn = new GWTExtMenuComponentButton(new Image(GWT.getModuleBaseURL()+"/images/ico/save.png"));
			this.saveBtn.setGroup(DefaultMenuItemActionCategories.FILE);
			this.saveBtn.setTitle("Save actual project");
		}
		
		return saveBtn;
	}

	@Override
	public IMenuButtonItem getValidateMenuItem() {
		
		if (validateBtn==null){
			this.validateBtn = new GWTExtMenuComponentButton(new Image(GWT.getModuleBaseURL()+"/images/ico/validate.png"));
			this.validateBtn.setGroup(DefaultMenuItemActionCategories.PROJECT);
			this.validateBtn.setTitle("Validate actual project");
		}
		
		return validateBtn;
	}

	@Override
	public void addBtns() {
		
		for(IMenuItemGroup g:btnsByCategory.keySet()){
			
			for(IMenuButtonItem b:btnsByCategory.get(g)){
				
//				GWTExtMenuComponentButton mcb = new GWTExtMenuComponentButton();
//				mcb.setText(b.getText());
//				mcb.setClickHandler(b.getClickHandler());
//				mcb.setEnabled(b.isEnabled());
				toolbar.addButton((ToolbarButton) b);
				
			}
			
			toolbar.addSeparator();
		}
		
	}

	@Override
	public IMenuButtonItem getImportMenuItem() {
		if (importBtn==null){
			this.importBtn = new GWTExtMenuComponentButton(new Image(GWT.getModuleBaseURL()+"/images/ico/import.png"));
			this.importBtn.setGroup(DefaultMenuItemActionCategories.FILE);
			this.importBtn.setTitle("Import a file");
		}
		
		return importBtn;
	}

	@Override
	public IMenuButtonItem getOpenMenuItem() {
		if (openBtn==null){
			this.openBtn = new GWTExtMenuComponentButton(new Image(GWT.getModuleBaseURL()+"/images/ico/open.png"));
			this.openBtn.setGroup(DefaultMenuItemActionCategories.FILE);
			this.openBtn.setTitle("Open a project");
		}
		
		return openBtn;
	}



}
