/**
 * ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.core;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMainMenuComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.toolbar.IToolbarComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.DefaultErrorLevel;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorErrorLevel;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IConfirmDialogCallBack;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.ILayout;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IExportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IImportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IOpenProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.upload.IUploadWindow;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.AbstractEditorView;
import com.ebmwebsourcing.geasytools.webeditor.ui.component.menu.MainMenuComponent;
import com.ebmwebsourcing.geasytools.webeditor.ui.component.toolbar.ToolbarComponent;
import com.ebmwebsourcing.geasytools.webeditor.ui.layout.DefaultLayout;
import com.ebmwebsourcing.geasytools.webeditor.ui.project.configuration.view.EditProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.ui.project.configuration.view.ExportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.ui.project.configuration.view.ImportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.ui.project.configuration.view.OpenProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.ui.upload.UploadWindow;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Ext;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.layout.FitLayout;

public class EditorView extends AbstractEditorView{
	
	private DefaultLayout defaultLayout;
	
	private IMainMenuComponent mainMenu;
	private IOpenProjectConfigurationView openView;
	private IImportProjectConfigurationView importView;
	private IExportProjectConfigurationView exportView;
	private IEditProjectConfigurationView editView;
	
	private IToolbarComponent toolbar;
	private Panel panel;
	
	private UploadWindow uploadWindow;
	
	public EditorView() {

		this.mainMenu = new MainMenuComponent();
		this.toolbar  = new ToolbarComponent();

		this.openView 	= new OpenProjectConfigurationView();
		this.importView = new ImportProjectConfigurationView();
		this.exportView = new ExportProjectConfigurationView();
		this.editView   = new EditProjectConfigurationView();
		
		this.uploadWindow = new UploadWindow();
	}
	
	@Override
	public Widget getMainWidget() {
	     
		this.panel = new Panel();  
         
	     panel.setBorder(false);  
         panel.setLayout(new FitLayout());  
	   
	     panel.add((Widget) getDefaultLayout());    
	         
		return panel;
	}

	public ILayout getDefaultLayout() {

		if (defaultLayout==null){
			this.defaultLayout = new DefaultLayout();
		}
		
		return defaultLayout;
	}

	public IMainMenuComponent getMainMenuComponent() {
		return mainMenu;
	}

	@Override
	public IExportProjectConfigurationView getExportProjectConfigurationView() {
		return exportView;
	}

	@Override
	public IImportProjectConfigurationView getImportProjectConfigurationView() {
		return importView;
	}

	@Override
	public IOpenProjectConfigurationView getOpenProjectConfigurationView() {
		return openView;
	}

	@Override
	public IToolbarComponent getToolbarComponent() {
		return toolbar;
	}

	@Override
	public void disableLoadingState() {
		Ext.get(panel.getElement().getId()).unmask();
	}

	@Override
	public void enableLoadingState(String message) {
		Ext.get(panel.getElement().getId()).mask(message, true);
	}

	@Override
	public void displayError(String title, String message,
			IEditorErrorLevel level) {

		MessageBox.alert(title, message);

		if (level==DefaultErrorLevel.INFO){
			
			MessageBox.setIconCls(MessageBox.INFO);
			
		}else if (level==DefaultErrorLevel.WARNING){
			
			MessageBox.setIconCls(MessageBox.WARNING);
			
		}else if (level==DefaultErrorLevel.QUESTION){
			
			MessageBox.setIconCls(MessageBox.QUESTION);
			
		}else if (level==DefaultErrorLevel.ERROR){
			
			MessageBox.setIconCls(MessageBox.ERROR);
		}
		
	}

	@Override
	public IEditProjectConfigurationView getEditProjectConfigurationView() {
		return editView;
	}

	@Override
	public IUploadWindow getUploadWindow() {
		return uploadWindow;
	}

	@Override
	public void displayConfirmDialog(String title, String message,
			final IConfirmDialogCallBack dialogCallback) {
		
		MessageBox.confirm(title, message,  
                new MessageBox.ConfirmCallback() {  
                    public void execute(String btnID) {  
                        
                    	if (btnID.equals("yes")){
                    		
                    		dialogCallback.onConfirm(true);
                    		
                    	}else{
                    		
                    		dialogCallback.onConfirm(false);
                    		
                    	}
                    	
                    }  
                });  
		
	}

}
