/**
 * ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.project.configuration.view;

import com.ebmwebsourcing.geasytools.gwtextwidgets.input.TextBox;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditProjectConfigurationPanel;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectConfigurationData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.impl.domain.project.DefaultProjectConfigurationData;
import com.google.gwt.user.client.ui.HasValue;
import com.gwtext.client.widgets.form.Checkbox;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.Label;
import com.gwtext.client.widgets.layout.VerticalLayout;

public class EditProjectConfigurationPanel extends ConfigurationPanel implements IEditProjectConfigurationPanel{
	
	private TextBox projectName;
	private Checkbox isPublic;
	private Checkbox autoSave;
	private Label authorLabel;
	private Label creationDateLabel;
	
	public EditProjectConfigurationPanel() {
		
		this.setTitle("Project");
		this.setHeader(false);
		
		FormPanel form = new FormPanel();
		form.setBorder(false);
		
		
		
		this.add(form);
		
		this.projectName = new TextBox();
		this.projectName.setFieldLabel("Project Name");
		this.isPublic    = new Checkbox();
		this.autoSave	 = new Checkbox(); 
		
		this.authorLabel = new Label();
		this.creationDateLabel = new Label();
		
		isPublic.setFieldLabel("Public Project");
		autoSave.setFieldLabel("Auto Save");
		
		form.add(projectName);
		form.add(isPublic);
		form.add(autoSave);
		
		this.add(authorLabel);
		this.add(creationDateLabel);
		this.setLayout(new VerticalLayout(20));
		
		
		this.setPixelSize(450, 500);
		this.projectName.setLabel("Project Name");
		this.setFrame(true);
		this.setBorder(false);
		

	}
	
	@Override
	public HasValue<String> getProjectName() {
		return null;
	}

	@Override
	public HasValue<Boolean> isPublic() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getConfigurationName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void onLoad(IProjectInstance projectInstance) {
		
		projectName.setValue(projectInstance.getName());
		isPublic.setValue(projectInstance.isPublic());
		autoSave.setValue(projectInstance.isAutoSave());
		if (projectInstance.getAuthor()!=null) authorLabel.setText("Author: "+projectInstance.getAuthor().getLogin());
		if (projectInstance.getCreationDate()!=null) creationDateLabel.setText("Creation Date: "+projectInstance.getCreationDate().toString());
	
	}

	@Override
	public IProjectConfigurationData onValidate() {
		
		DefaultProjectConfigurationData defaultProjectConfigurationData = new DefaultProjectConfigurationData();
		
		defaultProjectConfigurationData.setProjectName(projectName.getValue());
		defaultProjectConfigurationData.setPublic(isPublic.getValue());
		defaultProjectConfigurationData.setAutoSave(autoSave.getValue());
		
		return defaultProjectConfigurationData;
	}


}
