/**
 * ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.project.configuration.view;

import gwtupload.client.IUploader;
import gwtupload.client.SingleUploader;

import java.util.ArrayList;

import com.ebmwebsourcing.geasytools.gwtextwidgets.file.FolderPanel;
import com.ebmwebsourcing.geasytools.gwtextwidgets.input.ComboBox;
import com.ebmwebsourcing.geasytools.gwtextwidgets.wizard.Wizard;
import com.ebmwebsourcing.geasytools.gwtextwidgets.wizard.WizardFrame;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.view.AbstractImportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.widgets.core.api.input.IComboBox;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolderPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IFrame;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IWizard;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.HTMLPanel;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.WindowListenerAdapter;
import com.gwtext.client.widgets.layout.HorizontalLayout;
import com.gwtext.client.widgets.layout.VerticalLayout;

public class ImportProjectConfigurationView extends AbstractImportProjectConfigurationView{
	
	private Wizard wizard;
	private FolderPanel folderPanel;
	private Window window;
	private IUploader uploader;
	private Button uploaderBtn;
	private ComboBox<IProjectInstanceFormat> importFormats;
	private HasValue<String> importFormatDescription;
	private Label importFormatDescriptionLBL;

	
	
	public ImportProjectConfigurationView() {
		
		this.window = new Window();
		this.window.setTitle("Import Project");
		this.window.setCloseAction(Window.HIDE);
		this.window.setResizable(false);
		this.window.addListener(new WindowListenerAdapter(){
			
			@Override
			public void onHide(Component component) {
				
				History.newItem("");
				
			}
			
		});
		
		this.importFormatDescriptionLBL = new Label();

		ArrayList<IFrame> frames = new ArrayList<IFrame>();
		
		frames.add(getFrame1());
		
		this.getWizard().setFrames(frames);
		
		
		Panel headerPanel  = new HTMLPanel("<b>Import From File</b> <br> <span>Select the project type and the file to import from your desktop, than select the format of the file that your are ready to upload</span>");
		headerPanel.setHeight(50);
		headerPanel.setMargins(0, 0, 0, 5);
		this.window.add(headerPanel);
		
		window.add((Widget) getWizard());
		getUploader().setFileInputSize(20);
		

		window.add(uploaderBtn);
	
	}

	@Override
	public IFolderPanel getFolderPanel() {
		
		if (folderPanel==null){
			this.folderPanel = new FolderPanel();
			this.folderPanel.setWidth(300);
			this.folderPanel.setHeight(200);
		}
		
		return folderPanel;
	}



	@Override
	public IWizard getWizard() {
		
		if (wizard==null){
			this.wizard = new Wizard(650,200);
			((Wizard)this.wizard).setVisible(false);//bug: on instantiation wizard is added to rootpanel
		}
		
		return wizard;
	}

	@Override
	public void close() {
		
		window.hide();
		
	}

	@Override
	public void open() {
		
		((Wizard)this.wizard).setVisible(true);
		((ComboBox<?>)this.getImportFormat()).setVisible(true);
		window.show();
		uploaderBtn.setVisible(false);
		window.doLayout();
	}

	@Override
	public void refresh() {
		importFormats.clear();
		folderPanel.clearSelection();
		importFormatDescriptionLBL.setText("");
	}
	
	private WizardFrame getFrame1(){
		
		WizardFrame frame = new WizardFrame((Wizard) getWizard());
		
		Panel hP1 = new Panel();
		hP1.setLayout(new HorizontalLayout(10));
		hP1.add((Widget) getFolderPanel());
		
		Panel verticalPanel1 = new Panel();
		verticalPanel1.setLayout(new VerticalLayout(10));
		
		Panel vp2 = new Panel();
		vp2.setLayout(new VerticalLayout(3));
		vp2.add(new Label("Select a file from your desktop:"));
		vp2.add((Widget) getUploader());
		
		verticalPanel1.add(vp2);
		
		Panel hp2 = new Panel();
		hp2.setLayout(new HorizontalLayout(3));
		hp2.add(new Label("File format:"));
		hp2.add((Widget) getImportFormat());
		verticalPanel1.add(hp2);
		
		verticalPanel1.add(this.importFormatDescriptionLBL);
		
		hP1.add(verticalPanel1);
		
		frame.add(hP1);
		

		return frame;
	}

	@Override
	public Widget asWidget() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void startProcessing() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void stopProcessing() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public IComboBox<IProjectInstanceFormat> getImportFormat() {
		
		if (importFormats==null){
			importFormats = new ComboBox<IProjectInstanceFormat>();
		}
		
		return importFormats;
	}

	@Override
	public HasValue<String> getImportFormatDescription() {
		
		if (importFormatDescription==null){
			
			importFormatDescription = new HasValue<String>() {
				
				@Override
				public void fireEvent(GwtEvent<?> event) {
					// TODO Auto-generated method stub
					
				}
				
				@Override
				public HandlerRegistration addValueChangeHandler(
						ValueChangeHandler<String> handler) {
					// TODO Auto-generated method stub
					return null;
				}
				
				@Override
				public void setValue(String value, boolean fireEvents) {

					
				}
				
				@Override
				public void setValue(String value) {

					importFormatDescriptionLBL.setText(value);
					
				}
				
				@Override
				public String getValue() {
					// TODO Auto-generated method stub
					return null;
				}
			};
			
		}
		
		return importFormatDescription;
	}

	@Override
	public IUploader getUploader() {
		
		if (this.uploader==null){
			
			this.uploaderBtn = new Button("upload file");

			this.uploader  = new SingleUploader(null,uploaderBtn);
			
		}
		
		return uploader;
	}


	

}
