/**
 * ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.upload;

import gwtupload.client.IUploader;
import gwtupload.client.SingleUploader;

import com.ebmwebsourcing.geasytools.webeditor.api.upload.IUploadWindow;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.WindowListenerAdapter;

public class UploadWindow extends Window implements IUploadWindow{
	
	private IUploader uploader;
	
	public UploadWindow() {
		this.setCloseAction(Window.HIDE);

		this.addListener(new WindowListenerAdapter() {
            @Override
            public void onHide(Component component) {
                remove((Widget)uploader);
            }
        });
	}
	
	@Override
	public void close() {
        this.remove((Widget)this.uploader);
		super.close();
	}
	
	@Override
	public IUploader getUploader() {
		return uploader;
	}

	@Override
	public void open() {
	    this.clear();
	    this.uploader = new SingleUploader();
	    this.add((Widget) uploader);
		this.show();
	}

	@Override
	public void setMessage(String message) {
		// TODO Auto-generated method stub
		
	}



}
