/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webeditor.impl.xstream;

import com.ebmwebsourcing.webeditor.api.IProjectDao;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.api.domain.user.IUser;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectInstance;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectType;
import com.ebmwebsourcing.webeditor.impl.domain.user.User;
import com.ebmwebsourcing.webeditor.impl.xstream.ProjectDao;
import com.ebmwebsourcing.webeditor.impl.xstream.ProjectTypeDao;
import java.io.File;
import java.util.List;
import junit.framework.Assert;
import org.apache.maven.doxia.util.FileUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProjectDaoTest {
    private static IProjectDao dao;

    @BeforeClass
    public static void init() {
        String BASE_PATH = System.getProperty("java.io.tmpdir");
        dao = new ProjectDao(BASE_PATH);
    }

    @AfterClass
    public static void clean() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File projectsDir = new File(tmpDir, ((ProjectDao)dao).getSpaceName());
        File projectTypesDir = new File(tmpDir, ((ProjectTypeDao)((ProjectDao)dao).getProjectTypeDao()).getSpaceName());
        FileUtil.removeFile((File)projectsDir, (boolean)true);
        FileUtil.removeFile((File)projectTypesDir, (boolean)true);
    }

    @Test
    public void testSaveProject() {
        ProjectInstance pi = new ProjectInstance(){};
        pi.setId("1");
        User author = new User();
        author.setId("1");
        pi.setAuthor((IUser)author);
        pi.setType((IProjectType)new ProjectType("1", "pt name", "pt description"));
        dao.saveProjectInstance((IProjectInstance)pi);
        Assert.assertEquals((String)"1", (String)dao.getProjectById("1").getId());
    }

    @Test
    public void testGetProjectByAuthorAndType() {
        User author = new User();
        author.setId("1");
        ProjectType projectType = new ProjectType("1", "pt name", "pt description");
        List ps = dao.getUserProjectsByType((IUser)author, (IProjectType)projectType);
        Assert.assertEquals((int)1, (int)ps.size());
        Assert.assertEquals((String)"1", (String)((IProjectInstance)ps.get(0)).getId());
    }
}

