/**
 * webeditor-dao - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.impl.xstream;

import java.io.File;
import java.util.List;

import com.thoughtworks.xstream.persistence.FilePersistenceStrategy;
import com.thoughtworks.xstream.persistence.PersistenceStrategy;
import com.thoughtworks.xstream.persistence.XmlArrayList;

public abstract class AbstractDao<T> {
	
	protected List<T> space;
	
	public AbstractDao(String path) {
		// prepares the file strategy to directory
		File file = new File(path+File.separator+getSpaceName());
		
		// create directory if it doesnt exist
		if (file.exists()==false) file.mkdirs();
		
		PersistenceStrategy strategy = new FilePersistenceStrategy(file);
		// creates the list:
		this.space = new XmlArrayList(strategy);
	}
	
	protected abstract String getSpaceName();
	
	public List<T> getSpace() {
		return space;
	}
	
	protected void save(T object){
		if (getSpace().contains(object)==false){
			//save new project
			this.space.add(object);
		}else{
			//update
			this.update(object);
		}
	}
	
	protected abstract void update(T object);
	
}
