/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.IComponentDispatcherCommand;
import com.ebmwebsourcing.geasytools.webeditor.api.components.IContentPanelComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IComponentAfterDispatchEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IComponentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IComponentLoadedEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IComponentUnloadEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IComponentUpdateEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IComponentDispatcher;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorRegistry;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.ILayout;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.IMultipleComponentPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.IPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events.ComponentAfterDispatchEvent;

public class ComponentDispatcher implements IComponentDispatcher{
	
	private IEditorFrontController controller;
	
	private List<IContentPanelComponent> openContentPanels;
	
	public ComponentDispatcher(IEditorFrontController controller) {
	
		this.controller 					= controller;
		this.openContentPanels				= new ArrayList<IContentPanelComponent>();
	
	}
	
	@Override
	public void dispatch(IComponentDispatcherCommand command) {
		//TODO: consider replaceMode of actual command
		
		IPlaceHolder placeHolder = this.getLayout().getPlaceHolderByPosition(command.getPosition());
		
		if (placeHolder instanceof IMultipleComponentPlaceHolder){
			
			((IMultipleComponentPlaceHolder) placeHolder).addComponent(command.getComponent());
			//set component place holder
			command.getComponent().setPlaceHolder(placeHolder);
		}
		
	
		

	}

	@Override
	public void dispatch(List<IComponentDispatcherCommand> results) {
			
		for(IComponentDispatcherCommand c : results){
			
			dispatch(c);
			
		}
		
		
	}
	
	
	@Override
	public ILayout getLayout() {
		return controller.getView().getLayout();
	}

	@Override
	public IEditorRegistry getRegistry() {
		return controller.getRegistry();
	}

	@Override
	public void dispatch(final IContentPanelComponent component) {

		//register the associated components
		HashSet<IComponent> components = new HashSet<IComponent>();
		
		for(IComponentDispatcherCommand c:component.getAssociatedComponentsDispatcherCommands()){
			
			components.add(c.getComponent());
			
		}
		
		//as adding component may fire panel change event we have to 
		//register all component first then add content component		
		controller.getRegistry().registerComponent(component, components);

		//dispatch components associated to main content panel
		//Note: associated components must be dispatched before the main content panel
		//itself. Otherwise, when adding the main component, the associated components placeholders are not 
		//yet initialized when method displayComponents is called.
		this.dispatch(component.getAssociatedComponentsDispatcherCommands());
		
		//add component to place holder in actual layout
		controller.getView().getLayout().getMainContentPanelPlaceHolder().addComponent(component);
		
		//register actual component content handler
		controller.getEventBus().addUserContentHandler(component.getUserContentHandler());
		

		
		
		//add component to opened component list
		this.openContentPanels.add(component);
		
//		displayComponents(component);
		


		//add handler on component so that when it is closed => remove from openedContentPanels
		component.addHandler(new IComponentHandler() {
			
			@Override
			public void onUnload(IComponentUnloadEvent event) {
				
				openContentPanels.remove(component);
				
			}
			
			@Override
			public void onLoad(IComponentLoadedEvent event) {

				
			}
			
			@Override
			public void onAfterRegistration() {

				
			}

			@Override
			public void onUpdate(IComponentUpdateEvent event) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void onAfterDispatch(IComponentAfterDispatchEvent event) {

				
			}
		});
		
		//component have been dispatched notify it
		component.fireEvent(new ComponentAfterDispatchEvent());
		
	}

	@Override
	public void displayComponents(IContentPanelComponent component) {

		//hide all components
		for(IComponent c:controller.getRegistry().getAllContentPanelsComponents()){
				c.hide();
		}
		
		//display components only if content panel component have
		//already been dispatched			
		HashSet<IComponent> components = controller.getRegistry().getAssociatedComponents(component);
		
		//and display only the components associated to actual content panel component
		if (components!=null){
			for(IComponent c:components){
					c.show();
			}
		}
	}

	@Override
	public List<IContentPanelComponent> getOpenedContentPanelComponent() {
		return openContentPanels;
	}



}
