/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.mainmenu;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMainMenuComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemClickHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.mainmenu.IDefaultPluginHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IMainMenuManager;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IProjectPlugin;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.events.IPluginRegisteredEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.events.IPluginRegistrationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.menu.Menu;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.menu.MenuItem;

public class DefaultPluginHandler implements IDefaultPluginHandler{
	
	private IMainMenuManager mainMenuManager;
	private IMainMenuComponent mainMenu;
	
	public DefaultPluginHandler(IMainMenuManager mainMenuManager) {
		
		this.mainMenuManager 	= mainMenuManager;
		this.mainMenu  			= mainMenuManager.getFrontController().getView().getMainMenuComponent();
	}
	
	@Override
	public IMainMenuManager getMainMenuManager() {
		return mainMenuManager;
	}

	@Override
	public void onPluginRegistrationComplete(
			IPluginRegistrationCompleteEvent event) {

		mainMenu.addFileButton();
		mainMenu.addEditButton();
		mainMenu.addProjectButton();
		mainMenu.addHelpButton();

	}
	
	@Override
	public void onPluginRegistered(IPluginRegisteredEvent event) {

		//check if plugin is a project handler
		//if yes add the handled project to menu
		if (event.getPlugin() instanceof IProjectPlugin){
			
			final IProjectPlugin<?> plugin = (IProjectPlugin<?>) event.getPlugin();
			
			MenuItem newProjectTypeItem = new MenuItem();
			newProjectTypeItem.setText(plugin.getProjectType().getName());

			newProjectTypeItem.setClickHandler(new IMenuItemClickHandler() {
				
				@Override
				public void onClick() {

					//if a configuration view is available show it
					IProjectConfigurationView view = plugin.getConfigurationView();
					
					if (view!=null){
						
						view.open();
						
					}
										
				}
			});
			
			
			if (mainMenu.getNewItem().getSubMenu()==null){
				
				Menu menu = new Menu();
				menu.addMenuItem(newProjectTypeItem);
				mainMenu.getNewItem().setSubMenu(menu);
				
			}else{
				
				
				mainMenu.getNewItem().getSubMenu().addMenuItem(newProjectTypeItem);

			}
			
			
		}
		
	}


}
