/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager;

import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemClickHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.toolbar.IToolbarComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.DefaultErrorLevel;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.toolbar.IDefaultContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.toolbar.IDefaultSystemContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IToolbarManager;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.response.IGetSelectedContentElementsResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.ISaveProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IValidateActualProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.EditorErrorEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.toolbar.DefaultContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.toolbar.DefaultSystemContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.ExportProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.ImportProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.OpenProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.events.DeleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.content.request.GetSelectedContentElementsRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.SaveProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.ValidateActualProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.request.RequestEvent;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceContentElement;
import com.ebmwebsourcing.webeditor.api.domain.project.ProjectValidationException;
import com.google.gwt.user.client.History;

public class ToolbarManager extends AbstractManager implements IToolbarManager{
	
	private IDefaultSystemContentHandler defaultSystemContentHandler;
	private IDefaultContentPanelPlaceHolderHandler defaultContentPanelPlaceHolderHandler;
	
	public ToolbarManager(IEditorFrontController controller) {
		super(controller);

	}

	@Override
	public void initialize() {
		
		IToolbarComponent tbc = getFrontController().getView().getToolbarComponent();

		getFrontController().getView()
		.getLayout()
		.getToolBarPlaceHolder().setComponent(tbc);	
		
		//File
		tbc.getImportMenuItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				String req = ImportProjectPresenter.PLACE.getId();
				
				History.newItem(req);
				
			}
		});
		
		tbc.getExportMenuItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				String req = ExportProjectPresenter.PLACE.getId();
				
				History.newItem(req);
				
			}
		});
		
		
		tbc.getOpenMenuItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				String req = OpenProjectPresenter.PLACE.getId();
				
				History.newItem(req);
				
			}
		});
		
		
		tbc.getSaveMenuItem().setClickHandler(new IMenuItemClickHandler() {
			@Override
			public void onClick() {
				getEventBus().fireEvent(new RequestEvent(new SaveProjectInstanceRequest(getFrontController().getProjectManager().getActualProjectInstance()), new ISaveProjectInstanceResponseHandler() {
					@Override
					public void receiveResponse(Void result) {
						
					}
				}));
			}
		});
		
		//Edit
		tbc.getDeleteBtn().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				
				getEventBus().fireEvent(new RequestEvent(new GetSelectedContentElementsRequest(), new IGetSelectedContentElementsResponseHandler() {
					
					@Override
					public void receiveResponse(List<IProjectInstanceContentElement> result) {
						
						getEventBus().fireEvent(new DeleteEvent(result));
						
					}
				}));
				
			}
		});
		
		//Project
		tbc.getValidateMenuItem().setClickHandler(new IMenuItemClickHandler() {
			
			@Override
			public void onClick() {
				
				getEventBus().fireEvent(new RequestEvent(new ValidateActualProjectInstanceRequest(), new IValidateActualProjectInstanceResponseHandler() {
					
					@Override
					public void receiveResponse(ProjectValidationException result) {
						
						if (result!=null) getEventBus().fireEvent(new EditorErrorEvent("Validation Errors", "Actual project contains following error(s):<br>"+result.getMessage(), DefaultErrorLevel.ERROR));
						
					}
				}));
				
			}
		});
		
		
		//File
		tbc.addMenuButton(tbc.getOpenMenuItem());
		tbc.addMenuButton(tbc.getImportMenuItem());
		tbc.addMenuButton(tbc.getExportMenuItem());
		tbc.addMenuButton(tbc.getSaveMenuItem());
		
		//Edit
		tbc.addMenuButton(tbc.getDeleteBtn());
		tbc.addMenuButton(tbc.getCopyMenuItem());
		tbc.addMenuButton(tbc.getPasteMenuItem());
		tbc.addMenuButton(tbc.getValidateMenuItem());
		
		tbc.getDeleteBtn().setEnabled(false);
		tbc.getExportMenuItem().setEnabled(false);
		tbc.getSaveMenuItem().setEnabled(false);
		tbc.getCopyMenuItem().setEnabled(false);
		tbc.getPasteMenuItem().setEnabled(false);
		tbc.getValidateMenuItem().setEnabled(false);
		
		tbc.addBtns();
		
		

		
	}

	@Override
	public void bindEvents() {
		initialize();
		handleContent();
		handlePanelChange();
	}

	@Override
	public IDefaultSystemContentHandler getDefaultSystemContentHandler() {
		
		if (defaultSystemContentHandler==null){
			this.defaultSystemContentHandler = new DefaultSystemContentHandler(this);
		}
		
		return defaultSystemContentHandler;
	}

	@Override
	public void handleContent() {
		
		getEventBus().addSystemContentHandler(getDefaultSystemContentHandler());
		
	}

	@Override
	public IDefaultContentPanelPlaceHolderHandler getDefaultContentPanelPlaceHolderHandler() {
		
		if (defaultContentPanelPlaceHolderHandler==null){
			this.defaultContentPanelPlaceHolderHandler = new DefaultContentPanelPlaceHolderHandler(this);
		}
		
		return defaultContentPanelPlaceHolderHandler;
	}

	@Override
	public void handlePanelChange() {
			
		getEventBus().addContentPanelPlaceHolderHandler(getDefaultContentPanelPlaceHolderHandler());
		
	}

}
