/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webeditor.server.impl.service.download;

import com.ebmwebsourcing.webeditor.server.impl.service.download.DownloadService;
import com.ebmwebsourcing.webeditor.server.impl.service.download.DownloadServlet;
import java.io.File;
import java.net.URL;
import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.junit.Test;
import org.mortbay.jetty.testing.ServletTester;

public class DonwloadServiceTest {
    private static ServletTester servletTester;
    private static DefaultHttpClient httpclient;
    private static String baseUrl;
    private static String DOWNLOAD_SERVLET_PATH_SPEC;

    @Test
    public void testDownloadServlet() throws Exception {
        servletTester = new ServletTester();
        servletTester.setContextPath("/");
        servletTester.addServlet(DownloadServlet.class, DOWNLOAD_SERVLET_PATH_SPEC);
        baseUrl = servletTester.createSocketConnector(true);
        servletTester.start();
        httpclient = new DefaultHttpClient();
        String fileID = "1";
        File file = new File(this.getActualPath() + "file1.properties");
        DownloadService.getInstance().registerFileToDownload(fileID, file);
        HttpGet httpget = new HttpGet(baseUrl + DOWNLOAD_SERVLET_PATH_SPEC + "?fileID=" + fileID);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        HttpEntity resEntity = response.getEntity();
        Assert.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        Assert.assertEquals((long)file.length(), (long)resEntity.getContentLength());
        String responseContent = EntityUtils.toString((HttpEntity)resEntity);
        Assert.assertEquals((String)"content = file1content", (String)responseContent);
        System.out.println("[Download content]: \n" + responseContent);
        EntityUtils.consume((HttpEntity)resEntity);
        servletTester.stop();
        httpclient.getConnectionManager().shutdown();
    }

    public String getActualPath() {
        String resourceName = this.getClass().getSimpleName() + ".class";
        URL c = this.getClass().getResource(resourceName);
        String actualPath = c.toString().replace("file:", "").replace(resourceName, "");
        return actualPath;
    }

    static {
        DOWNLOAD_SERVLET_PATH_SPEC = "/download";
    }
}

