/**
 * webeditor-ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.project.configuration.view;

import java.util.ArrayList;

import com.ebmwebsourcing.geasytools.gwtextwidgets.file.explorer.FileExplorerPanel;
import com.ebmwebsourcing.geasytools.gwtextwidgets.wizard.Wizard;
import com.ebmwebsourcing.geasytools.gwtextwidgets.wizard.WizardFrame;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.view.AbstractOpenProjectConfigurationView;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.IFileExplorerPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IFrame;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IWizard;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.HTMLPanel;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.WindowListenerAdapter;

public class OpenProjectConfigurationView extends AbstractOpenProjectConfigurationView{
	
	private IFileExplorerPanel fileExplorerPanel;
	private IWizard wizard;
	
	private Window window;
	

	
	public OpenProjectConfigurationView() {
		
		this.window = new Window("Open an existing project");
		ArrayList<IFrame> frames = new ArrayList<IFrame>();
		
		frames.add(getFrame1());
		
		this.getWizard().setFrames(frames);
		Panel headerPanel  = new HTMLPanel("<b>Open Existing Project</b> <br> <span>Select the project type, than choose the project(s) to open</span>");
		headerPanel.setHeight(50);
		headerPanel.setMargins(0, 0, 0, 5);
		this.window.add(headerPanel);
		this.window.add((Widget) this.getWizard());
		this.window.setCloseAction(Window.HIDE);
		this.window.setResizable(false);
		this.window.addListener(new WindowListenerAdapter(){
			
			@Override
			public void onHide(Component component) {
				History.newItem("");
			}
			
		
		});
		

		
	}
	
	
	@Override
	public IFileExplorerPanel getFileExplorerPanel() {
		
		if (fileExplorerPanel==null){
			
			this.fileExplorerPanel = new FileExplorerPanel();
			
		}
		
		return fileExplorerPanel;
	}

	@Override
	public IWizard getWizard() {
		
		if (wizard==null){
			
			this.wizard = new Wizard(650,300);
			((Wizard)this.wizard).setVisible(false);//bug: on instantiation wizard is added to rootpanel
		}
		
		return wizard;
	}


	@Override
	public void close() {
		
		
		window.hide();
		
	}


	@Override
	public void open() {
		
		window.doLayout();
		((Wizard)this.wizard).setVisible(true);
		window.show();

		
	}


	@Override
	public void refresh() {
		// TODO Auto-generated method stub
		
	}
	
	private WizardFrame getFrame1(){
		WizardFrame frame = new WizardFrame((Wizard) getWizard());
		
		frame.add((Widget) getFileExplorerPanel());
		
		return frame;
	}


	@Override
	public Widget asWidget() {
		return this.window;
	}


	@Override
	public void startProcessing() {
		
		
	}


	@Override
	public void stopProcessing() {
		// TODO Auto-generated method stub
		
	}

}
