/**
 * bpmn-deployer - Generic web application for BPMN deployment - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.bpmn.deployer.client.service;

import java.util.List;

import com.ebmwebsourcing.bpmn.deployer.client.to.ProcessExecutorDescription;
import com.ebmwebsourcing.bpmn.deployer.client.to.RunningProcess;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface BPMNDeploymentServiceAsync {

    public void deployBPMNProcessesFromFile(List<String> processIds, String BPMNFileAbsolutePath, ProcessExecutorDescription desc, AsyncCallback<Void> callback);
    
    public void deployBPMNProcesses(List<String> processIds, IDefinitionsBean definitions, ProcessExecutorDescription desc, AsyncCallback<Void> callback);
    
    public void getDeployedProcesses(ProcessExecutorDescription desc, AsyncCallback<List<RunningProcess>> callback);
    
}
