/**
 * bpmn-deployer - Generic web application for BPMN deployment - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.bpmn.deployer.client.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ebmwebsourcing.geasytools.gwtextwidgets.panel.Panel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.google.gwt.core.client.GWT;
import com.gwtext.client.widgets.layout.FitLayout;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.TreePanel;

public class ProcessChoosingPanel extends Panel {

    private static final String POOL_ICON = GWT.getModuleBaseURL()+"images/ico/bpmn/pool.png";
    private TreePanel diagramPanel;
    private Set<ProcessTreeNode> processTreeNodes;

    protected ProcessChoosingPanel(IDefinitionsBean defs) {
        setTitle("Choose the processes that will be deployed");
        setAutoScroll(true);
        setLayout(new FitLayout());
        setBorder(false);

        processTreeNodes = new HashSet<ProcessTreeNode>();

        diagramPanel = new TreePanel("BPMN Diagram");
        diagramPanel.setAutoScroll(true);
        diagramPanel.setBorder(false);
        diagramPanel.setEnableDD(true);
        TreeNode rootNode = new TreeNode(((defs.getName()==null || defs.getName().isEmpty()) ? "Diagram" : defs.getName()));
        rootNode.setExpanded(true);
        rootNode.setAllowDrop(false);
        rootNode.setAllowDrag(false);
        diagramPanel.setRootNode(rootNode);

        for(IParticipantBean participant : defs.getCollaborations().get(0).getParticipants()){
        	//skip empty/collapsed pools
            if(participant.getProcess()==null || participant.getProcess().getFlowNodes().isEmpty()) continue;
            
            TreeNode poolNode = new ProcessTreeNode(participant.getProcess());
            poolNode.setChecked(false);
            poolNode.setAllowDrag(false);

            String text = (participant.getName()==null ? participant.getId() : participant.getName());

            poolNode.setText(text);
            poolNode.setIcon(POOL_ICON);
            rootNode.appendChild(poolNode);
        }

        this.add(diagramPanel);
    }

    public List<String> getSelectedProcessesIds() {
        List<String> result = new ArrayList<String>();

        if(processTreeNodes.size()==1) {
            result.add(processTreeNodes.iterator().next().getProcessId());
        }
        else {
            for(TreeNode node : diagramPanel.getChecked()) {
                for(ProcessTreeNode pnode : processTreeNodes) {
                    if(pnode.getText().equals(node.getText())) {
                        result.add(pnode.getProcessId());
                        break;
                    }
                }
            }
        }

        return result;
    }

    private class ProcessTreeNode extends TreeNode {
        private String processId;

        private ProcessTreeNode(IProcessBean proc) {
            this.processId = proc.getId();
            this.setAllowDrag(false);
            this.setChecked(false);
            this.setId(processId);
            ProcessChoosingPanel.this.processTreeNodes.add(this);
        }

        private String getProcessId() {
            return processId;
        }
    }

}
