/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.di.impl.mock;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.diagramcommon.layout.Point;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.BPELExampleGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.CompleteExampleGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.MockDefinitionsDB;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.PrivateProcessMockDB;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ParallelGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNPlane;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNCollaborationDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNCollaborationPlane;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNEdge;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNShape;


public class BPMNDIMockDB {

	private static DefinitionsBean defsDI1,defsDI2,defsDI3,privateProcessDefsDI1;
	
	public static DefinitionsBean getDefsDI1() { return defsDI1; }
	public static DefinitionsBean getDefsDI2() { return defsDI2; }
	public static DefinitionsBean getDefsDI3() { return defsDI3; }
	public static DefinitionsBean getPrivateProcessDefsDI1() { return privateProcessDefsDI1; }
	
	
	public static IBPMNDiagram getDI1(){
		defsDI1 = MockDefinitionsDB.getSingleExample();

		IBPMNDiagram diagram = new BPMNCollaborationDiagram();
		diagram.setId(defsDI1.getId()+"Diagram");
		diagram.setName("");
		diagram.setResolution(1.0);

		IBPMNPlane plane = new BPMNCollaborationPlane();
		CollaborationBean collab = (CollaborationBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.COLLABORATION_ID); 
		plane.setModelElement(collab);
		diagram.setRootElement(plane);

		///////////////////////UPPER POOL

		//UpperPool
		ParticipantBean upperPool = (ParticipantBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_Participant_ID);
		BPMNShape upperPoolShape = new BPMNShape();
		upperPoolShape.setX(40);
		upperPoolShape.setY(10);
		upperPoolShape.setWidth(1150);
		upperPoolShape.setHeight(200);
		upperPoolShape.setExpanded(true);
		upperPoolShape.setModelElement(upperPool);

		diagram.addDiagramElement(upperPoolShape);

		//UpperLane
		LaneBean upperLane = (LaneBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_ID);
		BPMNShape upperLaneShape = new BPMNShape();
		upperLaneShape.setX(10);	
		upperLaneShape.setY(10);
		upperLaneShape.setWidth(1100);
		upperLaneShape.setHeight(190);		
		upperLaneShape.setModelElement(upperLane);

		diagram.addDiagramElement(upperLaneShape);
		upperPoolShape.addDiagramElement(upperLaneShape);


		//SHAPE1
		StartEventBean startEvent = (StartEventBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_1_ID); 
		BPMNShape upperLaneS1 = new BPMNShape();
		upperLaneS1.setX(10);
		upperLaneS1.setY(60);
		upperLaneS1.setModelElement(startEvent);

		diagram.addDiagramElement(upperLaneS1);
		upperLaneShape.addDiagramElement(upperLaneS1);

		//SHAPE2
		ReceiveTaskBean e2 	= (ReceiveTaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_2_ID);
		BPMNShape upperLaneS2 = new BPMNShape();
		upperLaneS2.setX(70);
		upperLaneS2.setY(50);
		upperLaneS2.setModelElement(e2);		

		diagram.addDiagramElement(upperLaneS2);
		upperLaneShape.addDiagramElement(upperLaneS2);

		//SHAPE3
		TaskBean e3 		= (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_3_ID);
		BPMNShape upperLaneS3 = new BPMNShape();
		upperLaneS3.setX(200);
		upperLaneS3.setY(50);
		upperLaneS3.setModelElement(e3);

		diagram.addDiagramElement(upperLaneS3);
		upperLaneShape.addDiagramElement(upperLaneS3);

		//SHAPE4
		SendTaskBean e4 	= (SendTaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_4_ID);
		BPMNShape upperLaneS4 = new BPMNShape();
		upperLaneS4.setX(330);
		upperLaneS4.setY(50);
		upperLaneS4.setModelElement(e4);

		diagram.addDiagramElement(upperLaneS4);
		upperLaneShape.addDiagramElement(upperLaneS4);

		//SHAPE5
		ReceiveTaskBean e5 	= (ReceiveTaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_5_ID);
		BPMNShape upperLaneS5 = new BPMNShape();
		upperLaneS5.setX(460);
		upperLaneS5.setY(50);
		upperLaneS5.setModelElement(e5);

		diagram.addDiagramElement(upperLaneS5);
		upperLaneShape.addDiagramElement(upperLaneS5);

		//SHAPE6
		SendTaskBean e6 	= (SendTaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_6_ID);
		BPMNShape upperLaneS6 = new BPMNShape();
		upperLaneS6.setX(590);
		upperLaneS6.setY(50);
		upperLaneS6.setModelElement(e6);

		diagram.addDiagramElement(upperLaneS6);
		upperLaneShape.addDiagramElement(upperLaneS6);

		//SHAPE7
		ExclusiveGatewayBean e7 = (ExclusiveGatewayBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_7_ID);
		BPMNShape upperLaneS7 = new BPMNShape();
		upperLaneS7.setX(720);
		upperLaneS7.setY(77);
		upperLaneS7.setModelElement(e7);

		diagram.addDiagramElement(upperLaneS7);
		upperLaneShape.addDiagramElement(upperLaneS7);

		//SHAPE8
		TaskBean e8 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_8_ID);
		BPMNShape upperLaneS8 = new BPMNShape();
		upperLaneS8.setX(780);
		upperLaneS8.setY(10);
		upperLaneS8.setModelElement(e8);

		diagram.addDiagramElement(upperLaneS8);
		upperLaneShape.addDiagramElement(upperLaneS8);

		//SHAPE9
		TaskBean e9 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_9_ID);
		BPMNShape upperLaneS9 = new BPMNShape();
		upperLaneS9.setX(780);
		upperLaneS9.setY(130);
		upperLaneS9.setModelElement(e9);

		diagram.addDiagramElement(upperLaneS9);
		upperLaneShape.addDiagramElement(upperLaneS9);

		//SHAPE10
		TaskBean e10 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_10_ID);
		BPMNShape upperLaneS10 = new BPMNShape();
		upperLaneS10.setX(910);
		upperLaneS10.setY(130);
		upperLaneS10.setModelElement(e10);

		diagram.addDiagramElement(upperLaneS10);
		upperLaneShape.addDiagramElement(upperLaneS10);

		//SHAPE11
		EndEventBean e11 = (EndEventBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_11_ID);
		BPMNShape upperLaneS11 = new BPMNShape();
		upperLaneS11.setX(1080);
		upperLaneS11.setY(80);
		upperLaneS11.setModelElement(e11);

		diagram.addDiagramElement(upperLaneS11);
		upperLaneShape.addDiagramElement(upperLaneS11);

		//SHAPE12
		SequenceFlowBean e12 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_12_ID);
		BPMNEdge upperLaneS12 = new BPMNEdge();
		upperLaneS12.setSource(upperLaneS1);
		upperLaneS12.setTarget(upperLaneS2);
		upperLaneS12.setModelElement(e12);
		upperLaneS12.addWayPoint(new Point(upperLaneS1.getX(), upperLaneS1.getY()));
		upperLaneS12.addWayPoint(new Point(upperLaneS2.getX(), upperLaneS2.getY()));

		diagram.addDiagramElement(upperLaneS12);

		//SHAPE13
		SequenceFlowBean e13 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_13_ID);
		BPMNEdge upperLaneS13 = new BPMNEdge();
		upperLaneS13.setSource(upperLaneS2);
		upperLaneS13.setTarget(upperLaneS3);
		upperLaneS13.setModelElement(e13);
		upperLaneS13.addWayPoint(new Point(upperLaneS2.getX(), upperLaneS2.getY()));
		upperLaneS13.addWayPoint(new Point(upperLaneS3.getX(), upperLaneS3.getY()));

		diagram.addDiagramElement(upperLaneS13);

		//SHAPE14
		SequenceFlowBean e14 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_14_ID);
		BPMNEdge upperLaneS14 = new BPMNEdge();
		upperLaneS14.setSource(upperLaneS3);
		upperLaneS14.setTarget(upperLaneS4);
		upperLaneS14.setModelElement(e14);
		upperLaneS14.addWayPoint(new Point(upperLaneS3.getX(), upperLaneS3.getY()));
		upperLaneS14.addWayPoint(new Point(upperLaneS4.getX(), upperLaneS4.getY()));

		diagram.addDiagramElement(upperLaneS14);

		//SHAPE15
		SequenceFlowBean e15 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_15_ID);
		BPMNEdge upperLaneS15 = new BPMNEdge();
		upperLaneS15.setSource(upperLaneS4);
		upperLaneS15.setTarget(upperLaneS5);
		upperLaneS15.setModelElement(e15);
		upperLaneS15.addWayPoint(new Point(upperLaneS4.getX(), upperLaneS4.getY()));
		upperLaneS15.addWayPoint(new Point(upperLaneS5.getX(), upperLaneS5.getY()));

		diagram.addDiagramElement(upperLaneS15);

		//SHAPE16
		SequenceFlowBean e16 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_16_ID);
		BPMNEdge upperLaneS16 = new BPMNEdge();
		upperLaneS16.setSource(upperLaneS5);
		upperLaneS16.setTarget(upperLaneS6);
		upperLaneS16.setModelElement(e16);
		upperLaneS16.addWayPoint(new Point(upperLaneS5.getX(), upperLaneS5.getY()));
		upperLaneS16.addWayPoint(new Point(upperLaneS6.getX(), upperLaneS6.getY()));

		diagram.addDiagramElement(upperLaneS16);

		//SHAPE17
		SequenceFlowBean e17 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_17_ID);
		BPMNEdge upperLaneS17 = new BPMNEdge();
		upperLaneS17.setSource(upperLaneS6);
		upperLaneS17.setTarget(upperLaneS7);
		upperLaneS17.setModelElement(e17);
		upperLaneS17.addWayPoint(new Point(upperLaneS6.getX(), upperLaneS6.getY()));
		upperLaneS17.addWayPoint(new Point(upperLaneS7.getX(), upperLaneS7.getY()));

		diagram.addDiagramElement(upperLaneS17);

		//SHAPE18
		SequenceFlowBean e18 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_18_ID);
		BPMNEdge upperLaneS18 = new BPMNEdge();
		upperLaneS18.setSource(upperLaneS7);
		upperLaneS18.setTarget(upperLaneS8);
		upperLaneS18.setModelElement(e18);
		upperLaneS18.addWayPoint(new Point(upperLaneS7.getX(), upperLaneS7.getY()));
		upperLaneS18.addWayPoint(new Point(upperLaneS8.getX(), upperLaneS8.getY()));

		diagram.addDiagramElement(upperLaneS18);

		//SHAPE19
		SequenceFlowBean e19 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_19_ID);
		BPMNEdge upperLaneS19 = new BPMNEdge();
		upperLaneS19.setSource(upperLaneS7);
		upperLaneS19.setTarget(upperLaneS9);
		upperLaneS19.setModelElement(e19);
		upperLaneS19.addWayPoint(new Point(upperLaneS7.getX(), upperLaneS7.getY()));
		upperLaneS19.addWayPoint(new Point(upperLaneS9.getX(), upperLaneS9.getY()));

		diagram.addDiagramElement(upperLaneS19);

		//SHAPE20
		SequenceFlowBean e20 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_20_ID);
		BPMNEdge upperLaneS20 = new BPMNEdge();
		upperLaneS20.setSource(upperLaneS8);
		upperLaneS20.setTarget(upperLaneS11);
		upperLaneS20.setModelElement(e20);
		upperLaneS20.addWayPoint(new Point(upperLaneS8.getX(), upperLaneS8.getY()));
		upperLaneS20.addWayPoint(new Point(upperLaneS11.getX(), upperLaneS11.getY()));

		diagram.addDiagramElement(upperLaneS20);

		//SHAPE21
		SequenceFlowBean e21 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_21_ID);
		BPMNEdge upperLaneS21 = new BPMNEdge();
		upperLaneS21.setSource(upperLaneS9);
		upperLaneS21.setTarget(upperLaneS10);
		upperLaneS21.setModelElement(e21);
		upperLaneS21.addWayPoint(new Point(upperLaneS9.getX(), upperLaneS9.getY()));
		upperLaneS21.addWayPoint(new Point(upperLaneS10.getX(), upperLaneS10.getY()));

		diagram.addDiagramElement(upperLaneS21);

		//SHAPE22
		SequenceFlowBean e22 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.UPPER_LANE_EL_22_ID);
		BPMNEdge upperLaneS22 = new BPMNEdge();
		upperLaneS22.setSource(upperLaneS10);
		upperLaneS22.setTarget(upperLaneS11);
		upperLaneS22.setModelElement(e22);
		upperLaneS22.addWayPoint(new Point(upperLaneS10.getX(), upperLaneS10.getY()));
		upperLaneS22.addWayPoint(new Point(upperLaneS11.getX(), upperLaneS11.getY()));

		diagram.addDiagramElement(upperLaneS22);


		//////////////////////LOWER POOL

		//LowerPool
		ParticipantBean lowerPool = (ParticipantBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_Participant_ID);
		BPMNShape lowerPoolShape = new BPMNShape();
		lowerPoolShape.setX(40);
		lowerPoolShape.setY(300);
		lowerPoolShape.setWidth(1150);
		lowerPoolShape.setHeight(200);
		lowerPoolShape.setExpanded(true);
		lowerPoolShape.setModelElement(lowerPool);

		diagram.addDiagramElement(lowerPoolShape);

		//LowerLane
		LaneBean lowerLane = (LaneBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_ID);
		BPMNShape lowerLaneShape = new BPMNShape();
		lowerLaneShape.setX(10);	
		lowerLaneShape.setY(10);
		lowerLaneShape.setWidth(1100);
		lowerLaneShape.setHeight(190);
		lowerLaneShape.setModelElement(lowerLane);

		diagram.addDiagramElement(lowerLaneShape);
		lowerPoolShape.addDiagramElement(lowerLaneShape);


		//SHAPE1
		StartEventBean le1 = (StartEventBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_1_ID); 
		BPMNShape lowerLaneS1 = new BPMNShape();
		lowerLaneS1.setX(70);
		lowerLaneS1.setY(50);
		lowerLaneS1.setModelElement(le1);

		diagram.addDiagramElement(lowerLaneS1);
		lowerLaneShape.addDiagramElement(lowerLaneS1);

		//SHAPE2
		ReceiveTaskBean le2 	= (ReceiveTaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_2_ID);
		BPMNShape lowerLaneS2 = new BPMNShape();
		lowerLaneS2.setX(140);
		lowerLaneS2.setY(50);
		lowerLaneS2.setModelElement(le2);		

		diagram.addDiagramElement(lowerLaneS2);
		lowerLaneShape.addDiagramElement(lowerLaneS2);

		//SHAPE3
		TaskBean le3 		= (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_3_ID);
		BPMNShape lowerLaneS3 = new BPMNShape();
		lowerLaneS3.setX(270);
		lowerLaneS3.setY(50);
		lowerLaneS3.setModelElement(le3);

		diagram.addDiagramElement(lowerLaneS3);
		lowerLaneShape.addDiagramElement(lowerLaneS3);

		//SHAPE4
		ReceiveTaskBean le4 	= (ReceiveTaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_4_ID);
		BPMNShape lowerLaneS4 = new BPMNShape();
		lowerLaneS4.setX(400);
		lowerLaneS4.setY(50);
		lowerLaneS4.setModelElement(le4);

		diagram.addDiagramElement(lowerLaneS4);
		lowerLaneShape.addDiagramElement(lowerLaneS4);

		//SHAPE5
		ExclusiveGatewayBean le5 	= (ExclusiveGatewayBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_5_ID);
		BPMNShape lowerLaneS5 = new BPMNShape();
		lowerLaneS5.setX(530);
		lowerLaneS5.setY(77);
		lowerLaneS5.setModelElement(le5);

		diagram.addDiagramElement(lowerLaneS5);
		lowerLaneShape.addDiagramElement(lowerLaneS5);

		//SHAPE6
		TaskBean le6 	= (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_6_ID);
		BPMNShape lowerLaneS6 = new BPMNShape();
		lowerLaneS6.setX(590);
		lowerLaneS6.setY(10);
		lowerLaneS6.setModelElement(le6);

		diagram.addDiagramElement(lowerLaneS6);
		lowerLaneShape.addDiagramElement(lowerLaneS6);

		//SHAPE7
		TaskBean le7 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_7_ID);
		BPMNShape lowerLaneS7 = new BPMNShape();
		lowerLaneS7.setX(590);
		lowerLaneS7.setY(130);
		lowerLaneS7.setModelElement(le7);

		diagram.addDiagramElement(lowerLaneS7);
		lowerLaneShape.addDiagramElement(lowerLaneS7);

		//SHAPE8
		TaskBean le8 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_8_ID);
		BPMNShape lowerLaneS8 = new BPMNShape();
		lowerLaneS8.setX(720);
		lowerLaneS8.setY(10);
		lowerLaneS8.setModelElement(le8);

		diagram.addDiagramElement(lowerLaneS8);
		lowerLaneShape.addDiagramElement(lowerLaneS8);

		//SHAPE9
		EndEventBean le9 = (EndEventBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_9_ID);
		BPMNShape lowerLaneS9 = new BPMNShape();
		lowerLaneS9.setX(850);
		lowerLaneS9.setY(80);
		lowerLaneS9.setModelElement(le9);

		diagram.addDiagramElement(lowerLaneS9);
		lowerLaneShape.addDiagramElement(lowerLaneS9);

		//SHAPE10
		SequenceFlowBean le10 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_10_ID);
		BPMNEdge lowerLaneS10 = new BPMNEdge();
		lowerLaneS10.setSource(lowerLaneS1);
		lowerLaneS10.setTarget(lowerLaneS2);
		lowerLaneS10.setModelElement(le10);
		lowerLaneS10.addWayPoint(new Point(lowerLaneS1.getX(), lowerLaneS1.getY()));
		lowerLaneS10.addWayPoint(new Point(lowerLaneS2.getX(), lowerLaneS2.getY()));

		diagram.addDiagramElement(lowerLaneS10);
		lowerLaneShape.addDiagramElement(lowerLaneS10);

		//SHAPE11
		SequenceFlowBean le11 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_11_ID);
		BPMNEdge lowerLaneS11 = new BPMNEdge();
		lowerLaneS11.setSource(lowerLaneS2);
		lowerLaneS11.setTarget(lowerLaneS3);
		lowerLaneS11.setModelElement(le11);
		lowerLaneS11.addWayPoint(new Point(lowerLaneS2.getX(), lowerLaneS2.getY()));
		lowerLaneS11.addWayPoint(new Point(lowerLaneS3.getX(), lowerLaneS3.getY()));

		diagram.addDiagramElement(lowerLaneS11);
		lowerLaneShape.addDiagramElement(lowerLaneS11);

		///SEquence FLows

		//SHAPE12
		SequenceFlowBean le12 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_12_ID);
		BPMNEdge lowerLaneS12 = new BPMNEdge();
		lowerLaneS12.setSource(lowerLaneS3);
		lowerLaneS12.setTarget(lowerLaneS4);
		lowerLaneS12.setModelElement(le12);
		lowerLaneS12.addWayPoint(new Point(lowerLaneS3.getX(), lowerLaneS3.getY()));
		lowerLaneS12.addWayPoint(new Point(lowerLaneS4.getX(), lowerLaneS4.getY()));

		diagram.addDiagramElement(lowerLaneS12);

		//SHAPE13
		SequenceFlowBean le13 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_13_ID);
		BPMNEdge lowerLaneS13 = new BPMNEdge();
		lowerLaneS13.setSource(lowerLaneS4);
		lowerLaneS13.setTarget(lowerLaneS5);
		lowerLaneS13.setModelElement(le13);
		lowerLaneS13.addWayPoint(new Point(lowerLaneS4.getX(), lowerLaneS4.getY()));
		lowerLaneS13.addWayPoint(new Point(lowerLaneS5.getX(), lowerLaneS5.getY()));

		diagram.addDiagramElement(lowerLaneS13);

		//SHAPE14
		SequenceFlowBean le14 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_14_ID);
		BPMNEdge lowerLaneS14 = new BPMNEdge();
		lowerLaneS14.setSource(lowerLaneS5);
		lowerLaneS14.setTarget(lowerLaneS6);
		lowerLaneS14.setModelElement(le14);
		lowerLaneS14.addWayPoint(new Point(lowerLaneS5.getX(), lowerLaneS5.getY()));
		lowerLaneS14.addWayPoint(new Point(lowerLaneS6.getX(), lowerLaneS6.getY()));

		diagram.addDiagramElement(lowerLaneS14);

		//SHAPE15
		SequenceFlowBean le15 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_15_ID);
		BPMNEdge lowerLaneS15 = new BPMNEdge();
		lowerLaneS15.setSource(lowerLaneS5);
		lowerLaneS15.setTarget(lowerLaneS7);
		lowerLaneS15.setModelElement(le15);
		lowerLaneS15.addWayPoint(new Point(lowerLaneS5.getX(), lowerLaneS5.getY()));
		lowerLaneS15.addWayPoint(new Point(lowerLaneS7.getX(), lowerLaneS7.getY()));

		diagram.addDiagramElement(lowerLaneS15);

		//SHAPE16
		SequenceFlowBean le16 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_16_ID);
		BPMNEdge lowerLaneS16 = new BPMNEdge();
		lowerLaneS16.setSource(lowerLaneS6);
		lowerLaneS16.setTarget(lowerLaneS8);
		lowerLaneS16.setModelElement(le16);
		lowerLaneS16.addWayPoint(new Point(lowerLaneS6.getX(), lowerLaneS6.getY()));
		lowerLaneS16.addWayPoint(new Point(lowerLaneS8.getX(), lowerLaneS8.getY()));

		diagram.addDiagramElement(lowerLaneS16);

		//SHAPE17
		SequenceFlowBean le17 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_17_ID);
		BPMNEdge lowerLaneS17 = new BPMNEdge();
		lowerLaneS17.setSource(lowerLaneS7);
		lowerLaneS17.setTarget(lowerLaneS9);
		lowerLaneS17.setModelElement(le17);
		lowerLaneS17.addWayPoint(new Point(lowerLaneS7.getX(), lowerLaneS7.getY()));
		lowerLaneS17.addWayPoint(new Point(lowerLaneS9.getX(), lowerLaneS9.getY()));

		diagram.addDiagramElement(lowerLaneS17);

		//SHAPE18
		SequenceFlowBean le18 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.LOWER_LANE_EL_18_ID);
		BPMNEdge lowerLaneS18 = new BPMNEdge();
		lowerLaneS18.setSource(lowerLaneS8);
		lowerLaneS18.setTarget(lowerLaneS9);
		lowerLaneS18.setModelElement(le18);
		lowerLaneS18.addWayPoint(new Point(lowerLaneS8.getX(), lowerLaneS8.getY()));
		lowerLaneS18.addWayPoint(new Point(lowerLaneS9.getX(), lowerLaneS9.getY()));

		diagram.addDiagramElement(lowerLaneS18);


		//Message Flows

		MessageFlowBean mf1 = (MessageFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.MF_1_ID);
		BPMNEdge edgeMF1 = new BPMNEdge();
		edgeMF1.setSource(upperLaneS4);
		edgeMF1.setTarget(lowerLaneS1);
		edgeMF1.setModelElement(mf1);
		edgeMF1.addWayPoint(new Point(upperLaneS4.getX(),upperLaneS4.getY()));
		edgeMF1.addWayPoint(new Point(lowerLaneS1.getX(),lowerLaneS1.getY()));
		diagram.addDiagramElement(edgeMF1);

		MessageFlowBean mf2 = (MessageFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.MF_2_ID);
		BPMNEdge edgeMF2 = new BPMNEdge();
		edgeMF2.setSource(lowerLaneS3);
		edgeMF2.setTarget(upperLaneS5);
		edgeMF2.setModelElement(mf2);
		edgeMF2.addWayPoint(new Point(lowerLaneS3.getX(),lowerLaneS3.getY()));
		edgeMF2.addWayPoint(new Point(upperLaneS5.getX(),upperLaneS5.getY()));
		diagram.addDiagramElement(edgeMF2);

		MessageFlowBean mf3 = (MessageFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI1, MockDefinitionsDB.MF_3_ID);
		BPMNEdge edgeMF3 = new BPMNEdge();
		edgeMF3.setSource(upperLaneS6);
		edgeMF3.setTarget(lowerLaneS4);
		edgeMF3.setModelElement(mf3);
		edgeMF3.addWayPoint(new Point(upperLaneS6.getX(),upperLaneS6.getY()));
		edgeMF3.addWayPoint(new Point(lowerLaneS4.getX(),lowerLaneS4.getY()));
		diagram.addDiagramElement(edgeMF3);


		return diagram;
	}



	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////



	public static IBPMNDiagram getDI2(){

		defsDI2 = CompleteExampleGenerator.getExample();


		IBPMNDiagram diagram = new BPMNCollaborationDiagram();
		diagram.setId(defsDI2.getId());
		diagram.setName("");
		diagram.setResolution(1.0);

		IBPMNPlane plane = new BPMNCollaborationPlane();
		CollaborationBean collab = (CollaborationBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.COLLABORATION_ID); 
		plane.setModelElement(collab);
		diagram.setRootElement(plane);

		BPMNShape mfSource = null;
		BPMNShape mfTarget = null;

		{
			//UpperPool
		    ParticipantBean upperPool = (ParticipantBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_Participant_ID);
			BPMNShape upperPoolShape = new BPMNShape();
			upperPoolShape.setX(40);
			upperPoolShape.setY(10);
			upperPoolShape.setWidth(1200);
			upperPoolShape.setHeight(200);
			upperPoolShape.setExpanded(true);
			upperPoolShape.setModelElement(upperPool);

			diagram.addDiagramElement(upperPoolShape);

			//UpperLane
			LaneBean upperLane = (LaneBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_ID);
			BPMNShape upperLaneShape = new BPMNShape();
			upperLaneShape.setX(10);	
			upperLaneShape.setY(10);
			upperLaneShape.setWidth(1190);
			upperLaneShape.setHeight(190);		
			upperLaneShape.setModelElement(upperLane);

			diagram.addDiagramElement(upperLaneShape);
			upperPoolShape.addDiagramElement(upperLaneShape);


			//Start event
			StartEventBean startEvent = (StartEventBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_EL_1_ID); 
			BPMNShape upperLaneS1 = new BPMNShape();
			upperLaneS1.setX(40);
			upperLaneS1.setY(60);
			upperLaneS1.setModelElement(startEvent);
			diagram.addDiagramElement(upperLaneS1);
			upperLaneShape.addDiagramElement(upperLaneS1);

			//task
			TaskBean e2 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_EL_2_ID);
			BPMNShape upperLaneS2 = new BPMNShape();
			upperLaneS2.setX(200);
			upperLaneS2.setY(50);
			upperLaneS2.setModelElement(e2);
			diagram.addDiagramElement(upperLaneS2);
			upperLaneShape.addDiagramElement(upperLaneS2);

			//parallel Gateway
			ParallelGatewayBean e3 = (ParallelGatewayBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_EL_3_ID);
			BPMNShape upperLaneS3 = new BPMNShape();
			upperLaneS3.setX(240);
			upperLaneS3.setY(77);
			upperLaneS3.setModelElement(e3);
			diagram.addDiagramElement(upperLaneS3);
			upperLaneShape.addDiagramElement(upperLaneS3);

			TaskBean e4 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_EL_4_ID);
			BPMNShape upperLaneS4 = new BPMNShape();
			upperLaneS4.setX(300);
			upperLaneS4.setY(10);
			upperLaneS4.setModelElement(e4);
			diagram.addDiagramElement(upperLaneS4);
			upperLaneShape.addDiagramElement(upperLaneS4);

			TaskBean e5 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_EL_5_ID);
			BPMNShape upperLaneS5 = new BPMNShape();
			upperLaneS5.setX(300);
			upperLaneS5.setY(130);
			upperLaneS5.setModelElement(e5);
			diagram.addDiagramElement(upperLaneS5);
			upperLaneShape.addDiagramElement(upperLaneS5);

			ParallelGatewayBean e6 = (ParallelGatewayBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_EL_6_ID);
			BPMNShape upperLaneS6 = new BPMNShape();
			upperLaneS6.setX(430);
			upperLaneS6.setY(77);
			upperLaneS6.setModelElement(e6);
			diagram.addDiagramElement(upperLaneS6);
			upperLaneShape.addDiagramElement(upperLaneS6);

			TaskBean e7 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_EL_7_ID);
			BPMNShape upperLaneS7 = new BPMNShape();
			upperLaneS7.setX(490);
			upperLaneS7.setY(77);
			upperLaneS7.setModelElement(e7);
			diagram.addDiagramElement(upperLaneS7);
			upperLaneShape.addDiagramElement(upperLaneS7);

			//end event
			EndEventBean e8 = (EndEventBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_EL_8_ID);
			BPMNShape upperLaneS8 = new BPMNShape();
			upperLaneS8.setX(1080);
			upperLaneS8.setY(80);
			upperLaneS8.setModelElement(e8);
			diagram.addDiagramElement(upperLaneS8);
			upperLaneShape.addDiagramElement(upperLaneS8);
			mfSource = upperLaneS8;

			//sequence flow
			SequenceFlowBean sf1 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_SF_1_ID);
			BPMNEdge upperLaneSF1 = new BPMNEdge();
			upperLaneSF1.setSource(upperLaneS1);
			upperLaneSF1.setTarget(upperLaneS2);
			upperLaneSF1.setModelElement(sf1);
			upperLaneSF1.addWayPoint(new Point(upperLaneS1.getX(), upperLaneS1.getY()));
			upperLaneSF1.addWayPoint(new Point(upperLaneS2.getX(), upperLaneS2.getY()));
			diagram.addDiagramElement(upperLaneSF1);

			SequenceFlowBean sf2 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_SF_2_ID);
			BPMNEdge upperLaneSF2 = new BPMNEdge();
			upperLaneSF2.setSource(upperLaneS2);
			upperLaneSF2.setTarget(upperLaneS3);
			upperLaneSF2.setModelElement(sf2);
			upperLaneSF2.addWayPoint(new Point(upperLaneS2.getX(), upperLaneS2.getY()));
			upperLaneSF2.addWayPoint(new Point(upperLaneS3.getX(), upperLaneS3.getY()));
			diagram.addDiagramElement(upperLaneSF2);

			SequenceFlowBean sf3 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_SF_3_ID);
			BPMNEdge upperLaneSF3 = new BPMNEdge();
			upperLaneSF3.setSource(upperLaneS3);
			upperLaneSF3.setTarget(upperLaneS4);
			upperLaneSF3.setModelElement(sf3);
			upperLaneSF3.addWayPoint(new Point(upperLaneS3.getX(), upperLaneS3.getY()));
			upperLaneSF3.addWayPoint(new Point(upperLaneS4.getX(), upperLaneS4.getY()));
			diagram.addDiagramElement(upperLaneSF3);

			SequenceFlowBean sf4 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_SF_4_ID);
			BPMNEdge upperLaneSF4 = new BPMNEdge();
			upperLaneSF4.setSource(upperLaneS3);
			upperLaneSF4.setTarget(upperLaneS5);
			upperLaneSF4.setModelElement(sf4);
			upperLaneSF4.addWayPoint(new Point(upperLaneS3.getX(), upperLaneS3.getY()));
			upperLaneSF4.addWayPoint(new Point(upperLaneS5.getX(), upperLaneS5.getY()));
			diagram.addDiagramElement(upperLaneSF4);

			SequenceFlowBean sf5 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_SF_5_ID);
			BPMNEdge upperLaneSF5 = new BPMNEdge();
			upperLaneSF5.setSource(upperLaneS4);
			upperLaneSF5.setTarget(upperLaneS6);
			upperLaneSF5.setModelElement(sf5);
			upperLaneSF5.addWayPoint(new Point(upperLaneS4.getX(), upperLaneS4.getY()));
			upperLaneSF5.addWayPoint(new Point(upperLaneS6.getX(), upperLaneS6.getY()));
			diagram.addDiagramElement(upperLaneSF5);

			SequenceFlowBean sf6 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_SF_6_ID);
			BPMNEdge upperLaneSF6 = new BPMNEdge();
			upperLaneSF6.setSource(upperLaneS5);
			upperLaneSF6.setTarget(upperLaneS6);
			upperLaneSF6.setModelElement(sf6);
			upperLaneSF6.addWayPoint(new Point(upperLaneS5.getX(), upperLaneS5.getY()));
			upperLaneSF6.addWayPoint(new Point(upperLaneS6.getX(), upperLaneS6.getY()));
			diagram.addDiagramElement(upperLaneSF6);

			SequenceFlowBean sf7 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_SF_7_ID);
			BPMNEdge upperLaneSF7 = new BPMNEdge();
			upperLaneSF7.setSource(upperLaneS6);
			upperLaneSF7.setTarget(upperLaneS7);
			upperLaneSF7.setModelElement(sf7);
			upperLaneSF7.addWayPoint(new Point(upperLaneS6.getX(), upperLaneS6.getY()));
			upperLaneSF7.addWayPoint(new Point(upperLaneS7.getX(), upperLaneS7.getY()));
			diagram.addDiagramElement(upperLaneSF7);

			SequenceFlowBean sf8 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.UPPER_LANE_SF_8_ID);
			BPMNEdge upperLaneSF8 = new BPMNEdge();
			upperLaneSF8.setSource(upperLaneS7);
			upperLaneSF8.setTarget(upperLaneS8);
			upperLaneSF8.setModelElement(sf8);
			upperLaneSF8.addWayPoint(new Point(upperLaneS7.getX(), upperLaneS7.getY()));
			upperLaneSF8.addWayPoint(new Point(upperLaneS8.getX(), upperLaneS8.getY()));
			diagram.addDiagramElement(upperLaneSF8);
		}



		{
		    ParticipantBean lowerPool = (ParticipantBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_Participant_ID);
			BPMNShape lowerPoolShape = new BPMNShape();
			lowerPoolShape.setX(10);
			lowerPoolShape.setY(250);
			lowerPoolShape.setWidth(750);
			lowerPoolShape.setHeight(300);
			lowerPoolShape.setExpanded(true);
			lowerPoolShape.setModelElement(lowerPool);
			diagram.addDiagramElement(lowerPoolShape);

			//lowerLane
			LaneBean lowerLane = (LaneBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_1_ID);
			BPMNShape lowerLaneShape = new BPMNShape();
			lowerLaneShape.setX(10);	
			lowerLaneShape.setY(10);
			lowerLaneShape.setWidth(740);
			lowerLaneShape.setHeight(140);		
			lowerLaneShape.setModelElement(lowerLane);
			diagram.addDiagramElement(lowerLaneShape);
			lowerPoolShape.addDiagramElement(lowerLaneShape);

			StartEventBean startEvent = (StartEventBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_EL_1_ID); 
			BPMNShape lowerLaneS1 = new BPMNShape();
			lowerLaneS1.setX(70);
			lowerLaneS1.setY(50);
			lowerLaneS1.setModelElement(startEvent);
			diagram.addDiagramElement(lowerLaneS1);
			lowerLaneShape.addDiagramElement(lowerLaneS1);
			mfTarget = lowerLaneS1;

			TaskBean t1 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_EL_2_ID);
			BPMNShape lowerLaneS2 = new BPMNShape();
			lowerLaneS2.setX(140);
			lowerLaneS2.setY(50);
			lowerLaneS2.setModelElement(t1);
			diagram.addDiagramElement(lowerLaneS2);
			lowerLaneShape.addDiagramElement(lowerLaneS2);

			TaskBean t2 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_EL_3_ID);
			BPMNShape lowerLaneS3 = new BPMNShape();
			lowerLaneS3.setX(270);
			lowerLaneS3.setY(50);
			lowerLaneS3.setModelElement(t2);
			diagram.addDiagramElement(lowerLaneS3);
			lowerLaneShape.addDiagramElement(lowerLaneS3);

			ExclusiveGatewayBean eg = (ExclusiveGatewayBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_EL_4_ID);
			BPMNShape lowerLaneS4 = new BPMNShape();
			lowerLaneS4.setX(400);
			lowerLaneS4.setY(77);
			lowerLaneS4.setModelElement(eg);
			diagram.addDiagramElement(lowerLaneS4);
			lowerLaneShape.addDiagramElement(lowerLaneS4);

			TaskBean t4 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_EL_5_ID);
			BPMNShape lowerLaneS5 = new BPMNShape();
			lowerLaneS5.setX(480);
			lowerLaneS5.setY(50);
			lowerLaneS5.setModelElement(t4);
			diagram.addDiagramElement(lowerLaneS5);
			lowerLaneShape.addDiagramElement(lowerLaneS5);

			EndEventBean endEvent = (EndEventBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_EL_6_ID);
			BPMNShape lowerLaneS6 = new BPMNShape();
			lowerLaneS6.setX(610);
			lowerLaneS6.setY(77);
			lowerLaneS6.setModelElement(endEvent);
			diagram.addDiagramElement(lowerLaneS6);
			lowerLaneShape.addDiagramElement(lowerLaneS6);

			LaneBean lowerLane2 = (LaneBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_2_ID);
			BPMNShape lowerLaneShape2 = new BPMNShape();
			lowerLaneShape2.setX(10);	
			lowerLaneShape2.setY(140);
			lowerLaneShape2.setWidth(740);
			lowerLaneShape2.setHeight(110);		
			lowerLaneShape2.setModelElement(lowerLane2);
			diagram.addDiagramElement(lowerLaneShape2);
			lowerPoolShape.addDiagramElement(lowerLaneShape2);

			TaskBean t = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_2_EL_ID);
			BPMNShape lowerLaneS = new BPMNShape();
			lowerLaneS.setX(480);
			lowerLaneS.setY(20);
			lowerLaneS.setModelElement(t);
			diagram.addDiagramElement(lowerLaneS);
			lowerLaneShape.addDiagramElement(lowerLaneS);

			SequenceFlowBean sf0 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_SF_0_ID);
			BPMNEdge lowerLaneSF0 = new BPMNEdge();
			lowerLaneSF0.setSource(lowerLaneS1);
			lowerLaneSF0.setTarget(lowerLaneS2);
			lowerLaneSF0.setModelElement(sf0);
			lowerLaneSF0.addWayPoint(new Point(lowerLaneS1.getX(), lowerLaneS1.getY()));
			lowerLaneSF0.addWayPoint(new Point(lowerLaneS2.getX(), lowerLaneS2.getY()));
			diagram.addDiagramElement(lowerLaneSF0);

			SequenceFlowBean sf1 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_SF_1_ID);
			BPMNEdge lowerLaneSF1 = new BPMNEdge();
			lowerLaneSF1.setSource(lowerLaneS2);
			lowerLaneSF1.setTarget(lowerLaneS3);
			lowerLaneSF1.setModelElement(sf1);
			lowerLaneSF1.addWayPoint(new Point(lowerLaneS2.getX(), lowerLaneS2.getY()));
			lowerLaneSF1.addWayPoint(new Point(lowerLaneS3.getX(), lowerLaneS3.getY()));
			diagram.addDiagramElement(lowerLaneSF1);

			SequenceFlowBean sf2 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_SF_2_ID);
			BPMNEdge lowerLaneSF2 = new BPMNEdge();
			lowerLaneSF2.setSource(lowerLaneS3);
			lowerLaneSF2.setTarget(lowerLaneS4);
			lowerLaneSF2.setModelElement(sf2);
			lowerLaneSF2.addWayPoint(new Point(lowerLaneS3.getX(), lowerLaneS3.getY()));
			lowerLaneSF2.addWayPoint(new Point(lowerLaneS4.getX(), lowerLaneS4.getY()));
			diagram.addDiagramElement(lowerLaneSF2);

			SequenceFlowBean sf3 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_SF_3_ID);
			BPMNEdge lowerLaneSF3 = new BPMNEdge();
			lowerLaneSF3.setSource(lowerLaneS4);
			lowerLaneSF3.setTarget(lowerLaneS);
			lowerLaneSF3.setModelElement(sf3);
			lowerLaneSF3.addWayPoint(new Point(lowerLaneS4.getX(), lowerLaneS4.getY()));
			lowerLaneSF3.addWayPoint(new Point(lowerLaneS.getX(), lowerLaneS.getY()));
			diagram.addDiagramElement(lowerLaneSF3);

			SequenceFlowBean sf4 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_SF_4_ID);
			BPMNEdge lowerLaneSF4 = new BPMNEdge();
			lowerLaneSF4.setSource(lowerLaneS4);
			lowerLaneSF4.setTarget(lowerLaneS5);
			lowerLaneSF4.setModelElement(sf4);
			lowerLaneSF4.addWayPoint(new Point(lowerLaneS4.getX(), lowerLaneS4.getY()));
			lowerLaneSF4.addWayPoint(new Point(lowerLaneS5.getX(), lowerLaneS5.getY()));
			diagram.addDiagramElement(lowerLaneSF4);

			SequenceFlowBean sf5 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_SF_5_ID);
			BPMNEdge lowerLaneSF5 = new BPMNEdge();
			lowerLaneSF5.setSource(lowerLaneS);
			lowerLaneSF5.setTarget(lowerLaneS6);
			lowerLaneSF5.setModelElement(sf5);
			lowerLaneSF5.addWayPoint(new Point(lowerLaneS.getX(), lowerLaneS.getY()));
			lowerLaneSF5.addWayPoint(new Point(lowerLaneS6.getX(), lowerLaneS6.getY()));
			diagram.addDiagramElement(lowerLaneSF5);

			SequenceFlowBean sf6 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.LOWER_LANE_SF_6_ID);
			BPMNEdge lowerLaneSF6 = new BPMNEdge();
			lowerLaneSF6.setSource(lowerLaneS5);
			lowerLaneSF6.setTarget(lowerLaneS6);
			lowerLaneSF6.setModelElement(sf6);
			lowerLaneSF6.addWayPoint(new Point(lowerLaneS5.getX(), lowerLaneS5.getY()));
			lowerLaneSF6.addWayPoint(new Point(lowerLaneS6.getX(), lowerLaneS6.getY()));
			diagram.addDiagramElement(lowerLaneSF6);

		}


		MessageFlowBean mf1 = (MessageFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI2, CompleteExampleGenerator.MF_1_ID);
		BPMNEdge edgeMF1 = new BPMNEdge();
		edgeMF1.setSource(mfSource);
		edgeMF1.setTarget(mfTarget);
		edgeMF1.setModelElement(mf1);
		edgeMF1.addWayPoint(new Point(mfSource.getX(),mfSource.getY()));
		edgeMF1.addWayPoint(new Point(mfTarget.getX(),mfTarget.getY()));
		diagram.addDiagramElement(edgeMF1);


		return diagram;
	}

	

	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////



	public static IBPMNDiagram getDI3(){

		defsDI3 = BPELExampleGenerator.getExample();


		IBPMNDiagram diagram = new BPMNCollaborationDiagram();
		diagram.setId(defsDI3.getId());
		diagram.setName("");
		diagram.setResolution(1.0);

		IBPMNPlane plane = new BPMNCollaborationPlane();
		CollaborationBean collab = (CollaborationBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.COLLABORATION_ID); 
		plane.setModelElement(collab);
		diagram.setRootElement(plane);
		
		BPMNShape mf1source,mf2source,mf3source;
		BPMNShape mf1target,mf2target,mf3target;
	
		{
			//UpperPool
		    ParticipantBean upperPool = (ParticipantBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_Participant_ID);
			BPMNShape upperPoolShape = new BPMNShape();
			upperPoolShape.setX(10);
			upperPoolShape.setY(10);
			upperPoolShape.setWidth(900);
			upperPoolShape.setHeight(200);
			upperPoolShape.setExpanded(true);
			upperPoolShape.setModelElement(upperPool);

			diagram.addDiagramElement(upperPoolShape);

			//UpperLane
			LaneBean upperLane = (LaneBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_ID);
			BPMNShape upperLaneShape = new BPMNShape();
			upperLaneShape.setX(10);	
			upperLaneShape.setY(10);
			upperLaneShape.setWidth(890);
			upperLaneShape.setHeight(190);		
			upperLaneShape.setModelElement(upperLane);

			diagram.addDiagramElement(upperLaneShape);
			upperPoolShape.addDiagramElement(upperLaneShape);
			
			
			//Start event
			StartEventBean startEvent = (StartEventBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_EL_1_ID); 
			BPMNShape upperLaneS1 = new BPMNShape();
			upperLaneS1.setX(40);
			upperLaneS1.setY(60);
			upperLaneS1.setModelElement(startEvent);
			diagram.addDiagramElement(upperLaneS1);
			upperLaneShape.addDiagramElement(upperLaneS1);

			//task
			TaskBean t1 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_EL_2_ID);
			BPMNShape upperLaneS2 = new BPMNShape();
			upperLaneS2.setX(110);
			upperLaneS2.setY(50);
			upperLaneS2.setModelElement(t1);
			diagram.addDiagramElement(upperLaneS2);
			upperLaneShape.addDiagramElement(upperLaneS2);
			
			TaskBean t2 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_EL_3_ID);
			BPMNShape upperLaneS3 = new BPMNShape();
			upperLaneS3.setX(240);
			upperLaneS3.setY(50);
			upperLaneS3.setModelElement(t2);
			diagram.addDiagramElement(upperLaneS3);
			upperLaneShape.addDiagramElement(upperLaneS3);
			
			TaskBean t3 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_EL_4_ID);
			BPMNShape upperLaneS4 = new BPMNShape();
			upperLaneS4.setX(370);
			upperLaneS4.setY(50);
			upperLaneS4.setModelElement(t3);
			diagram.addDiagramElement(upperLaneS4);
			upperLaneShape.addDiagramElement(upperLaneS4);
			mf1source = upperLaneS4;
			
			TaskBean t4 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_EL_5_ID);
			BPMNShape upperLaneS5 = new BPMNShape();
			upperLaneS5.setX(500);
			upperLaneS5.setY(50);
			upperLaneS5.setModelElement(t4);
			diagram.addDiagramElement(upperLaneS5);
			upperLaneShape.addDiagramElement(upperLaneS5);
			mf2target = upperLaneS5;
			mf3target = upperLaneS5;
			
			ExclusiveGatewayBean eg = (ExclusiveGatewayBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_EL_6_ID);
			BPMNShape upperLaneS6 = new BPMNShape();
			upperLaneS6.setX(630);
			upperLaneS6.setY(50);
			upperLaneS6.setModelElement(eg);
			diagram.addDiagramElement(upperLaneS6);
			upperLaneShape.addDiagramElement(upperLaneS6);
			
			TaskBean t5 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_EL_7_ID);
			BPMNShape upperLaneS7 = new BPMNShape();
			upperLaneS7.setX(710);
			upperLaneS7.setY(130);
			upperLaneS7.setModelElement(t5);
			diagram.addDiagramElement(upperLaneS7);
			upperLaneShape.addDiagramElement(upperLaneS7);
			
			EndEventBean endEvent1 = (EndEventBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_EL_8_ID);
			BPMNShape upperLaneS8 = new BPMNShape();
			upperLaneS8.setX(840);
			upperLaneS8.setY(130);
			upperLaneS8.setModelElement(endEvent1);
			diagram.addDiagramElement(upperLaneS8);
			upperLaneShape.addDiagramElement(upperLaneS8);
			
			TaskBean t6 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_EL_9_ID);
			BPMNShape upperLaneS9 = new BPMNShape();
			upperLaneS9.setX(710);
			upperLaneS9.setY(20);
			upperLaneS9.setModelElement(t6);
			diagram.addDiagramElement(upperLaneS9);
			upperLaneShape.addDiagramElement(upperLaneS9);
			
			EndEventBean endEvent2 = (EndEventBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_EL_10_ID);
			BPMNShape upperLaneS10 = new BPMNShape();
			upperLaneS10.setX(840);
			upperLaneS10.setY(20);
			upperLaneS10.setModelElement(endEvent2);
			diagram.addDiagramElement(upperLaneS10);
			upperLaneShape.addDiagramElement(upperLaneS10);
			
			SequenceFlowBean sf1 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_SF_1_ID);
			BPMNEdge upperLaneSF1 = new BPMNEdge();
			upperLaneSF1.setSource(upperLaneS1);
			upperLaneSF1.setTarget(upperLaneS2);
			upperLaneSF1.setModelElement(sf1);
			upperLaneSF1.addWayPoint(new Point(upperLaneS1.getX(), upperLaneS1.getY()));
			upperLaneSF1.addWayPoint(new Point(upperLaneS2.getX(), upperLaneS2.getY()));
			diagram.addDiagramElement(upperLaneSF1);
			
			SequenceFlowBean sf2 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_SF_2_ID);
			BPMNEdge upperLaneSF2 = new BPMNEdge();
			upperLaneSF2.setSource(upperLaneS2);
			upperLaneSF2.setTarget(upperLaneS3);
			upperLaneSF2.setModelElement(sf2);
			upperLaneSF2.addWayPoint(new Point(upperLaneS2.getX(), upperLaneS2.getY()));
			upperLaneSF2.addWayPoint(new Point(upperLaneS3.getX(), upperLaneS3.getY()));
			diagram.addDiagramElement(upperLaneSF2);
			
			SequenceFlowBean sf3 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_SF_3_ID);
			BPMNEdge upperLaneSF3 = new BPMNEdge();
			upperLaneSF3.setSource(upperLaneS3);
			upperLaneSF3.setTarget(upperLaneS4);
			upperLaneSF3.setModelElement(sf3);
			upperLaneSF3.addWayPoint(new Point(upperLaneS3.getX(), upperLaneS3.getY()));
			upperLaneSF3.addWayPoint(new Point(upperLaneS4.getX(), upperLaneS4.getY()));
			diagram.addDiagramElement(upperLaneSF3);
			
			SequenceFlowBean sf4 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_SF_4_ID);
			BPMNEdge upperLaneSF4 = new BPMNEdge();
			upperLaneSF4.setSource(upperLaneS4);
			upperLaneSF4.setTarget(upperLaneS5);
			upperLaneSF4.setModelElement(sf4);
			upperLaneSF4.addWayPoint(new Point(upperLaneS4.getX(), upperLaneS4.getY()));
			upperLaneSF4.addWayPoint(new Point(upperLaneS5.getX(), upperLaneS5.getY()));
			diagram.addDiagramElement(upperLaneSF4);
			
			SequenceFlowBean sf5 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_SF_5_ID);
			BPMNEdge upperLaneSF5 = new BPMNEdge();
			upperLaneSF5.setSource(upperLaneS5);
			upperLaneSF5.setTarget(upperLaneS6);
			upperLaneSF5.setModelElement(sf5);
			upperLaneSF5.addWayPoint(new Point(upperLaneS5.getX(), upperLaneS5.getY()));
			upperLaneSF5.addWayPoint(new Point(upperLaneS6.getX(), upperLaneS6.getY()));
			diagram.addDiagramElement(upperLaneSF5);
			
			SequenceFlowBean sf6 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_SF_6_ID);
			BPMNEdge upperLaneSF6 = new BPMNEdge();
			upperLaneSF6.setSource(upperLaneS6);
			upperLaneSF6.setTarget(upperLaneS9);
			upperLaneSF6.setModelElement(sf6);
			upperLaneSF6.addWayPoint(new Point(upperLaneS6.getX(), upperLaneS6.getY()));
			upperLaneSF6.addWayPoint(new Point(upperLaneS9.getX(), upperLaneS9.getY()));
			diagram.addDiagramElement(upperLaneSF6);
			
			SequenceFlowBean sf7 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_SF_7_ID);
			BPMNEdge upperLaneSF7 = new BPMNEdge();
			upperLaneSF7.setSource(upperLaneS6);
			upperLaneSF7.setTarget(upperLaneS7);
			upperLaneSF7.setModelElement(sf7);
			upperLaneSF7.addWayPoint(new Point(upperLaneS6.getX(), upperLaneS6.getY()));
			upperLaneSF7.addWayPoint(new Point(upperLaneS7.getX(), upperLaneS7.getY()));
			diagram.addDiagramElement(upperLaneSF7);
			
			SequenceFlowBean sf8 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_SF_8_ID);
			BPMNEdge upperLaneSF8 = new BPMNEdge();
			upperLaneSF8.setSource(upperLaneS9);
			upperLaneSF8.setTarget(upperLaneS10);
			upperLaneSF8.setModelElement(sf8);
			upperLaneSF8.addWayPoint(new Point(upperLaneS9.getX(), upperLaneS9.getY()));
			upperLaneSF8.addWayPoint(new Point(upperLaneS10.getX(), upperLaneS10.getY()));
			diagram.addDiagramElement(upperLaneSF8);
			
			SequenceFlowBean sf9 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.UPPER_LANE_SF_9_ID);
			BPMNEdge upperLaneSF9 = new BPMNEdge();
			upperLaneSF9.setSource(upperLaneS7);
			upperLaneSF9.setTarget(upperLaneS8);
			upperLaneSF9.setModelElement(sf9);
			upperLaneSF9.addWayPoint(new Point(upperLaneS7.getX(), upperLaneS7.getY()));
			upperLaneSF9.addWayPoint(new Point(upperLaneS8.getX(), upperLaneS8.getY()));
			diagram.addDiagramElement(upperLaneSF9);
		}
		
		
		
		{
			//lowerPool
		    ParticipantBean lowerPool = (ParticipantBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_Participant_ID);
			BPMNShape lowerPoolShape = new BPMNShape();
			lowerPoolShape.setX(10);
			lowerPoolShape.setY(250);
			lowerPoolShape.setWidth(800);
			lowerPoolShape.setHeight(200);
			lowerPoolShape.setExpanded(true);
			lowerPoolShape.setModelElement(lowerPool);

			diagram.addDiagramElement(lowerPoolShape);

			//lowerLane
			LaneBean lowerLane = (LaneBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_ID);
			BPMNShape lowerLaneShape = new BPMNShape();
			lowerLaneShape.setX(10);	
			lowerLaneShape.setY(10);
			lowerLaneShape.setWidth(790);
			lowerLaneShape.setHeight(190);		
			lowerLaneShape.setModelElement(lowerLane);

			diagram.addDiagramElement(lowerLaneShape);
			lowerPoolShape.addDiagramElement(lowerLaneShape);
			
			
			//Start event
			StartEventBean startEvent = (StartEventBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_EL_1_ID); 
			BPMNShape lowerLaneS1 = new BPMNShape();
			lowerLaneS1.setX(70);
			lowerLaneS1.setY(50);
			lowerLaneS1.setModelElement(startEvent);
			diagram.addDiagramElement(lowerLaneS1);
			lowerLaneShape.addDiagramElement(lowerLaneS1);
			mf1target = lowerLaneS1;

			//task
			TaskBean t1 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_EL_2_ID);
			BPMNShape lowerLaneS2 = new BPMNShape();
			lowerLaneS2.setX(140);
			lowerLaneS2.setY(50);
			lowerLaneS2.setModelElement(t1);
			diagram.addDiagramElement(lowerLaneS2);
			lowerLaneShape.addDiagramElement(lowerLaneS2);
			
			TaskBean t2 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_EL_3_ID);
			BPMNShape lowerLaneS3 = new BPMNShape();
			lowerLaneS3.setX(270);
			lowerLaneS3.setY(50);
			lowerLaneS3.setModelElement(t2);
			diagram.addDiagramElement(lowerLaneS3);
			lowerLaneShape.addDiagramElement(lowerLaneS3);
			
			ExclusiveGatewayBean eg = (ExclusiveGatewayBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_EL_4_ID);
			BPMNShape lowerLaneS4 = new BPMNShape();
			lowerLaneS4.setX(400);
			lowerLaneS4.setY(50);
			lowerLaneS4.setModelElement(eg);
			diagram.addDiagramElement(lowerLaneS4);
			lowerLaneShape.addDiagramElement(lowerLaneS4);
			
			TaskBean t3 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_EL_5_ID);
			BPMNShape lowerLaneS5 = new BPMNShape();
			lowerLaneS5.setX(480);
			lowerLaneS5.setY(20);
			lowerLaneS5.setModelElement(t3);
			diagram.addDiagramElement(lowerLaneS5);
			lowerLaneShape.addDiagramElement(lowerLaneS5);
			
			TaskBean t4 = (TaskBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_EL_6_ID);
			BPMNShape lowerLaneS6 = new BPMNShape();
			lowerLaneS6.setX(480);
			lowerLaneS6.setY(130);
			lowerLaneS6.setModelElement(t4);
			diagram.addDiagramElement(lowerLaneS6);
			lowerLaneShape.addDiagramElement(lowerLaneS6);
			
			EndEventBean endEvent1 = (EndEventBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_EL_7_ID);
			BPMNShape lowerLaneS7 = new BPMNShape();
			lowerLaneS7.setX(610);
			lowerLaneS7.setY(20);
			lowerLaneS7.setModelElement(endEvent1);
			diagram.addDiagramElement(lowerLaneS7);
			lowerLaneShape.addDiagramElement(lowerLaneS7);
			mf2source = lowerLaneS7;
			
			EndEventBean endEvent2 = (EndEventBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_EL_8_ID);
			BPMNShape lowerLaneS8 = new BPMNShape();
			lowerLaneS8.setX(710);
			lowerLaneS8.setY(130);
			lowerLaneS8.setModelElement(endEvent2);
			diagram.addDiagramElement(lowerLaneS8);
			lowerLaneShape.addDiagramElement(lowerLaneS8);
			mf3source = lowerLaneS8;
			
			SequenceFlowBean sf0 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_SF_0_ID);
			BPMNEdge lowerLaneSF0 = new BPMNEdge();
			lowerLaneSF0.setSource(lowerLaneS1);
			lowerLaneSF0.setTarget(lowerLaneS2);
			lowerLaneSF0.setModelElement(sf0);
			lowerLaneSF0.addWayPoint(new Point(lowerLaneS1.getX(), lowerLaneS1.getY()));
			lowerLaneSF0.addWayPoint(new Point(lowerLaneS2.getX(), lowerLaneS2.getY()));
			diagram.addDiagramElement(lowerLaneSF0);
			
			SequenceFlowBean sf1 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_SF_1_ID);
			BPMNEdge lowerLaneSF1 = new BPMNEdge();
			lowerLaneSF1.setSource(lowerLaneS2);
			lowerLaneSF1.setTarget(lowerLaneS3);
			lowerLaneSF1.setModelElement(sf1);
			lowerLaneSF1.addWayPoint(new Point(lowerLaneS2.getX(), lowerLaneS2.getY()));
			lowerLaneSF1.addWayPoint(new Point(lowerLaneS3.getX(), lowerLaneS3.getY()));
			diagram.addDiagramElement(lowerLaneSF1);
			
			SequenceFlowBean sf2 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_SF_2_ID);
			BPMNEdge lowerLaneSF2 = new BPMNEdge();
			lowerLaneSF2.setSource(lowerLaneS3);
			lowerLaneSF2.setTarget(lowerLaneS4);
			lowerLaneSF2.setModelElement(sf2);
			lowerLaneSF2.addWayPoint(new Point(lowerLaneS3.getX(), lowerLaneS3.getY()));
			lowerLaneSF2.addWayPoint(new Point(lowerLaneS4.getX(), lowerLaneS4.getY()));
			diagram.addDiagramElement(lowerLaneSF2);
			
			SequenceFlowBean sf3 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_SF_3_ID);
			BPMNEdge lowerLaneSF3 = new BPMNEdge();
			lowerLaneSF3.setSource(lowerLaneS4);
			lowerLaneSF3.setTarget(lowerLaneS5);
			lowerLaneSF3.setModelElement(sf3);
			lowerLaneSF3.addWayPoint(new Point(lowerLaneS4.getX(), lowerLaneS4.getY()));
			lowerLaneSF3.addWayPoint(new Point(lowerLaneS5.getX(), lowerLaneS5.getY()));
			diagram.addDiagramElement(lowerLaneSF3);
			
			SequenceFlowBean sf4 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_SF_4_ID);
			BPMNEdge lowerLaneSF4 = new BPMNEdge();
			lowerLaneSF4.setSource(lowerLaneS4);
			lowerLaneSF4.setTarget(lowerLaneS6);
			lowerLaneSF4.setModelElement(sf4);
			lowerLaneSF4.addWayPoint(new Point(lowerLaneS4.getX(), lowerLaneS4.getY()));
			lowerLaneSF4.addWayPoint(new Point(lowerLaneS6.getX(), lowerLaneS6.getY()));
			diagram.addDiagramElement(lowerLaneSF4);
			
			SequenceFlowBean sf5 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_SF_5_ID);
			BPMNEdge lowerLaneSF5 = new BPMNEdge();
			lowerLaneSF5.setSource(lowerLaneS5);
			lowerLaneSF5.setTarget(lowerLaneS7);
			lowerLaneSF5.setModelElement(sf5);
			lowerLaneSF5.addWayPoint(new Point(lowerLaneS5.getX(), lowerLaneS5.getY()));
			lowerLaneSF5.addWayPoint(new Point(lowerLaneS7.getX(), lowerLaneS7.getY()));
			diagram.addDiagramElement(lowerLaneSF5);
			
			SequenceFlowBean sf6 = (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.LOWER_LANE_SF_6_ID);
			BPMNEdge lowerLaneSF6 = new BPMNEdge();
			lowerLaneSF6.setSource(lowerLaneS6);
			lowerLaneSF6.setTarget(lowerLaneS8);
			lowerLaneSF6.setModelElement(sf6);
			lowerLaneSF6.addWayPoint(new Point(lowerLaneS6.getX(), lowerLaneS6.getY()));
			lowerLaneSF6.addWayPoint(new Point(lowerLaneS8.getX(), lowerLaneS8.getY()));
			diagram.addDiagramElement(lowerLaneSF6);
		}
		
		MessageFlowBean mf1 = (MessageFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.MF_1_ID);
		BPMNEdge mfEdge1 = new BPMNEdge();
		mfEdge1.setSource(mf1source);
		mfEdge1.setTarget(mf1target);
		mfEdge1.setModelElement(mf1);
		mfEdge1.addWayPoint(new Point(mf1source.getX(),mf1source.getY()));
		mfEdge1.addWayPoint(new Point(mf1target.getX(),mf1target.getY()));
		diagram.addDiagramElement(mfEdge1);
		
		MessageFlowBean mf2 = (MessageFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.MF_2_ID);
		BPMNEdge mfEdge2 = new BPMNEdge();
		mfEdge2.setSource(mf2source);
		mfEdge2.setTarget(mf2target);
		mfEdge2.setModelElement(mf2);
		mfEdge2.addWayPoint(new Point(mf2source.getX(),mf2source.getY()));
		mfEdge2.addWayPoint(new Point(mf2target.getX(),mf2target.getY()));
		diagram.addDiagramElement(mfEdge2);
		
		MessageFlowBean mf3= (MessageFlowBean) DefinitionsHelper.getInstance().getElementById(defsDI3, BPELExampleGenerator.MF_3_ID);
		BPMNEdge mfEdge3 = new BPMNEdge();
		mfEdge3.setSource(mf3source);
		mfEdge3.setTarget(mf3target);
		mfEdge3.setModelElement(mf3);
		mfEdge3.addWayPoint(new Point(mf3source.getX(),mf3source.getY()));
		mfEdge3.addWayPoint(new Point(mf3target.getX(),mf3target.getY()));
		diagram.addDiagramElement(mfEdge3);
		
		return diagram;
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////

	
	public static IBPMNDiagram getPrivateProcessDI1(){
		
		privateProcessDefsDI1 = PrivateProcessMockDB.getProcess1();
		DefinitionsBean processDef = privateProcessDefsDI1;
		

		
		IBPMNDiagram di = new BPMNCollaborationDiagram();
		di.setId(processDef.getId());
		di.setName("");
		di.setResolution(1.0);

		IBPMNPlane plane = new BPMNCollaborationPlane();
//		ProcessBean process = (ProcessBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_ID); 
//		plane.setModelElement(process);
		CollaborationBean collaboration = (CollaborationBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.COLLABORATION_ID); 
        plane.setModelElement(collaboration);
        collaboration.addParticipant(new ParticipantBean());
		di.setRootElement(plane);
		
		//SHAPE 1
		StartEventBean startEvent = (StartEventBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL1_ID);
		BPMNShape shape1 = new BPMNShape();
		shape1.setModelElement(startEvent);
		shape1.setX(20);
		shape1.setY(150);
		
		di.addDiagramElement(shape1);
		
		//SHAPE 2
		TaskBean task1 = (TaskBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL2_ID);
		BPMNShape shape2 = new BPMNShape();
		shape2.setModelElement(task1);
		shape2.setX(100);
		shape2.setY(140);
		
		di.addDiagramElement(shape2);
		
		//SHAPE 3
		TaskBean task2 = (TaskBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL3_ID);
		BPMNShape shape3 = new BPMNShape();
		shape3.setModelElement(task2);
		shape3.setX(270);
		shape3.setY(140);
		
		di.addDiagramElement(shape3);
		
		//SHAPE 4
		ExclusiveGatewayBean exclusiveGw1= (ExclusiveGatewayBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL4_ID);
		BPMNShape shape4 = new BPMNShape();
		shape4.setModelElement(exclusiveGw1);
		shape4.setX(420);
		shape4.setY(140);
		
		di.addDiagramElement(shape4);
		
		//SHAPE 5
		EndEventBean endEvent1= (EndEventBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL5_ID);
		BPMNShape shape5 = new BPMNShape();
		shape5.setModelElement(endEvent1);
		shape5.setX(410);
		shape5.setY(50);
		
		di.addDiagramElement(shape5);
		
		//SHAPE 6
		ParallelGatewayBean pgwt1= (ParallelGatewayBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL6_ID);
		BPMNShape shape6 = new BPMNShape();
		shape6.setModelElement(pgwt1);
		shape6.setX(470);
		shape6.setY(140);
		
		di.addDiagramElement(shape6);
		
		//SHAPE 7
		TaskBean task3= (TaskBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL7_ID);
		BPMNShape shape7 = new BPMNShape();
		shape7.setModelElement(task3);
		shape7.setX(520);
		shape7.setY(50);
		
		di.addDiagramElement(shape7);
		
		//SHAPE 8
		TaskBean task4= (TaskBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL8_ID);
		BPMNShape shape8 = new BPMNShape();
		shape8.setModelElement(task4);
		shape8.setX(520);
		shape8.setY(220);
		
		di.addDiagramElement(shape8);
		
		//SHAPE 9
		ParallelGatewayBean pgwt2= (ParallelGatewayBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL9_ID);
		BPMNShape shape9 = new BPMNShape();
		shape9.setModelElement(pgwt2);
		shape9.setX(670);
		shape9.setY(140);
		
		di.addDiagramElement(shape9);
		
		//SHAPE 10
		TaskBean task5= (TaskBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL10_ID);
		BPMNShape shape10 = new BPMNShape();
		shape10.setModelElement(task5);
		shape10.setX(760);
		shape10.setY(140);
		
		di.addDiagramElement(shape10);
		
		//SHAPE 11
		EndEventBean endEvent2= (EndEventBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL11_ID);
		BPMNShape shape11 = new BPMNShape();
		shape11.setModelElement(endEvent2);
		shape11.setX(890);
		shape11.setY(150);
		
		di.addDiagramElement(shape11);
		
		//Edge 1
		SequenceFlowBean sf1= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL12_ID);
		BPMNEdge edge1 = new BPMNEdge();
		edge1.setModelElement(sf1);
		edge1.setSource(shape1);
		edge1.setTarget(shape2);
		edge1.addWayPoint(new Point(shape1.getX(), shape1.getY()));
		edge1.addWayPoint(new Point(shape2.getX(), shape2.getY()));
		
		di.addDiagramElement(edge1);
		
		//Edge 2
		SequenceFlowBean sf2= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL13_ID);
		BPMNEdge edge2 = new BPMNEdge();
		edge2.setModelElement(sf2);
		edge2.setSource(shape2);
		edge2.setTarget(shape3);
		edge2.addWayPoint(new Point(shape2.getX(), shape2.getY()));
		edge2.addWayPoint(new Point(shape3.getX(), shape3.getY()));
		
		di.addDiagramElement(edge2);
		
		//Edge 3
		SequenceFlowBean sf3= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL14_ID);
		BPMNEdge edge3 = new BPMNEdge();
		edge3.setModelElement(sf3);
		edge3.setSource(shape3);
		edge3.setTarget(shape4);
		edge3.addWayPoint(new Point(shape3.getX(), shape3.getY()));
		edge3.addWayPoint(new Point(shape4.getX(), shape4.getY()));
		
		di.addDiagramElement(edge3);
		
		//Edge 4
		SequenceFlowBean sf4= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL15_ID);
		BPMNEdge edge4 = new BPMNEdge();
		edge4.setModelElement(sf4);
		edge4.setSource(shape4);
		edge4.setTarget(shape5);
		edge4.addWayPoint(new Point(shape4.getX(), shape4.getY()));
		edge4.addWayPoint(new Point(shape5.getX(), shape5.getY()));
		
		di.addDiagramElement(edge4);
		
		//Edge 5
		SequenceFlowBean sf5= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL16_ID);
		BPMNEdge edge5 = new BPMNEdge();
		edge5.setModelElement(sf5);
		edge5.setSource(shape4);
		edge5.setTarget(shape6);
		edge5.addWayPoint(new Point(shape4.getX(), shape4.getY()));
		edge5.addWayPoint(new Point(shape6.getX(), shape6.getY()));
		
		di.addDiagramElement(edge5);
		
		//Edge 6
		SequenceFlowBean sf6= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL17_ID);
		BPMNEdge edge6 = new BPMNEdge();
		edge6.setModelElement(sf6);
		edge6.setSource(shape6);
		edge6.setTarget(shape7);
		edge6.addWayPoint(new Point(shape6.getX(), shape6.getY()));
		edge6.addWayPoint(new Point(shape7.getX(), shape7.getY()));
		
		di.addDiagramElement(edge6);
		
		//Edge 7
		SequenceFlowBean sf7= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL18_ID);
		BPMNEdge edge7 = new BPMNEdge();
		edge7.setModelElement(sf7);
		edge7.setSource(shape6);
		edge7.setTarget(shape8);
		edge7.addWayPoint(new Point(shape6.getX(), shape6.getY()));
		edge7.addWayPoint(new Point(shape8.getX(), shape8.getY()));
		
		di.addDiagramElement(edge7);
		
		//Edge 8
		SequenceFlowBean sf8= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL19_ID);
		BPMNEdge edge8 = new BPMNEdge();
		edge8.setModelElement(sf8);
		edge8.setSource(shape7);
		edge8.setTarget(shape9);
		edge8.addWayPoint(new Point(shape7.getX(), shape7.getY()));
		edge8.addWayPoint(new Point(shape9.getX(), shape9.getY()));
		
		di.addDiagramElement(edge8);
		
		//Edge 9
		SequenceFlowBean sf9= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL20_ID);
		BPMNEdge edge9 = new BPMNEdge();
		edge9.setModelElement(sf9);
		edge9.setSource(shape8);
		edge9.setTarget(shape9);
		edge9.addWayPoint(new Point(shape8.getX(), shape8.getY()));
		edge9.addWayPoint(new Point(shape9.getX(), shape9.getY()));
		
		di.addDiagramElement(edge9);
		
		//Edge 10
		SequenceFlowBean sf10= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL21_ID);
		BPMNEdge edge10 = new BPMNEdge();
		edge10.setModelElement(sf10);
		edge10.setSource(shape9);
		edge10.setTarget(shape10);
		edge10.addWayPoint(new Point(shape9.getX(), shape9.getY()));
		edge10.addWayPoint(new Point(shape10.getX(), shape10.getY()));
		
		di.addDiagramElement(edge10);
		
		//Edge 11
		SequenceFlowBean sf11= (SequenceFlowBean) DefinitionsHelper.getInstance().getElementById(processDef, PrivateProcessMockDB.PROCESS1_EL22_ID);
		BPMNEdge edge11 = new BPMNEdge();
		edge11.setModelElement(sf11);
		edge11.setSource(shape10);
		edge11.setTarget(shape11);
		edge11.addWayPoint(new Point(shape10.getX(), shape10.getY()));
		edge11.addWayPoint(new Point(shape11.getX(), shape11.getY()));
		
		di.addDiagramElement(edge11);
		
		
		
		
		return di;
	}
	
	
}
