/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.signal;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.AbstractEditableGrid;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.ISignalBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.ISignalEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.SignalEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.SignalEventDefinition;
import com.google.gwt.user.client.DOM;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.EditorGridPanel;

public class SignalEventDefinitionPanel extends AbstractEditableGrid<ISignalEventDefinitionBean>{
	
	
	
	private ColumnConfig signalRefColumn;

	public SignalEventDefinitionPanel() {
		super();
	}

	@Override
	protected void bind(Record record, ISignalEventDefinitionBean value) {
		value.setSignal((ISignalBean) record.getAsObject(SignalEventDefinition.signalRef.toString()));
	}

	@Override
	protected void buildGrid() {
		super.buildGrid();
		gridPanel.getView().setForceFit(true);
	}
	
	@Override
	protected String getAddText() {
		return "Add Signal Event Definition";
	}

	@Override
	protected ISignalEventDefinitionBean getNewDefaultRecord() {
		return new SignalEventDefinitionBean(DOM.createUniqueId());
	}

	@Override
	protected String getRemoveText() {
		return "Remove Signal Event Definition";
	}

	@Override
	protected Object[] convertDataToObject(ISignalEventDefinitionBean data) {
		
		Object[] object = new Object[2];
		
		object[0] = data.getId();
		object[1] = data.getSignal();
		
		return object;
	}

	@Override
	protected List<BaseColumnConfig> getColumnsConfig() {
		
		ArrayList<BaseColumnConfig> cc 		= new ArrayList<BaseColumnConfig>();
		
		ColumnConfig id = new ColumnConfig(SignalEventDefinition.id.getLabel(), SignalEventDefinition.id.toString());
		
		this.signalRefColumn = new ColumnConfig(SignalEventDefinition.signalRef.getLabel(),SignalEventDefinition.signalRef.toString());
		
		cc.add(id);
		cc.add(signalRefColumn);
		
		return cc;
	}
	
	public ColumnConfig getSignalRefColumn() {
		return signalRefColumn;
	}
	
	@Override
	protected FieldDef[] getFieldDef() {
		return new FieldDef[]{
				new StringFieldDef(SignalEventDefinition.id.toString()),
				new ObjectFieldDef(SignalEventDefinition.signalRef.toString()),
		};
	}
	
	
	@Override
	protected EditorGridPanel getGridPanel() {
		return super.getGridPanel();
	}

	@Override
	protected boolean isValid(ISignalEventDefinitionBean data) {
		
		if (data.getId()!=null && data.getSignal()!=null){
			return true;
		}
		
		return false;
	}

}
