/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.operation;

import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AddElementEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AfterEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.BeforeEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.EditableGridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.RemoveElementEvent;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.Constants.Operation;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddInterfaceEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.error.ErrorRefMultipleComboBox;
import com.ebmwebsourcing.petalsbpm.definitionseditor.interfaces.InterfaceController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.message.MessageRefComboBox;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;
import com.gwtext.client.widgets.grid.GridEditor;

public class OperationController extends AbstractController implements EditableGridHandler{
	
	private OperationPanel panel;
	private List<IMessageBean> msgs;
	private List<IErrorBean> errs;
	private List<String> operationRefs;
	private IInterfaceBean actualInterface;
	private Record actualRecord;
	private InterfaceController interfaceController;
	
	public OperationController(OperationPanel panel,List<IMessageBean> msgs,List<IErrorBean> errors,List<String> operationRefs,IInterfaceBean actualInterface, InterfaceController interfaceController) {
	
		this.panel = panel;
		this.msgs  = msgs;
		this.errs  = errors;
		this.operationRefs = operationRefs;
		this.actualInterface = actualInterface;
		this.interfaceController = interfaceController;
		
		panel.addHandler(this);
		
		init();
	}
	
	private void init(){
		
		//bind interface name 
		
		
		
		//input message
		MessageRefComboBox inmessageRef = new MessageRefComboBox(msgs);
		
		inmessageRef.addListener(new ComboBoxListenerAdapter(){
			@Override
			public void onSelect(ComboBox comboBox, Record record, int index) {
				
				actualRecord.set(Operation.inMessage.toString(), record.getAsObject("value"));
				
			}
		});
		
		this.panel.getInMessageColumn().setEditor(new GridEditor(inmessageRef));
		
		//output message
		MessageRefComboBox outMessageRef = new MessageRefComboBox(msgs);
		
		outMessageRef.addListener(new ComboBoxListenerAdapter(){
			@Override
			public void onSelect(ComboBox comboBox, Record record, int index) {
				
				actualRecord.set(Operation.outMessage.toString(), record.getAsObject("value"));
				
			}
		});
		
		
		this.panel.getOutMessageColumn().setEditor(new GridEditor(outMessageRef));
		
		//Error message
		ErrorRefMultipleComboBox errorRefs = new ErrorRefMultipleComboBox(errs);
		
		errorRefs.addListener(new ComboBoxListenerAdapter(){
			@Override
			public void onSelect(ComboBox comboBox, Record record, int index) {
				
				actualRecord.set(Operation.errorRef.toString(), record.getAsObject("value"));
				
			}
		});
		
		this.panel.getErrorRefColumn().setEditor(new GridEditor(errorRefs));
		
		
		//WSDL operation imple ref
		WSDLOperationImplementationRefComboBox wsdlImplRef = new WSDLOperationImplementationRefComboBox(operationRefs);
		
		wsdlImplRef.addListener(new ComboBoxListenerAdapter(){
			@Override
			public void onSelect(ComboBox comboBox, Record record, int index) {
				
				actualRecord.set(Operation.implementationRef.toString(), record.getAsObject("value"));
				
			}
		});
		
		this.panel.getImplementationRefColumn().setEditor(new GridEditor(wsdlImplRef));
	}

	@Override
	public void onAddElement(AddElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAfterEditRecord(AfterEditRecordEvent<?> event) {
		//validate actual operation		
		validate(panel.getSelectedValues().get(0));
	
	}
	
	
	private void validate(IOperationBean operationBean){
		
		
		//check if operation is ok, if yes, add it to interface				
		if (operationBean.getName()!=null && operationBean.getName().equals("")==false && operationBean.getMessageIn()!=null && operationBean.getMessageOut()!=null){
			
			if (actualInterface.getOperations().contains(operationBean)==false) actualInterface.addOperation(operationBean);
			
			//if interface is ok
			if (actualInterface.getName()!=null  && actualInterface.getName().equals("")==false ){
				
				//add interface to definitions 
				interfaceController.fireEvent(new AddInterfaceEvent(actualInterface));
				
			}

		}
		
  }
	

	
	@Override
	public void onBeforeEditorRecord(BeforeEditRecordEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveElement(RemoveElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onCellClick(CellClickEvent event) {
		this.actualRecord = panel.getGridPanel().getStore().getAt(event.getRowIndex());
		
	}
	
}
