/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.IInteractionNodeBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.LaneSetBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.FlowNodeBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ItemDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.MessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.PartnerRoleBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.ImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.NamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.ProcessBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.ExpressionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.EventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.SequenceFlowBean;

public class MockDefinitionsDB {
	
	private static List<FlowNodeBean> upperParticipantNodes;
	private static List<FlowNodeBean> lowerParticipantNodes;
	
	public static String COLLABORATION_ID;
	public static String UPPER_Participant_ID;
	public static String LOWER_Participant_ID;
	public static String UPPER_LANE_ID;
	public static String LOWER_LANE_ID;
	public static String UPPER_LANE_EL_1_ID;
	public static String UPPER_LANE_EL_2_ID;
	public static String UPPER_LANE_EL_3_ID;
	public static String UPPER_LANE_EL_4_ID;
	public static String UPPER_LANE_EL_5_ID;
	public static String UPPER_LANE_EL_6_ID;
	public static String UPPER_LANE_EL_7_ID;
	public static String UPPER_LANE_EL_8_ID;
	public static String UPPER_LANE_EL_9_ID;
	public static String UPPER_LANE_EL_10_ID;
	public static String UPPER_LANE_EL_11_ID;
	public static String UPPER_LANE_EL_12_ID;
	public static String UPPER_LANE_EL_13_ID;
	public static String UPPER_LANE_EL_14_ID;
	public static String UPPER_LANE_EL_15_ID;
	public static String UPPER_LANE_EL_16_ID;
	public static String UPPER_LANE_EL_17_ID;
	public static String UPPER_LANE_EL_18_ID;
	public static String UPPER_LANE_EL_19_ID;
	public static String UPPER_LANE_EL_20_ID;
	public static String UPPER_LANE_EL_21_ID;
	public static String UPPER_LANE_EL_22_ID;
	//LOWER LANE IDS
	public static String LOWER_LANE_EL_1_ID;
	public static String LOWER_LANE_EL_2_ID;
	public static String LOWER_LANE_EL_3_ID;
	public static String LOWER_LANE_EL_4_ID;
	public static String LOWER_LANE_EL_5_ID;
	public static String LOWER_LANE_EL_6_ID;
	public static String LOWER_LANE_EL_7_ID;
	public static String LOWER_LANE_EL_8_ID;
	public static String LOWER_LANE_EL_9_ID;
	public static String LOWER_LANE_EL_10_ID;
	public static String LOWER_LANE_EL_11_ID;
	public static String LOWER_LANE_EL_12_ID;
	public static String LOWER_LANE_EL_13_ID;
	public static String LOWER_LANE_EL_14_ID;
	public static String LOWER_LANE_EL_15_ID;
	public static String LOWER_LANE_EL_16_ID;
	public static String LOWER_LANE_EL_17_ID;
	public static String LOWER_LANE_EL_18_ID;
	//MESSAGE FLOWS ID
	public static String MF_1_ID;
	public static String MF_2_ID;
	public static String MF_3_ID;
	
	
	public static List<DefinitionsBean> getAllExamples(){
		List<DefinitionsBean> l = new ArrayList<DefinitionsBean>();
		
		l.add(getSingleExample());
		l.add(BPELExampleGenerator.getExample());
		l.add(CompleteExampleGenerator.getExample());
		l.add(PrivateProcessMockDB.getProcess1());
		
		return l;
	}
	

	public static DefinitionsBean getSingleExample() {
		upperParticipantNodes = new ArrayList<FlowNodeBean>();
		lowerParticipantNodes = new ArrayList<FlowNodeBean>();
		
		DefinitionsBean result = new DefinitionsBean(createUniqueId());
		
		result.setTargetNamespace("http://com.ebmwebsourcing.easybpmn/creatingIdea/definition");
		result.setTypeLanguage("http://www.w3.org/2001/XMLSchema");
		result.setExpressionLanguage("http://www.w3.org/1999/XPath");
		
		ImportBean iBean = new ImportBean(new NamespaceDeclaration("ns1", "http://com.ebmwebsourcing.easybpmn/creatingIdea/data"));
		iBean.setImportType("http://www.w3.org/2001/XMLSchema");
		iBean.setLocation("creatingIdea.xsd");
		//iBean.setNamespace("http://com.ebmwebsourcing.easybpmn/creatingIdea/data");
		
//		SchemaBean schema = new SchemaBean();
//		iBean.setSchema(schema);
//		schema.addElement(new ElementBean("input", new BasicType(BasicTypes.STRING), schema));

		List<IMessageBean> messages = buildMessages();
		result.setMessages(messages);
		
		result.addCollaboration(buildCollaboration(result));
		
		return result;
	}

	//TODO
	private static List<IMessageBean> buildMessages() {
		List<IMessageBean> result = new ArrayList<IMessageBean>();
		
		MessageBean msg1 = new MessageBean(createUniqueId());
		msg1.setName("");
		ItemDefinitionBean idb1 = new ItemDefinitionBean(createUniqueId());
		msg1.setItemDefinition(idb1);
		
		return result;
	}

	private static CollaborationBean buildCollaboration(DefinitionsBean globalResult) {
		CollaborationBean result = new CollaborationBean(createUniqueId());
		COLLABORATION_ID = result.getId();
		result.setName("creatingIdeaCollaboration");
		result.addParticipant(buildUpperParticipant(globalResult));
		result.addParticipant(buildlowerParticipant(globalResult));
		result.setMessageFlows(buildMessageFlows());
		return result;
	}

	private static ParticipantBean buildUpperParticipant(DefinitionsBean globalResult) {
		
		UPPER_Participant_ID = createUniqueId();
		ParticipantBean result = new ParticipantBean(UPPER_Participant_ID);
		result.setName("VO member (idea creator)");

//		InterfaceBean itfBean = new InterfaceBean(createUniqueId());
//		itfBean.setName(result.getId()+"Itf");
////		itfBean.setOperations();
//		globalResult.addInterface(itfBean);
//		result.addInterface(itfBean);
		
		PartnerRoleBean pr = new PartnerRoleBean(createUniqueId());
		pr.setName(result.getName());
		pr.addParticipant(result);
		globalResult.addPartnerRole(pr);
		
		ProcessBean process = new ProcessBean(createUniqueId());
		process.setName(process.getId());
		process.setType(ProcessTypes.PUBLIC);
		globalResult.addProcess(process);
		result.setProcess(process);
		LaneSetBean laneSet = new LaneSetBean(createUniqueId());
		process.addLaneSet(laneSet);
		laneSet.addLane(buildUpperLane(process,globalResult));
		return result;
	}
	
	private static LaneBean buildUpperLane(ProcessBean process, DefinitionsBean globalResult) {
		
		UPPER_LANE_ID = createUniqueId();
		
		LaneBean result = new LaneBean(UPPER_LANE_ID);
		result.setName("VO Member (idea creator)");
		
		//NODES
		UPPER_LANE_EL_1_ID = createUniqueId();
		StartEventBean startEvent = new StartEventBean(UPPER_LANE_EL_1_ID);
		startEvent.setName("VO Member ...");
		EventDefinitionBean ed = new MessageEventDefinitionBean(createUniqueId());
		((MessageEventDefinitionBean)ed).setMessage(new MessageBean(IdGenerator.createUniqueId()));
		globalResult.addEventDefinition(ed);
		startEvent.addTrigger(ed);
		result.addStartEvent(startEvent);
		process.addStartEvent(startEvent);
		
		UPPER_LANE_EL_2_ID = createUniqueId();
		ReceiveTaskBean task1 = new ReceiveTaskBean(UPPER_LANE_EL_2_ID);
		task1.setName("Fill in idea entry \r\n template");
		result.addTask(task1);
		process.addTask(task1);
		
		UPPER_LANE_EL_3_ID = createUniqueId();
		TaskBean task2 = new TaskBean(UPPER_LANE_EL_3_ID);
		task2.setName("Store in VO's \r\n KB");
		result.addTask(task2);
		process.addTask(task2);
		
		UPPER_LANE_EL_4_ID = createUniqueId();
		SendTaskBean task3 = new SendTaskBean(UPPER_LANE_EL_4_ID);
		task3.setName("Send \r\n Template");
		result.addTask(task3);
		process.addTask(task3);
		upperParticipantNodes.add(task3);
		
		UPPER_LANE_EL_5_ID = createUniqueId();
		ReceiveTaskBean task4 = new ReceiveTaskBean(UPPER_LANE_EL_5_ID);
		task4.setName("Receive \r\n comments");
		result.addTask(task4);
		process.addTask(task4);
		upperParticipantNodes.add(task4);
		
		UPPER_LANE_EL_6_ID = createUniqueId();
		SendTaskBean task5 = new SendTaskBean(UPPER_LANE_EL_6_ID);
		task5.setName("Send \r\n decision");
		result.addTask(task5);
		process.addTask(task5);
		upperParticipantNodes.add(task5);
		
		UPPER_LANE_EL_7_ID = createUniqueId();
		ExclusiveGatewayBean gateway = new ExclusiveGatewayBean(UPPER_LANE_EL_7_ID);
		process.addGateway(gateway);
		result.addGateway(gateway);

		UPPER_LANE_EL_8_ID = createUniqueId();
		TaskBean task6 = new TaskBean(UPPER_LANE_EL_8_ID);
		task6.setName("Store in \r\n VO's KB");
		process.addTask(task6);
		result.addTask(task6);
		
		UPPER_LANE_EL_9_ID = createUniqueId();
		TaskBean task7 = new TaskBean(UPPER_LANE_EL_9_ID);
		task7.setName("Decide on \r\n rejection");
		process.addTask(task7);
		result.addTask(task7);
		
		UPPER_LANE_EL_10_ID = createUniqueId();
		TaskBean task8 = new TaskBean(UPPER_LANE_EL_10_ID);
		task8.setName("Decide on \r\n rejection");
		result.addTask(task8);
		process.addTask(task8);
		
		UPPER_LANE_EL_11_ID = createUniqueId();
		EndEventBean endEvent = new EndEventBean(UPPER_LANE_EL_11_ID);
//		endEvent.setResults(null);
		result.addEndEvent(endEvent);
		process.addEndEvent(endEvent);
		
		//SEQUENCE FLOWS
		UPPER_LANE_EL_12_ID = createUniqueId();
		SequenceFlowBean sf1 = new SequenceFlowBean(UPPER_LANE_EL_12_ID);
		sf1.setSourceNode(startEvent);
		sf1.setTargetNode(task1);
		process.addSequenceFlow(sf1);
		
		UPPER_LANE_EL_13_ID = createUniqueId();
		SequenceFlowBean sf2 = new SequenceFlowBean(UPPER_LANE_EL_13_ID);
		sf2.setSourceNode(task1);
		sf2.setTargetNode(task2);
		process.addSequenceFlow(sf2);
		
		UPPER_LANE_EL_14_ID = createUniqueId();
		SequenceFlowBean sf3 = new SequenceFlowBean(UPPER_LANE_EL_14_ID);
		sf3.setSourceNode(task2);
		sf3.setTargetNode(task3);
		process.addSequenceFlow(sf3);
		
		UPPER_LANE_EL_15_ID = createUniqueId();
		SequenceFlowBean sf4 = new SequenceFlowBean(UPPER_LANE_EL_15_ID);
		sf4.setSourceNode(task3);
		sf4.setTargetNode(task4);
		process.addSequenceFlow(sf4);
		
		UPPER_LANE_EL_16_ID = createUniqueId();
		SequenceFlowBean sf5 = new SequenceFlowBean(UPPER_LANE_EL_16_ID);
		sf5.setSourceNode(task4);
		sf5.setTargetNode(task5);
		process.addSequenceFlow(sf5);
		
		UPPER_LANE_EL_17_ID = createUniqueId();
		SequenceFlowBean sf6 = new SequenceFlowBean(UPPER_LANE_EL_17_ID);
		sf6.setSourceNode(task5);
		sf6.setTargetNode(gateway);
		process.addSequenceFlow(sf6);
		
		UPPER_LANE_EL_18_ID = createUniqueId();
		SequenceFlowBean sf7 = new SequenceFlowBean(UPPER_LANE_EL_18_ID);
		sf7.setSourceNode(gateway);
		sf7.setTargetNode(task6);
		ExpressionBean expsf7 = new ExpressionBean(createUniqueId());
		expsf7.setContent("Initial idea accepted");
		sf7.setExpression(expsf7);
		process.addSequenceFlow(sf7);
		
		UPPER_LANE_EL_19_ID = createUniqueId();
		SequenceFlowBean sf8 = new SequenceFlowBean(UPPER_LANE_EL_19_ID);
		sf8.setSourceNode(gateway);
		sf8.setTargetNode(task7);
		ExpressionBean expsf8 = new ExpressionBean(createUniqueId());
		expsf8.setContent("Initial idea rejected");
		sf8.setExpression(expsf8);
		process.addSequenceFlow(sf8);
		
		UPPER_LANE_EL_20_ID = createUniqueId();
		SequenceFlowBean sf9 = new SequenceFlowBean(UPPER_LANE_EL_20_ID);
		sf9.setSourceNode(task6);
		sf9.setTargetNode(endEvent);
		process.addSequenceFlow(sf9);
		
		UPPER_LANE_EL_21_ID = createUniqueId();
		SequenceFlowBean sf10 = new SequenceFlowBean(UPPER_LANE_EL_21_ID);
		sf10.setSourceNode(task7);
		sf10.setTargetNode(task8);
		process.addSequenceFlow(sf10);
		
		UPPER_LANE_EL_22_ID = createUniqueId();
		SequenceFlowBean sf11 = new SequenceFlowBean(UPPER_LANE_EL_22_ID);
		sf11.setSourceNode(task8);
		sf11.setTargetNode(endEvent);
		process.addSequenceFlow(sf11);
		
		return result;
	}

	private static ParticipantBean buildlowerParticipant(DefinitionsBean globalResult) {
		
		LOWER_Participant_ID = createUniqueId();
		
		ParticipantBean result = new ParticipantBean(LOWER_Participant_ID);
		result.setName("VO memberS");
		
		PartnerRoleBean pr = new PartnerRoleBean(createUniqueId());
		pr.setName(result.getName());
		pr.addParticipant(result);
		globalResult.addPartnerRole(pr);
		
		ProcessBean process = new ProcessBean(createUniqueId());
		process.setName(process.getId());
		process.setType(ProcessTypes.PUBLIC);
		globalResult.addProcess(process);
		result.setProcess(process);
		LaneSetBean laneSet = new LaneSetBean(createUniqueId());
		process.addLaneSet(laneSet);
		laneSet.addLane(buildLowerLane(process,globalResult));
		return result;
	}
	
	private static LaneBean buildLowerLane(ProcessBean process, DefinitionsBean globalResult) {
		
		LOWER_LANE_ID = createUniqueId();
		
		LaneBean result = new LaneBean(LOWER_LANE_ID);
		result.setName("VO Member (idea creator)");
		
		//NODES
		LOWER_LANE_EL_1_ID = createUniqueId();
		StartEventBean seb = new StartEventBean(LOWER_LANE_EL_1_ID);
		seb.setName("Receive template");
		EventDefinitionBean ed = new MessageEventDefinitionBean(LOWER_LANE_EL_1_ID+"eventDefinition");
		((MessageEventDefinitionBean)ed).setMessage(new MessageBean(IdGenerator.createUniqueId()));
		seb.addTrigger(ed);
		globalResult.addEventDefinition(ed);
		result.addStartEvent(seb);
		process.addStartEvent(seb);
		lowerParticipantNodes.add(seb);
		
		LOWER_LANE_EL_2_ID = createUniqueId();
		ReceiveTaskBean task1 = new ReceiveTaskBean(LOWER_LANE_EL_2_ID);
		task1.setName("Receive");
		result.addTask(task1);
		process.addTask(task1);
		
		LOWER_LANE_EL_3_ID = createUniqueId();
		SendTaskBean task2 = new SendTaskBean(LOWER_LANE_EL_3_ID);
		task2.setName("Send \r\n Components");
		result.addTask(task2);
		process.addTask(task2);
		lowerParticipantNodes.add(task2);
		
		LOWER_LANE_EL_4_ID = createUniqueId();
		ReceiveTaskBean task3 = new ReceiveTaskBean(LOWER_LANE_EL_4_ID);
		task3.setName("Receive \r\n Decision");
		result.addTask(task3);
		process.addTask(task3);
		lowerParticipantNodes.add(task3);
		
		LOWER_LANE_EL_5_ID = createUniqueId();
		ExclusiveGatewayBean gateway = new ExclusiveGatewayBean(LOWER_LANE_EL_5_ID);
		process.addGateway(gateway);
		result.addGateway(gateway);
		
		LOWER_LANE_EL_6_ID = createUniqueId();
		TaskBean task4 = new TaskBean(LOWER_LANE_EL_6_ID);
		task4.setName("Final idea \r\n notification");
		process.addTask(task4);
		result.addTask(task4);
		
		LOWER_LANE_EL_7_ID = createUniqueId();
		TaskBean task5 = new TaskBean(LOWER_LANE_EL_7_ID);
		task5.setName("Receive reaction \r\n on rejection");
		process.addTask(task5);
		result.addTask(task5);
		
		LOWER_LANE_EL_8_ID = createUniqueId();
		TaskBean task6 = new TaskBean(LOWER_LANE_EL_8_ID);
		task6.setName("Project plan \r\n notification");
		process.addTask(task6);
		result.addTask(task6);
		
		LOWER_LANE_EL_9_ID = createUniqueId();
		EndEventBean endEvent = new EndEventBean(LOWER_LANE_EL_9_ID);
		process.addEndEvent(endEvent);
		result.addEndEvent(endEvent);
		
		//SEQUENCE FLOWS
		LOWER_LANE_EL_10_ID = createUniqueId();
		SequenceFlowBean sf0 = new SequenceFlowBean(LOWER_LANE_EL_10_ID);
		sf0.setSourceNode(seb);
		sf0.setTargetNode(task1);
		process.addSequenceFlow(sf0);
		
		LOWER_LANE_EL_11_ID = createUniqueId();
		SequenceFlowBean sf1 = new SequenceFlowBean(LOWER_LANE_EL_11_ID);
		sf1.setSourceNode(task1);
		sf1.setTargetNode(task2);
		process.addSequenceFlow(sf1);
		
		LOWER_LANE_EL_12_ID = createUniqueId();
		SequenceFlowBean sf2 = new SequenceFlowBean(LOWER_LANE_EL_12_ID);
		sf2.setSourceNode(task2);
		sf2.setTargetNode(task3);
		process.addSequenceFlow(sf2);
		
		LOWER_LANE_EL_13_ID = createUniqueId();
		SequenceFlowBean sf3 = new SequenceFlowBean(LOWER_LANE_EL_13_ID);
		sf3.setSourceNode(task3);
		sf3.setTargetNode(gateway);
		process.addSequenceFlow(sf3);
		
		LOWER_LANE_EL_14_ID = createUniqueId();
		SequenceFlowBean sf4 = new SequenceFlowBean(LOWER_LANE_EL_14_ID);
		sf4.setSourceNode(gateway);
		sf4.setTargetNode(task4);
		ExpressionBean expsf4 = new ExpressionBean(createUniqueId());
		expsf4.setContent("Initial idea accepted");
		sf4.setExpression(expsf4);
		process.addSequenceFlow(sf4);
		
		LOWER_LANE_EL_15_ID = createUniqueId();
		SequenceFlowBean sf5 = new SequenceFlowBean(LOWER_LANE_EL_15_ID);
		sf5.setSourceNode(gateway);
		sf5.setTargetNode(task5);
		sf5.setName("Comments");
		ExpressionBean expsf5 = new ExpressionBean(createUniqueId());
		expsf5.setContent("Initial idea rejected");
		sf5.setExpression(expsf5);
		process.addSequenceFlow(sf5);
		
		LOWER_LANE_EL_16_ID = createUniqueId();
		SequenceFlowBean sf6 = new SequenceFlowBean(LOWER_LANE_EL_16_ID);
		sf6.setSourceNode(task4);
		sf6.setTargetNode(task6);
		process.addSequenceFlow(sf6);
		
		LOWER_LANE_EL_17_ID = createUniqueId();
		SequenceFlowBean sf7 = new SequenceFlowBean(LOWER_LANE_EL_17_ID);
		sf7.setSourceNode(task5);
		sf7.setTargetNode(endEvent);
		sf7.setName("Decision");
		process.addSequenceFlow(sf7);
		
		LOWER_LANE_EL_18_ID = createUniqueId();
		SequenceFlowBean sf8 = new SequenceFlowBean(LOWER_LANE_EL_18_ID);
		sf8.setSourceNode(task6);
		sf8.setTargetNode(endEvent);
		sf8.setName("Template");
		process.addSequenceFlow(sf8);
		
		return result;
	}

	private static List<IMessageFlowBean> buildMessageFlows() {
		List<IMessageFlowBean> result = new ArrayList<IMessageFlowBean>();
		
		MessageFlowBean messageFlow1 = new MessageFlowBean(createUniqueId());
		MF_1_ID = messageFlow1.getId();
		messageFlow1.setSource((IInteractionNodeBean) upperParticipantNodes.get(0));
		messageFlow1.setTarget((IInteractionNodeBean) lowerParticipantNodes.get(0));
		
		MessageFlowBean messageFlow2 = new MessageFlowBean(createUniqueId());
		MF_2_ID = messageFlow2.getId();
		messageFlow2.setSource((IInteractionNodeBean) lowerParticipantNodes.get(1));
		messageFlow2.setTarget((IInteractionNodeBean) upperParticipantNodes.get(1));
		
		MessageFlowBean messageFlow3 = new MessageFlowBean(createUniqueId());
		MF_3_ID = messageFlow3.getId();
		messageFlow3.setSource((IInteractionNodeBean) upperParticipantNodes.get(2));
		messageFlow3.setTarget((IInteractionNodeBean) lowerParticipantNodes.get(2));
		
		result.add(messageFlow1);
		result.add(messageFlow2);
		result.add(messageFlow3);
		
		return result;
	}
	
	private static String createUniqueId(){
		return IdGenerator.createUniqueId();
	}
}
