/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.choreography;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.ISubChoreographyBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IEndEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IIntermediateCatchEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IIntermediateThrowEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.IGatewayBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;

public class ChoreographyBean extends CollaborationBean implements IChoreographyBean{

    private List<ISequenceFlowBean> sequenceFlows;
    private List<IStartEventBean> startEvents;
    private List<IIntermediateCatchEventBean> intermediateCatchEvents;
    private List<IIntermediateThrowEventBean> intermediateThrowEvents;
    private List<IEndEventBean> endEvents;
    private List<IGatewayBean> gateways;
    private List<IChoreographyTaskBean> choreographyTasks;
    private List<ISubChoreographyBean> subChoreographies;
    
    
    protected ChoreographyBean(){
        super();
        sequenceFlows = new ArrayList<ISequenceFlowBean>();
        startEvents = new ArrayList<IStartEventBean>();
        endEvents = new ArrayList<IEndEventBean>();
        gateways = new ArrayList<IGatewayBean>();
        intermediateCatchEvents = new ArrayList<IIntermediateCatchEventBean>();
        intermediateThrowEvents = new ArrayList<IIntermediateThrowEventBean>();
        choreographyTasks = new ArrayList<IChoreographyTaskBean>();
        subChoreographies = new ArrayList<ISubChoreographyBean>();
    }
    
    public ChoreographyBean(String id){
        super(id);
        sequenceFlows = new ArrayList<ISequenceFlowBean>();
        startEvents = new ArrayList<IStartEventBean>();
        endEvents = new ArrayList<IEndEventBean>();
        gateways = new ArrayList<IGatewayBean>();
        intermediateCatchEvents = new ArrayList<IIntermediateCatchEventBean>();
        intermediateThrowEvents = new ArrayList<IIntermediateThrowEventBean>();
        choreographyTasks = new ArrayList<IChoreographyTaskBean>();
        subChoreographies = new ArrayList<ISubChoreographyBean>();
    }
    
    
    public void addSubChoreography(ISubChoreographyBean s){
        subChoreographies.add(s);
    }
    
    public void removeSubChoreography(ISubChoreographyBean s){
        subChoreographies.remove(s);
    }
    
    public void addChoreographyTask(IChoreographyTaskBean t){
        choreographyTasks.add(t);
    }
    
    public void removeChoreographyTask(IChoreographyTaskBean t){
        choreographyTasks.remove(t);
    }
    
    public void addSequenceFlow(ISequenceFlowBean s){
        sequenceFlows.add(s);
    }
    
    public void removeSequenceFlow(ISequenceFlowBean sf){
        sequenceFlows.remove(sf);
    }
    
    public void addStartEvent(IStartEventBean s){
        startEvents.add(s);
    }
    
    public void addEndEvent(IEndEventBean e){
        endEvents.add(e);
    }
    
    public void addGateway(IGatewayBean g){
        gateways.add(g);
    }
    
    public void addIntermediateCatchEvent(IIntermediateCatchEventBean e){
        intermediateCatchEvents.add(e);
    }
    
    public void addIntermediateThrowEvent(IIntermediateThrowEventBean e){
        intermediateThrowEvents.add(e);
    }
    
    public void removeStartEvent(IStartEventBean s){
        startEvents.remove(s);
    }

    public void removeEndEvent(IEndEventBean e){
        endEvents.remove(e);
    }

    public void removeGateway(IGatewayBean g){
        gateways.remove(g);
    }

    public void removeIntermediateCatchEvent(IIntermediateCatchEventBean e){
        intermediateCatchEvents.remove(e);
    }

    public void removeIntermediateThrowEvent(IIntermediateThrowEventBean e){
        intermediateThrowEvents.remove(e);
    }

    public IGatewayBean getGatewayById(String id){
        return searchListById(gateways,id);
    }
    
    public IStartEventBean getStartEventById(String id){
        return searchListById(startEvents,id);
    }
    
    public IEndEventBean getEndEventById(String id){
        return searchListById(endEvents,id);
    }
    
    public IIntermediateCatchEventBean getIntermediateCatchEventById(String id){
        return searchListById(intermediateCatchEvents,id);
    }
    
    public IIntermediateThrowEventBean getIntermediateThrowEventById(String id){
        return searchListById(intermediateThrowEvents, id);
    }
    
    private <T extends IFlowElementBean> T searchListById(List<T> l, String id){
        for(T t : l){
            if(t.getId().equals(id)){
                return t;
            }
        }
        return null;
    }
    ////////////////////////////////////////////
    /////                                  /////
    /////       GETTERS AND SETTERS        /////
    /////                                  /////
    ////////////////////////////////////////////
    public List<ISequenceFlowBean> getSequenceFlows() {
        return sequenceFlows;
    }
    public void setSequenceFlows(List<ISequenceFlowBean> sequenceFlows) {
        this.sequenceFlows = sequenceFlows;
    }
    public List<IStartEventBean> getStartEvents() {
        return startEvents;
    }
    public void setStartEvents(List<IStartEventBean> startEvents) {
        this.startEvents = startEvents;
    }
    public List<IIntermediateCatchEventBean> getIntermediateCatchEvents() {
        return intermediateCatchEvents;
    }
    public void setIntermediateCatchEvents(List<IIntermediateCatchEventBean> intermediateCatchEvents) {
        this.intermediateCatchEvents = intermediateCatchEvents;
    }
    public List<IIntermediateThrowEventBean> getIntermediateThrowEvents() {
        return intermediateThrowEvents;
    }
    public void setIntermediateThrowEvents(List<IIntermediateThrowEventBean> intermediateThrowEvents) {
        this.intermediateThrowEvents = intermediateThrowEvents;
    }
    public List<IEndEventBean> getEndEvents() {
        return endEvents;
    }
    public void setEndEvents(List<IEndEventBean> endEvents) {
        this.endEvents = endEvents;
    }
    public List<IGatewayBean> getGateways() {
        return gateways;
    }
    public void setGateways(List<IGatewayBean> gateways) {
        this.gateways = gateways;
    }
    public List<IChoreographyTaskBean> getChoreographyTasks() {
        return choreographyTasks;
    }
    public void setChoreographyTasks(List<IChoreographyTaskBean> choreographyTasks) {
        this.choreographyTasks = choreographyTasks;
    }
    public List<ISubChoreographyBean> getSubChoreographies() {
        return subChoreographies;
    }
    public void setSubChoreographies(List<ISubChoreographyBean> subChoreographies) {
        this.subChoreographies = subChoreographies;
    }
    
}
