/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.activity.IActivityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataInputAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataOutputAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IIOSpecificationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.FlowNodeBean;


public abstract class ActivityBean extends FlowNodeBean implements IActivityBean {

	private List<IDataInputAssociationBean> dataInputAssociations;
	private List<IDataOutputAssociationBean> dataOutputAssociations;
	private ISequenceFlowBean defaultSequenceFlow;
	private IIOSpecificationBean ioSpecification;
	
	public ActivityBean(String id){
		super(id);
		dataInputAssociations = new ArrayList<IDataInputAssociationBean>();
        dataOutputAssociations = new ArrayList<IDataOutputAssociationBean>();
	}
	
	protected ActivityBean(){
		super();
		dataInputAssociations = new ArrayList<IDataInputAssociationBean>();
		dataOutputAssociations = new ArrayList<IDataOutputAssociationBean>();
	}
	
	
	public void setDefaultSequenceFlow(ISequenceFlowBean defaultSequenceFlow) {
		this.defaultSequenceFlow = defaultSequenceFlow;
	}
	
	public ISequenceFlowBean getDefaultSequenceFlow() {
		return defaultSequenceFlow;
	}
	
	public void addDataInputAssociation(IDataInputAssociationBean dia){
		if(dataInputAssociations==null){
			dataInputAssociations = new ArrayList<IDataInputAssociationBean>();
		}
		dataInputAssociations.add(dia);
	}
	
	public void addDataOutputAssociation(IDataOutputAssociationBean doa){
		if(dataOutputAssociations==null){
			dataOutputAssociations = new ArrayList<IDataOutputAssociationBean>();
		}
		dataOutputAssociations.add(doa);
	}
	
	public void removeDataOutputAssociation(IDataOutputAssociationBean doa){
		if(dataOutputAssociations!=null){
			dataOutputAssociations.remove(doa);
		}
	}
	
	public void removeDataInputAssociation(IDataInputAssociationBean dia){
		if(dataInputAssociations!=null){
			dataInputAssociations.remove(dia);
		}
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public List<IDataInputAssociationBean> getDataInputAssociations() {
		return dataInputAssociations;
	}
	public void setDataInputAssociations(
			List<IDataInputAssociationBean> dataInputAssociations) {
		this.dataInputAssociations = dataInputAssociations;
	}
	public List<IDataOutputAssociationBean> getDataOutputAssociations() {
		return dataOutputAssociations;
	}
	public void setDataOutputAssociations(
			List<IDataOutputAssociationBean> dataOutputAssociations) {
		this.dataOutputAssociations = dataOutputAssociations;
	}
	public IIOSpecificationBean getIoSpecification() {
		return ioSpecification;
	}
	public void setIoSpecification(IIOSpecificationBean ioSpecification) {
		this.ioSpecification = ioSpecification;
	}
}
