/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IIntermediateCatchEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.event.definition.IntermediateCatchEventDefinitionBean;

public class IntermediateCatchEventBean extends CatchEventBean implements
        IIntermediateCatchEventBean {

    public IntermediateCatchEventBean(String id) {
        super(id);
    }

    protected IntermediateCatchEventBean() {
        super();
    }

    @Override
    public void addTrigger(IEventDefinitionBean edt) {
        if (edt instanceof IntermediateCatchEventDefinitionBean) {
            super.addTrigger(edt);
        } else {
            throw new IllegalArgumentException(
                    "Intermediate catch events cannot have such event definitions : "
                            + edt.getClass());
        }
    }
}
