/**
 * domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.service;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;


public class InterfaceBean extends BaseElementBean implements IInterfaceBean {
	
	private String name;
	private List<IOperationBean> operations;
	private String implementationRef;

	public InterfaceBean(String id){
		super(id);
		operations = new ArrayList<IOperationBean>();
	}
	
	protected InterfaceBean(){
		super();
		operations = new ArrayList<IOperationBean>();
	}
	
	public void addOperation(IOperationBean op){
		if(operations==null){
			operations = new ArrayList<IOperationBean>();
		}
		operations.add(op);
	}
	
	public void removeOperation(IOperationBean op){
		if(operations!=null){
			operations.remove(op);
		}
	}
	
	public IOperationBean getOperationById(String id) {
		for(IOperationBean op : operations){
			if(op.getId().equals(id)){
				return op;
			}
		}
		return null;
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public List<IOperationBean> getOperations() {
		return operations;
	}
	public void setOperations(List<IOperationBean> operations) {
		this.operations = operations;
	}
	public String getWsdlImplementationRef() {
        return implementationRef;
    }
    public void setWsdlImplementationRef(String implementationRef) {
        this.implementationRef = implementationRef;
    }
    
    @Override
    public String toString() {
    	return this.getId()+":"+this.getName();
    }
    
}
