/**
 * nfr-domain - API of Domain Objects for NFR - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.business.domain.nfr.to;

import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IMeasureDirectionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.nfr.to.api.IReadingScheduleBean;


/**
 * @author Sarah Zribi - Petals Link
 */

public class MeasureDirectionBean implements IMeasureDirectionBean {


	private static final long serialVersionUID = -8889221024121049539L;
	private IReadingScheduleBean readingSchedule;
	private String readingDuration;
	private long readingNumber;
	private String samplingMethod;
	private String communicationMethod;

	public MeasureDirectionBean(){
		super();
	}
	@Override
	public IReadingScheduleBean getReadingSchedule() {
		return readingSchedule;
	}

	@Override
	public void setReadingSchedule(IReadingScheduleBean readingschedule) {
		this.readingSchedule = readingschedule;
	}

	@Override
	public String getReadingDuration() {
		return readingDuration;
	}

	@Override
	public void setReadingDuration(String readingduration) {
		this.readingDuration = readingduration;
	}

	@Override
	public long getReadingNumber() {
		return readingNumber;
	}

	@Override
	public void setReadingNumber(long readingnumber) {
		this.readingNumber = readingnumber;

	}

	@Override
	public String getSamplingMethod() {
		return samplingMethod;
	}

	@Override
	public void setSamplingMethod(String samplingmethod) {
		this.samplingMethod= samplingmethod;
	}

	@Override
	public String getCommunicationMethod() {
		return communicationMethod;
	}

	@Override
	public void setCommunicationMethod(String communicationmethod) {
		this.communicationMethod=communicationmethod;
	}

}
