/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Association;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BaseElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Choreography;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ChoreographyTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataObjectReference;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataOutput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Lane;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.LaneSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ServiceTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.StartEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.TextAnnotation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TAssociationDirection;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.Constants;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.ICollaborationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration.ILaneBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.ICallableElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.artifact.IAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.artifact.ITextAnnotationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.IProcessBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.activity.ICallActivityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IAssignmentBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataAssociationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataInputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataObjectBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IDataOutputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IIOSpecificationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.event.definition.IMessageEventDefinitionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.service.IOperationBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.BPMN20ImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.WSDLImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.XSDImportBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ServiceTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.DataObjectBean;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.clientToServer.ClientToServer;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.ServerToClient;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.UnsupportedBPMNElementException;
import java.net.URL;
import junit.framework.Assert;
import org.junit.Test;

public class XMLToClientTest {
    @Test
    public void testOMG() {
        XmlContext context = new XmlContextFactory().newContext();
        String[] files = new String[]{"CallActivity.bpmn", "CorrelationExampleSeller.bpmn", "EmailVoting2.bpmn", "HardwareRetailerv2.bpmn", "IncidentManagement-collchor.bpmn", "IncidentManagement(ProcessEngineExecutable).bpmn", "IncidentManagement(WholeCollab).bpmn", "NobelPrizeProcess.bpmn", "OrderProcessforPizzaV4.bpmn", "ProcurementProcesseswithErrorHandling.bpmn", "TavelBooking.bpmn"};
        int cpt = 0;
        for (String file : files) {
            try {
                URL url = Thread.currentThread().getContextClassLoader().getResource("omg/" + file);
                Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
                context.createValidator().failFastValidate((XmlObject)defs);
                DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
                Assert.assertEquals((int)defs.getCollaborations().length, (int)defsBean.getCollaborations().size());
                Assert.assertEquals((int)defs.getImports().length, (int)defsBean.getImports().size());
                Assert.assertEquals((int)defs.getInterfaces().length, (int)defsBean.getInterfaces().size());
                Assert.assertEquals((int)defs.getItemDefinitions().length, (int)defsBean.getItemDefinitions().size());
                Assert.assertEquals((int)defs.getMessages().length, (int)defsBean.getMessages().size());
                Assert.assertEquals((int)defs.getProcesses().length, (int)defsBean.getProcesses().size());
                Assert.assertEquals((int)defs.getChoreographies().length, (int)defsBean.getChoreographies().size());
                Definitions d = ClientToServer.adapt((DefinitionsBean)defsBean);
                Assert.assertEquals((int)defs.getCollaborations().length, (int)d.getCollaborations().length);
                Assert.assertEquals((int)defs.getImports().length, (int)d.getImports().length);
                Assert.assertEquals((int)defs.getInterfaces().length, (int)d.getInterfaces().length);
                Assert.assertEquals((int)defs.getItemDefinitions().length, (int)d.getItemDefinitions().length);
                Assert.assertEquals((int)defs.getMessages().length, (int)d.getMessages().length);
                Assert.assertEquals((int)defs.getProcesses().length, (int)d.getProcesses().length);
                Assert.assertEquals((int)defs.getChoreographies().length, (int)d.getChoreographies().length);
                ++cpt;
                System.out.println(file + " successed.");
            }
            catch (UnsupportedBPMNElementException e) {
                System.out.println(file + " was skipped.\t" + e.getMessage());
            }
            catch (Exception t) {
                System.out.println(file + " failed. ");
                t.printStackTrace();
                Assert.fail();
            }
        }
        System.out.println(cpt + "/" + files.length + " files transformation succeeded.");
    }

    @Test
    public void testBPMNImport() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("CallingDefinitions.xml");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        String nsURI = "http://easybpmn.ebmwebsourcing.com/imported";
        String nsPrefix = "imported";
        Assert.assertNotNull((Object)defsBean);
        Assert.assertNotNull((Object)defsBean.getImports());
        Assert.assertEquals((int)defs.getImports().length, (int)defsBean.getImports().size());
        Assert.assertEquals((int)1, (int)defsBean.getImports().size());
        IImportBean impt = (IImportBean)defsBean.getImports().get(0);
        Assert.assertEquals((String)nsURI, (String)impt.getNamespace());
        Assert.assertTrue((boolean)(impt instanceof BPMN20ImportBean));
        Assert.assertNotNull((Object)((BPMN20ImportBean)impt).getBPMN20Definitions());
        INamespaceDeclaration nsd = impt.getNSDeclaration();
        Assert.assertEquals((String)nsURI, (String)nsd.getURI());
        Assert.assertEquals((String)nsPrefix, (String)nsd.getPrefix());
        Assert.assertNotNull((Object)defsBean.getProcesses());
        Assert.assertEquals((int)1, (int)defsBean.getProcesses().size());
        IProcessBean proc = (IProcessBean)defsBean.getProcesses().get(0);
        Assert.assertNotNull((Object)proc);
        Assert.assertNull((Object)proc.getNSDeclaration());
        Assert.assertEquals((String)"process1ID", (String)proc.getId());
        Assert.assertEquals((String)"process1Name", (String)proc.getName());
        Assert.assertNotNull((Object)proc.getFlowNodes());
        Assert.assertEquals((int)1, (int)proc.getFlowNodes().size());
        IFlowElementBean ca = (IFlowElementBean)proc.getFlowNodes().get(0);
        Assert.assertEquals((String)"callActiId", (String)ca.getId());
        Assert.assertTrue((boolean)(ca instanceof ICallActivityBean));
        ICallableElementBean ceb = ((ICallActivityBean)ca).getCalledElement();
        Assert.assertNotNull((Object)ceb);
        Assert.assertEquals((String)"process2ID", (String)ceb.getId());
        Assert.assertNotNull((Object)ceb.getNSDeclaration());
        INamespaceDeclaration nsd2 = ceb.getNSDeclaration();
        Assert.assertEquals((String)nsURI, (String)nsd2.getURI());
        Assert.assertEquals((String)nsPrefix, (String)nsd2.getPrefix());
    }

    @Test
    public void testXSDImport() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("Definitions.xml");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)defsBean);
        Assert.assertNotNull((Object)defsBean.getImports());
        Assert.assertEquals((int)defs.getImports().length, (int)defsBean.getImports().size());
        Assert.assertEquals((int)2, (int)defsBean.getImports().size());
        IImportBean i = (IImportBean)defsBean.getImports().get(0);
        if (!(i instanceof XSDImportBean)) {
            i = (IImportBean)defsBean.getImports().get(1);
        }
        XSDImportBean si = (XSDImportBean)i;
        Assert.assertEquals((int)2, (int)si.getSchema().getElements().size());
        Assert.assertEquals((int)0, (int)si.getSchema().getImports().size());
        ClientToServer.adapt((DefinitionsBean)defsBean);
    }

    @Test
    public void testLane() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("Definitions.xml");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        int flowNodeCount = 3;
        int flowEltCount = 5;
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)defsBean.getCollaborations());
        Assert.assertEquals((int)1, (int)defsBean.getCollaborations().size());
        ICollaborationBean coll = (ICollaborationBean)defsBean.getCollaborations().get(0);
        Assert.assertEquals((int)1, (int)defsBean.getProcesses().size());
        IProcessBean p = (IProcessBean)defsBean.getProcesses().get(0);
        Assert.assertEquals((Object)coll, (Object)p.getDefinitionalCollaboration());
        Assert.assertEquals((int)flowNodeCount, (int)p.getFlowNodes().size());
        Assert.assertNotNull((Object)p.getLanes());
        Assert.assertEquals((int)1, (int)p.getLanes().size());
        ILaneBean l = (ILaneBean)p.getLanes().get(0);
        Assert.assertEquals((int)flowNodeCount, (int)l.getFlowNodes().size());
        defs = ClientToServer.adapt((DefinitionsBean)defsBean);
        Assert.assertNotNull((Object)defs.getCollaborations());
        Assert.assertEquals((int)1, (int)defs.getCollaborations().length);
        coll = defs.getCollaborations()[0];
        Assert.assertEquals((int)1, (int)defs.getProcesses().length);
        p = defs.getProcesses()[0];
        Assert.assertTrue((boolean)p.hasDefinitionalCollaborationRef());
        Assert.assertEquals((String)coll.getId(), (String)p.getDefinitionalCollaborationRef().getLocalPart());
        Assert.assertEquals((int)flowNodeCount, (int)p.getFlowNode().length);
        Assert.assertEquals((int)flowEltCount, (int)p.getFlowElement().length);
        Assert.assertNotNull((Object)p.getLaneSets());
        Assert.assertEquals((int)1, (int)p.getLaneSets().length);
        LaneSet ls = p.getLaneSets()[0];
        Assert.assertTrue((boolean)ls.hasLane());
        Assert.assertEquals((int)1, (int)ls.getLanes().length);
        Lane l2 = ls.getLanes()[0];
        Assert.assertEquals((int)flowNodeCount, (int)l2.getFlowNodeRef().length);
    }

    @Test
    public void testWSDLImport() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("EmptyDefinitions.xml");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)defsBean);
        Assert.assertNotNull((Object)defsBean.getImports());
        Assert.assertEquals((int)defs.getImports().length, (int)defsBean.getImports().size());
        Assert.assertEquals((int)1, (int)defsBean.getImports().size());
        IImportBean i = (IImportBean)defsBean.getImports().get(0);
        Assert.assertTrue((boolean)(i instanceof WSDLImportBean));
        WSDLImportBean wi = (WSDLImportBean)i;
        String[] itfNames = new String[]{"DB", "FlightBook"};
        String[] opNames = new String[]{"bookFlight", "DBQuerying"};
        String[] msgNames = new String[]{"bookFlightResponse", "bookFlightRequest", "DBQueryCall", "DBQueryResponse"};
        Assert.assertNotNull((Object)wi.getInterfaces());
        Assert.assertEquals((int)2, (int)wi.getInterfaces().size());
        for (String itfName : itfNames) {
            IInterfaceBean itf = wi.getInterfaceByName(itfName);
            Assert.assertNotNull((Object)itf);
            Assert.assertEquals((String)itfName, (String)itf.getName());
        }
        Assert.assertNotNull((Object)wi.getOperations());
        Assert.assertEquals((int)2, (int)wi.getOperations().size());
        for (String opName : opNames) {
            IOperationBean op = wi.getOperationByName(opName);
            Assert.assertNotNull((Object)op);
            Assert.assertEquals((String)opName, (String)op.getName());
        }
        Assert.assertNotNull((Object)wi.getMessages());
        Assert.assertEquals((int)4, (int)wi.getMessages().size());
        for (String msgName : msgNames) {
            IMessageBean msg = wi.getMessageByName(msgName);
            Assert.assertNotNull((Object)msg);
            Assert.assertEquals((String)msgName, (String)msg.getName());
        }
        ClientToServer.adapt((DefinitionsBean)defsBean);
    }

    @Test
    public void testDataDefinitions() throws XmlObjectReadException, XmlObjectValidationException, BPMNException, XmlObjectWriteException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("DataDefinitions.xml");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        String participantId = "flightBookerId";
        String interfaceId = "itfId";
        String taskId = "servicetaskId";
        String dataInputId = "servicetaskId_input";
        String di_itemRef = "DBResponsePart_ItemDef";
        String dataOutputId = "servicetaskId_output";
        String do_itemRef = "DBQueryPart_ItemDef";
        String DOId = "DO1";
        String DO1_itemRef = "DO1_ItemDef";
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        ParticipantBean participant = (ParticipantBean)DefinitionsHelper.getInstance().getElementById(defsBean, participantId);
        Assert.assertNotNull((Object)participant.getInterfaces());
        Assert.assertEquals((int)1, (int)participant.getInterfaces().size());
        Assert.assertEquals((String)interfaceId, (String)((IInterfaceBean)participant.getInterfaces().get(0)).getId());
        ServiceTaskBean st = (ServiceTaskBean)DefinitionsHelper.getInstance().getElementById(defsBean, taskId);
        Assert.assertNotNull((Object)st.getDataInputAssociations());
        Assert.assertEquals((int)1, (int)st.getDataInputAssociations().size());
        IDataAssociationBean dia = (IDataAssociationBean)st.getDataInputAssociations().get(0);
        Assert.assertNotNull((Object)dia.getTarget());
        Assert.assertTrue((boolean)(dia.getTarget() instanceof IDataObjectBean));
        Assert.assertNotNull((Object)dia.getSources());
        Assert.assertEquals((int)1, (int)dia.getSources().size());
        Assert.assertTrue((boolean)(dia.getSources().get(0) instanceof IDataInputBean));
        Assert.assertNotNull((Object)dia.getAssignements());
        Assert.assertEquals((int)1, (int)dia.getAssignements().size());
        IAssignmentBean diaAssigment = (IAssignmentBean)dia.getAssignements().get(0);
        Assert.assertNotNull((Object)diaAssigment.getFrom());
        Assert.assertNotNull((Object)diaAssigment.getTo());
        Assert.assertNotNull((Object)st.getDataOutputAssociations());
        Assert.assertEquals((int)1, (int)st.getDataOutputAssociations().size());
        IDataAssociationBean doa = (IDataAssociationBean)st.getDataOutputAssociations().get(0);
        Assert.assertNotNull((Object)doa.getTarget());
        Assert.assertTrue((boolean)(doa.getTarget() instanceof IDataOutputBean));
        Assert.assertNotNull((Object)doa.getSources());
        Assert.assertEquals((int)1, (int)doa.getSources().size());
        Assert.assertTrue((boolean)(doa.getSources().get(0) instanceof IDataObjectBean));
        Assert.assertNotNull((Object)doa.getAssignements());
        Assert.assertEquals((int)1, (int)doa.getAssignements().size());
        IAssignmentBean doaAssigment = (IAssignmentBean)doa.getAssignements().get(0);
        Assert.assertNotNull((Object)doaAssigment.getFrom());
        Assert.assertNotNull((Object)doaAssigment.getTo());
        Assert.assertNotNull((Object)st.getIoSpecification());
        IIOSpecificationBean iospec = st.getIoSpecification();
        Assert.assertNotNull((Object)iospec.getDataInputs());
        Assert.assertEquals((int)1, (int)iospec.getDataInputs().size());
        Assert.assertEquals((String)dataInputId, (String)((IDataInputBean)iospec.getDataInputs().get(0)).getId());
        Assert.assertEquals((String)di_itemRef, (String)((IDataInputBean)iospec.getDataInputs().get(0)).getItemSubject().getId());
        Assert.assertNotNull((Object)iospec.getDataOutputs());
        Assert.assertEquals((int)1, (int)iospec.getDataOutputs().size());
        Assert.assertEquals((String)dataOutputId, (String)((IDataOutputBean)iospec.getDataOutputs().get(0)).getId());
        Assert.assertEquals((String)do_itemRef, (String)((IDataOutputBean)iospec.getDataOutputs().get(0)).getItemSubject().getId());
        DataObjectBean do_ = (DataObjectBean)DefinitionsHelper.getInstance().getElementById(defsBean, DOId);
        Assert.assertNotNull((Object)do_);
        Assert.assertEquals((String)DO1_itemRef, (String)do_.getItemSubject().getId());
        Assert.assertFalse((boolean)do_.isCollection());
        defs = ClientToServer.adapt((DefinitionsBean)defsBean);
        participant = (Participant)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)participantId, Participant.class);
        Assert.assertNotNull((Object)participant.getInterfaceRef());
        Assert.assertEquals((int)1, (int)participant.getInterfaceRef().length);
        Assert.assertEquals((String)interfaceId, (String)participant.getInterfaceRef()[0].getLocalPart());
        st = (ServiceTask)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)taskId, ServiceTask.class);
        Assert.assertNotNull((Object)st.getDataInputAssociation());
        Assert.assertEquals((int)1, (int)st.getDataInputAssociation().length);
        dia = st.getDataInputAssociation()[0];
        Assert.assertNotNull((Object)dia.getTargetRef());
        Assert.assertTrue((boolean)(dia.getTargetRef() instanceof DataObject));
        Assert.assertNotNull((Object)dia.getSourceRef());
        Assert.assertEquals((int)1, (int)dia.getSourceRef().length);
        Assert.assertTrue((boolean)(dia.getSourceRef()[0] instanceof DataInput));
        Assert.assertNotNull((Object)dia.getAssignment());
        Assert.assertEquals((int)1, (int)dia.getAssignment().length);
        diaAssigment = dia.getAssignment()[0];
        Assert.assertNotNull((Object)diaAssigment.getFrom());
        Assert.assertNotNull((Object)diaAssigment.getTo());
        Assert.assertNotNull((Object)st.getDataOutputAssociation());
        Assert.assertEquals((int)1, (int)st.getDataOutputAssociation().length);
        doa = st.getDataOutputAssociation()[0];
        Assert.assertNotNull((Object)doa.getTargetRef());
        Assert.assertTrue((boolean)(doa.getTargetRef() instanceof DataOutput));
        Assert.assertNotNull((Object)doa.getSourceRef());
        Assert.assertEquals((int)1, (int)doa.getSourceRef().length);
        Assert.assertTrue((boolean)(doa.getSourceRef()[0] instanceof DataObject));
        Assert.assertNotNull((Object)doa.getAssignment());
        Assert.assertEquals((int)1, (int)doa.getAssignment().length);
        doaAssigment = doa.getAssignment()[0];
        Assert.assertNotNull((Object)doaAssigment.getFrom());
        Assert.assertNotNull((Object)doaAssigment.getTo());
        Assert.assertNotNull((Object)st.getIoSpecification());
        iospec = st.getIoSpecification();
        Assert.assertNotNull((Object)iospec.getDataInput());
        Assert.assertEquals((int)1, (int)iospec.getDataInput().length);
        Assert.assertEquals((String)dataInputId, (String)iospec.getDataInput()[0].getId());
        Assert.assertEquals((String)"", (String)iospec.getDataInput()[0].getItemSubjectRef().getNamespaceURI());
        Assert.assertEquals((String)di_itemRef, (String)iospec.getDataInput()[0].getItemSubjectRef().getLocalPart());
        Assert.assertNotNull((Object)iospec.getDataOutput());
        Assert.assertEquals((int)1, (int)iospec.getDataOutput().length);
        Assert.assertEquals((String)dataOutputId, (String)iospec.getDataOutput()[0].getId());
        Assert.assertEquals((String)"", (String)iospec.getDataOutput()[0].getItemSubjectRef().getNamespaceURI());
        Assert.assertEquals((String)do_itemRef, (String)iospec.getDataOutput()[0].getItemSubjectRef().getLocalPart());
        do_ = (DataObject)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)DOId, DataObject.class);
        Assert.assertNotNull((Object)do_);
        Assert.assertEquals((String)"", (String)do_.getItemSubjectRef().getNamespaceURI());
        Assert.assertEquals((String)DO1_itemRef, (String)do_.getItemSubjectRef().getLocalPart());
        Assert.assertFalse((boolean)do_.isIsCollection());
    }

    @Test
    public void testChoreography() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("singleChoreographyTask.bpmn");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        int chorCount = 1;
        int participantCount = 3;
        int chorTaskCount = 1;
        int messageFlowCount = 1;
        Assert.assertNotNull((Object)defs.getChoreographies());
        Assert.assertEquals((int)chorCount, (int)defs.getChoreographies().length);
        Choreography chor = defs.getChoreographies()[0];
        Assert.assertTrue((boolean)chor.hasParticipant());
        Assert.assertEquals((int)participantCount, (int)chor.getParticipant().length);
        Assert.assertTrue((boolean)chor.hasFlowElement());
        Assert.assertEquals((int)chorTaskCount, (int)chor.getFlowElementsByClass(ChoreographyTask.class).size());
        for (ChoreographyTask ct : chor.getFlowElementsByClass(ChoreographyTask.class)) {
            Assert.assertTrue((boolean)ct.hasParticipantRef());
            Assert.assertEquals((int)participantCount, (int)ct.getParticipantRef().length);
            Assert.assertTrue((boolean)ct.hasInitiatingParticipantRef());
        }
        Assert.assertTrue((boolean)chor.hasMessageFlow());
        Assert.assertEquals((int)messageFlowCount, (int)chor.getMessageFlow().length);
        for (MessageFlow mf : chor.getMessageFlow()) {
            Assert.assertTrue((boolean)mf.hasSourceRef());
            Assert.assertTrue((boolean)mf.hasTargetRef());
        }
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)defsBean.getChoreographies());
        Assert.assertEquals((int)chorCount, (int)defsBean.getChoreographies().size());
        IChoreographyBean chor2 = (IChoreographyBean)defsBean.getChoreographies().get(0);
        Assert.assertTrue((chor2.getParticipants() != null ? 1 : 0) != 0);
        Assert.assertEquals((int)participantCount, (int)chor2.getParticipants().size());
        Assert.assertTrue((chor2.getFlowNodes() != null ? 1 : 0) != 0);
        Assert.assertEquals((int)chorTaskCount, (int)chor2.getFlowNodes().size());
        for (IFlowElementBean fe : chor2.getFlowNodes()) {
            if (!(fe instanceof IChoreographyTaskBean)) continue;
            IChoreographyTaskBean ct = (IChoreographyTaskBean)fe;
            Assert.assertNotNull((Object)ct.getParticipants());
            Assert.assertEquals((int)participantCount, (int)ct.getParticipants().size());
            Assert.assertNotNull((Object)ct.getInitiatingParticipant());
        }
        Assert.assertTrue((chor2.getMessageFlows() != null ? 1 : 0) != 0);
        Assert.assertEquals((int)messageFlowCount, (int)chor2.getMessageFlows().size());
        for (IMessageFlowBean mf : chor2.getMessageFlows()) {
            Assert.assertNotNull((Object)mf.getSource());
            Assert.assertNotNull((Object)mf.getTarget());
        }
        defs = ClientToServer.adapt((DefinitionsBean)defsBean);
        Assert.assertNotNull((Object)defs.getChoreographies());
        Assert.assertEquals((int)chorCount, (int)defs.getChoreographies().length);
        chor2 = defs.getChoreographies()[0];
        Assert.assertTrue((boolean)chor2.hasParticipant());
        Assert.assertEquals((int)participantCount, (int)chor2.getParticipant().length);
        Assert.assertTrue((boolean)chor2.hasFlowElement());
        Assert.assertEquals((int)chorTaskCount, (int)chor2.getFlowElementsByClass(ChoreographyTask.class).size());
        for (ChoreographyTask ct : chor2.getFlowElementsByClass(ChoreographyTask.class)) {
            Assert.assertTrue((boolean)ct.hasParticipantRef());
            Assert.assertEquals((int)participantCount, (int)ct.getParticipantRef().length);
            Assert.assertTrue((boolean)ct.hasInitiatingParticipantRef());
        }
        Assert.assertTrue((boolean)chor2.hasMessageFlow());
        Assert.assertEquals((int)messageFlowCount, (int)chor2.getMessageFlow().length);
        for (MessageFlow mf : chor2.getMessageFlow()) {
            Assert.assertTrue((boolean)mf.hasSourceRef());
            Assert.assertTrue((boolean)mf.hasTargetRef());
        }
    }

    @Test
    public void testDataObjectRefDefinitions() throws XmlObjectReadException, XmlObjectValidationException, BPMNException, XmlObjectWriteException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("DataObjectRefDefinitions.bpmn");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        String dataAssociationId = "_6";
        String dataObjectId = "DO_1";
        DataAssociation da = (DataAssociation)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)dataAssociationId, DataAssociation.class);
        Assert.assertNotNull((Object)da);
        Assert.assertNotNull((Object)da.getTargetRef());
        Assert.assertTrue((boolean)(da.getTargetRef() instanceof DataObjectReference));
        DataObjectReference dor = (DataObjectReference)da.getTargetRef();
        Assert.assertNotNull((Object)dor.getDataObjectRef());
        Assert.assertEquals((String)dataObjectId, (String)dor.getDataObjectRef().getId());
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        IDataAssociationBean da2 = (IDataAssociationBean)DefinitionsHelper.getInstance().getElementById(defsBean, dataAssociationId);
        Assert.assertNotNull((Object)da2);
        Assert.assertNotNull((Object)da2.getTarget());
        Assert.assertTrue((boolean)(da2.getTarget() instanceof IDataObjectBean));
        Assert.assertEquals((String)dataObjectId, (String)da2.getTarget().getId());
        defs = ClientToServer.adapt((DefinitionsBean)defsBean);
        da2 = (DataAssociation)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)dataAssociationId, DataAssociation.class);
        Assert.assertNotNull((Object)da2);
        Assert.assertNotNull((Object)da2.getTargetRef());
        Assert.assertTrue((boolean)(da2.getTargetRef() instanceof DataObject));
        Assert.assertEquals((String)dataObjectId, (String)((BaseElement)da2.getTargetRef()).getId());
    }

    @Test
    public void testArtifactProcessDefinitions() throws XmlObjectReadException, XmlObjectValidationException, BPMNException, XmlObjectWriteException {
        this.testArtifacts("ArtifactProcessDefinitions.xml");
    }

    @Test
    public void testArtifactChorDefinitions() throws XmlObjectReadException, XmlObjectValidationException, BPMNException, XmlObjectWriteException {
        this.testArtifacts("ArtifactChoreographyDefinitions.xml");
    }

    @Test
    public void testArtifactCollDefinitions() throws XmlObjectReadException, XmlObjectValidationException, BPMNException, XmlObjectWriteException {
        this.testArtifacts("ArtifactCollaborationDefinitions.xml");
    }

    private void testArtifacts(String fileName) throws BPMNException, XmlObjectReadException, XmlObjectValidationException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("artifacts/" + fileName);
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        String sourceId = "sourceId";
        String annotationId = "annotationId";
        String textFormat = "textContent";
        String textContent = "textContent";
        String associationId = "associationId";
        TextAnnotation ta = (TextAnnotation)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)annotationId, TextAnnotation.class);
        Assert.assertNotNull((Object)ta);
        Assert.assertEquals((String)textFormat, (String)ta.getTextFormat());
        Assert.assertTrue((boolean)ta.hasText());
        Assert.assertEquals((String)textContent, (String)ta.getText().getText()[0].getXmlObjectTextContent());
        Association a = (Association)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)associationId, Association.class);
        Assert.assertNotNull((Object)a);
        Assert.assertTrue((boolean)a.hasSourceRef());
        Assert.assertEquals((String)sourceId, (String)a.getSourceRef().getLocalPart());
        Assert.assertTrue((boolean)a.hasTargetRef());
        Assert.assertEquals((String)annotationId, (String)a.getTargetRef().getLocalPart());
        Assert.assertTrue((boolean)a.hasAssociationDirection());
        Assert.assertEquals((Object)TAssociationDirection.One, (Object)a.getAssociationDirection());
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        ITextAnnotationBean ta2 = (ITextAnnotationBean)DefinitionsHelper.getInstance().getElementById(defsBean, annotationId);
        Assert.assertNotNull((Object)ta2);
        Assert.assertEquals((String)textFormat, (String)ta2.getTextFormat());
        Assert.assertEquals((String)textContent, (String)ta2.getText());
        IAssociationBean a2 = (IAssociationBean)DefinitionsHelper.getInstance().getElementById(defsBean, associationId);
        Assert.assertNotNull((Object)a2);
        Assert.assertNotNull((Object)a2.getSource());
        Assert.assertEquals((String)sourceId, (String)a2.getSource().getId());
        Assert.assertNotNull((Object)a2.getTarget());
        Assert.assertEquals((String)annotationId, (String)a2.getTarget().getId());
        Assert.assertNotNull((Object)a2.getDirection());
        Assert.assertEquals((Object)Constants.AssociationDirection.One, (Object)a2.getDirection());
        defs = ClientToServer.adapt((DefinitionsBean)defsBean);
        ta2 = (TextAnnotation)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)annotationId, TextAnnotation.class);
        Assert.assertNotNull((Object)ta2);
        Assert.assertEquals((String)textFormat, (String)ta2.getTextFormat());
        Assert.assertTrue((boolean)ta2.hasText());
        Assert.assertEquals((String)textContent, (String)ta2.getText().getText()[0].getXmlObjectTextContent());
        a2 = (Association)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)associationId, Association.class);
        Assert.assertNotNull((Object)a2);
        Assert.assertTrue((boolean)a2.hasSourceRef());
        Assert.assertEquals((String)sourceId, (String)a2.getSourceRef().getLocalPart());
        Assert.assertTrue((boolean)a2.hasTargetRef());
        Assert.assertEquals((String)annotationId, (String)a2.getTargetRef().getLocalPart());
        Assert.assertTrue((boolean)a2.hasAssociationDirection());
        Assert.assertEquals((Object)TAssociationDirection.One, (Object)a2.getAssociationDirection());
    }

    @Test
    public void testEventDefinitionsRef() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("EventDefinitionRefDefinitions.xml");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        String medID = "medID";
        String startEventID = "seID";
        String msgID = "bookFlightRequestID";
        String opID = "bookFlightID";
        Assert.assertNotNull((Object)defs.getEventDefinitions());
        Assert.assertEquals((int)1, (int)defs.getEventDefinitions().length);
        EventDefinition ed = defs.getEventDefinitions()[0];
        Assert.assertTrue((boolean)(ed instanceof MessageEventDefinition));
        MessageEventDefinition med = (MessageEventDefinition)ed;
        Assert.assertEquals((String)medID, (String)med.getId());
        Assert.assertEquals((String)msgID, (String)med.getMessageRef().getLocalPart());
        Assert.assertEquals((String)opID, (String)med.getOperationRef().getLocalPart());
        StartEvent se = (StartEvent)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)startEventID, StartEvent.class);
        Assert.assertFalse((boolean)se.hasEventDefinition());
        Assert.assertTrue((boolean)se.hasEventDefinitionRef());
        Assert.assertEquals((int)1, (int)se.getEventDefinitionRef().length);
        Assert.assertEquals((Object)ed, (Object)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)medID, EventDefinition.class));
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        Assert.assertNotNull((Object)defsBean.getEventDefinitions());
        Assert.assertEquals((int)1, (int)defsBean.getEventDefinitions().size());
        IEventDefinitionBean ed2 = (IEventDefinitionBean)defsBean.getEventDefinitions().get(0);
        Assert.assertTrue((boolean)(ed2 instanceof IMessageEventDefinitionBean));
        IMessageEventDefinitionBean med2 = (IMessageEventDefinitionBean)ed2;
        Assert.assertEquals((String)medID, (String)med2.getId());
        Assert.assertEquals((String)msgID, (String)med2.getMessage().getId());
        Assert.assertEquals((String)opID, (String)med2.getOperation().getId());
        IStartEventBean se2 = (IStartEventBean)DefinitionsHelper.getInstance().getElementById(defsBean, startEventID);
        Assert.assertNotNull((Object)se2.getTriggers());
        Assert.assertEquals((int)1, (int)se2.getTriggers().size());
        Assert.assertEquals((Object)ed2, (Object)DefinitionsHelper.getInstance().getElementById(defsBean, medID));
        defs = ClientToServer.adapt((DefinitionsBean)defsBean);
        Assert.assertNotNull((Object)defs.getEventDefinitions());
        Assert.assertEquals((int)1, (int)defs.getEventDefinitions().length);
        ed2 = defs.getEventDefinitions()[0];
        Assert.assertTrue((boolean)(ed2 instanceof MessageEventDefinition));
        med2 = (MessageEventDefinition)ed2;
        Assert.assertEquals((String)medID, (String)med2.getId());
        Assert.assertEquals((String)msgID, (String)med2.getMessageRef().getLocalPart());
        Assert.assertEquals((String)opID, (String)med2.getOperationRef().getLocalPart());
        se2 = (StartEvent)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)startEventID, StartEvent.class);
        Assert.assertFalse((boolean)se2.hasEventDefinition());
        Assert.assertTrue((boolean)se2.hasEventDefinitionRef());
        Assert.assertEquals((int)1, (int)se2.getEventDefinitionRef().length);
        Assert.assertEquals((Object)ed2, (Object)com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper.findObjectInDefinitions((Definitions)defs, (String)medID, EventDefinition.class));
    }
}

