/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.server.service.bpmndi.serverToClient;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNDiagram;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNPlane;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNPlane;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNShape;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.ServerToClient;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.UnsupportedBPMNElementException;
import com.ebmwebsourcing.petalsbpm.server.service.bpmndi.clientToServer.BPMNDiagramGenerator;
import com.ebmwebsourcing.petalsbpm.server.service.bpmndi.serverToClient.BPMNDiagramParser;
import com.ebmwebsourcing.petalsbpm.server.service.bpmndi.serverToClient.UnsupportedBPMNDiagramException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.Assert;
import org.junit.Test;

public class XMLToClientTest {
    @Test
    public void testChoreographyDiagram() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("singleChoreographyTask.bpmn");
        Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        int totalShapeCount = 4;
        int totalEdgeCount = 0;
        int participantShapeCount = 3;
        Assert.assertTrue((boolean)defs.hasBPMNDiagram());
        Assert.assertEquals((int)1, (int)defs.getBPMNDiagram().length);
        BPMNDiagram diagram = defs.getBPMNDiagram()[0];
        BPMNPlane plane = diagram.getBPMNPlane();
        Assert.assertTrue((boolean)plane.hasDiagramElement());
        Assert.assertEquals((int)totalShapeCount, (int)plane.getBPMNShapes().length);
        Assert.assertEquals((int)totalEdgeCount, (int)plane.getBPMNEdges().length);
        DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
        IBPMNDiagram diagramBean = BPMNDiagramParser.parseBPMNDiagram((BPMNDiagram)diagram, (DefinitionsBean)defsBean);
        IBPMNPlane plane2 = diagramBean.getRootElement();
        Assert.assertNotNull((Object)plane2.getOwnedElements());
        Assert.assertEquals((int)totalShapeCount, (int)plane2.getOwnedElements().size());
        for (IDiagramElement de : plane2.getOwnedElements()) {
            Assert.assertTrue((boolean)(de instanceof IBPMNShape));
            Assert.assertNotNull((Object)de.getModelElement());
        }
        IBPMNShape shape = (IBPMNShape)plane2.getOwnedElements().iterator().next();
        Assert.assertTrue((boolean)(shape.getModelElement() instanceof IChoreographyTaskBean));
        Assert.assertEquals((int)participantShapeCount, (int)shape.getOwnedElements().size());
        double y = Double.POSITIVE_INFINITY;
        for (IDiagramElement de : shape.getOwnedElements()) {
            Assert.assertEquals((Object)shape, (Object)((IBPMNShape)de).getChoreographyActivityShape());
            Assert.assertTrue((y > ((IBPMNShape)de).getBounds().getY() ? 1 : 0) != 0);
            y = ((IBPMNShape)de).getBounds().getY();
        }
    }

    @Test
    public void testOMG() throws XmlObjectReadException, XmlObjectValidationException, XmlObjectWriteException, URISyntaxException, MalformedURLException, BPMNException {
        String[] files;
        XmlContext context = new XmlContextFactory().newContext();
        for (String file : files = new String[]{"CallActivity.bpmn", "CorrelationExampleSeller.bpmn", "EmailVoting2.bpmn", "HardwareRetailerv2.bpmn", "IncidentManagement-collchor.bpmn", "IncidentManagement(ProcessEngineExecutable).bpmn", "IncidentManagement(WholeCollab).bpmn", "NobelPrizeProcess.bpmn", "OrderProcessforPizzaV4.bpmn", "ProcurementProcesseswithErrorHandling.bpmn", "TavelBooking.bpmn"}) {
            URL url = Thread.currentThread().getContextClassLoader().getResource("omg/" + file);
            Definitions defs = (Definitions)context.createReader().readDocument(url, Definitions.class);
            context.createValidator().failFastValidate((XmlObject)defs);
            if (!defs.hasBPMNDiagram()) continue;
            int count = 0;
            for (BPMNDiagram diagram : defs.getBPMNDiagram()) {
                try {
                    DefinitionsBean defsBean = ServerToClient.adapt((Definitions)defs);
                    IBPMNDiagram diagramBean = BPMNDiagramParser.parseBPMNDiagram((BPMNDiagram)diagram, (DefinitionsBean)defsBean);
                    BPMNDiagramGenerator.generateBPMNDiagram((IBPMNDiagram)diagramBean);
                    System.out.println(file + " diagram number " + count++ + " succeeded.");
                }
                catch (UnsupportedBPMNDiagramException e1) {
                    System.out.println(file + " diagram number " + count++ + " was skipped.\t" + e1.getMessage());
                }
                catch (UnsupportedBPMNElementException e2) {
                    System.out.println(file + " diagram number " + count++ + " was skipped.\t" + e2.getMessage());
                }
            }
        }
    }
}

