/**
 * petalsbpm-service - BPMN Editor service - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient;

import com.ebmwebsourcing.easybpmn.bpmn20.api.element.AdHocSubProcess;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BoundaryEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CallChoreography;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ComplexGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataStoreReference;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ImplicitThrowEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.InclusiveGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Transaction;

/**
 * BPMN 2.0 elements currently not supported by PetalsBPM
 * @author gcrosmarie
 *
 */
public class UnsupportedElements {

	private static final Class<?>[] unsupportedElements = 
		{
			AdHocSubProcess.class,
			BoundaryEvent.class,
			CallChoreography.class,
			ComplexGateway.class,
			DataStoreReference.class, 
			ImplicitThrowEvent.class, 
			InclusiveGateway.class,
			Transaction.class
		};
	
	public static void checkIfSupported(FlowElement fe) {
		for(Class<?> ue : unsupportedElements) {
			if(ue.isAssignableFrom(fe.getClass())) {
				throw new UnsupportedBPMNElementException(fe);
			}
		}
	}
	
}
