/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.soceda.impl;

import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.UpdateListener;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.w3._2001.xmlschema.EJaxbSchema;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import engine.cep.admin.api.SubscriptionsRequired;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.ow2.frascati.esper.api.EsperEngine;
import org.ow2.frascati.soceda.api.CEPControllerInterfaces;
import org.ow2.frascati.soceda.listener.EventListner_and_Publisher;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.data._1.Resource;
import seacloud.petalslink.com.data._1.ResourceType;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

@Scope(value="COMPOSITE")
@EagerInit
@WebService(portName="CEPControllerPort", serviceName="CEPControllerService", targetNamespace="http://com.petalslink.seacloud/service/management/cloud/1.0", wsdlLocation="wsdl/SeaCloud.wsdl", endpointInterface="org.ow2.frascati.soceda.api.CEPControllerInterfaces")
public class CEPController
implements CEPControllerInterfaces,
NotificationConsumerDecorator {
    private DataManagerClientImplSOAP easierGovClient;
    private Integer cpt_notifications = 0;
    private Map<String, Integer> mapEventTypeName = new HashMap<String, Integer>();
    @Reference
    private static EsperEngine CEPEngine;
    private String cepAddress;

    @Init
    public void init() {
        System.out.println("Start initializing the CEP Esper engine...");
        if (CEPEngine != null) {
            this.cepAddress = System.getProperty("org.ow2.frascati.binding.uri.base", "http://localhost:9004/services/dicepe") + "/services/dicepe";
            System.out.println("Initialization of the CEP Esper engine is done...");
        } else {
            System.out.println("The engine is Null...");
        }
    }

    public String ping() {
        return new String("OK");
    }

    public void addEventType(String eventName, ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM) {
        CEPEngine.addEventType(eventName, configurationEventTypeXMLDOM);
    }

    public String addStatement(String statementId, String statement) throws CloudManagementException {
        try {
            CEPEngine.addStatement(statementId, statement);
            return "\nCEPController: Statement added\n";
        }
        catch (Exception e) {
            return "\nCEPController: Statement not added\n";
        }
    }

    public String updateStatement(String statementId, String statement) throws CloudManagementException {
        try {
            CEPEngine.updateStatement(statementId, statement);
            return "\nCEPController: Statement updated\n";
        }
        catch (Exception e) {
            return "\nCEPController: Statement not found\n";
        }
    }

    public String getStatementById(String statementId) throws CloudManagementException {
        return CEPEngine.getStatementById(statementId);
    }

    public String deleteStatement(String statementId) throws CloudManagementException {
        try {
            CEPEngine.deleteStatement(statementId);
            return "\nCEPController: Statement deleted\n";
        }
        catch (Exception e) {
            return "\nCEPController: Statement can not be deleted\n";
        }
    }

    public ListAllStatementsResponse listAllStatements(ListAllStatements parameters) throws CloudManagementException {
        return CEPEngine.listAllStatements(parameters);
    }

    public AddResourcesDescriptorResponse addResourcesDescriptor(AddResourcesDescriptor parameters) throws CloudManagementException {
        System.out.println("**************** Connect Governance to the DiCEPE ****************");
        AddResourcesDescriptorResponse response = new AddResourcesDescriptorResponse();
        try {
            ArrayList<URL> easierGovAdresses = new ArrayList<URL>();
            for (Resource rsc : parameters.getResourcesDescriptor().getResource()) {
                if (!ResourceType.GOVERNANCE.equals((Object)rsc.getType())) continue;
                easierGovAdresses.add(new URL(rsc.getAddress()));
            }
            URL easierGovAdress = null;
            if (easierGovAdresses.size() > 0) {
                easierGovAdress = new URL(((URL)easierGovAdresses.get(0)).toString().replace("eventManager", "dataManager"));
                System.out.println("easierGovAdress = " + easierGovAdress);
                this.easierGovClient = new DataManagerClientImplSOAP(easierGovAdress.toString());
                System.out.println("Governance is now connected to cep");
            }
        }
        catch (MalformedURLException e) {
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public AddStatementResponseWithActions addStatementWithActions(AddStatementWithActions parameters) throws CloudManagementException {
        String EndpointAddressesToSubscribe = null;
        try {
            SubscriptionsRequired subscriptionsRequired = parameters.getSubscriptionsRequired();
            List entries = subscriptionsRequired.getEntry();
            System.out.println("Debug_CEPController: entries: " + entries);
            if (this.easierGovClient != null) {
                for (SubscriptionsRequired.Entry entry : entries) {
                    this.addEventTypeFromXSD(entry);
                    QName topicUsed = entry.getTopic();
                    System.out.println("topicUsed: " + topicUsed);
                    EndpointAddressesToSubscribe = entry.getEndpointAddressToSubscribe();
                    System.out.println("EndpointAddressesToSubscribe ++++++++++++++  " + EndpointAddressesToSubscribe);
                    AdminManagementClientSOAP clientSubscribe = new AdminManagementClientSOAP(EndpointAddressesToSubscribe);
                    Subscribe payload = WSNHelper.createSubscription((String)this.cepAddress, (QName)topicUsed, (QName[])new QName[]{entry.getCorrespondingEvent()});
                    Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
                    if (topicUsed != null) {
                        EJaxbSubscribe not = (EJaxbSubscribe)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbSubscribe.class);
                        doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)not);
                    }
                    System.out.println("DiCEPE SUBSCRIBE on topic: " + topicUsed);
                    System.out.println("DiCEPE SUBSCRIBE :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
                    EJaxbSubscribeResponse response = clientSubscribe.subscribe(doc);
                    System.out.println("DiCEPE SUBSCRIBE ON " + topicUsed + " => OK");
                }
                System.out.println("parameters.getAction().size = " + parameters.getAction().size());
                EventListner_and_Publisher eventListner_and_Publisher = new EventListner_and_Publisher(EndpointAddressesToSubscribe, this.cepAddress, parameters.getAction(), parameters.getNamespaceOfEventTypes(), this.easierGovClient, this.mapEventTypeName);
                CEPEngine.createEPLStatementandAddListener(parameters.getStatement(), (UpdateListener)eventListner_and_Publisher);
            } else {
                System.out.println("Governance is not connected to DiCEPE !!!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
        AddStatementResponseWithActions addStatementResponseWithActions = new AddStatementResponseWithActions();
        addStatementResponseWithActions.setResponse("Subscriptions performed!");
        return addStatementResponseWithActions;
    }

    private void addEventTypeFromXSD(SubscriptionsRequired.Entry entry) throws CloudManagementException {
        try {
            if (entry.getCorrespondingEvent() != null) {
                GetElement request = new GetElement();
                request.setIdElement(entry.getCorrespondingEvent());
                GetElementResponse response = this.easierGovClient.getElement(request);
                String bufferSchema = null;
                if (response.getAny() instanceof EJaxbSchema) {
                    bufferSchema = XMLPrettyPrinter.prettyPrint((Document)SOAJAXBContext.getInstance().unmarshallAnyElement(response.getAny()));
                } else if (response.getAny() instanceof Element) {
                    Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    doc.appendChild(doc.adoptNode((Element)response.getAny()));
                    bufferSchema = XMLPrettyPrinter.prettyPrint((Document)doc);
                }
                String schemaText = XMLPrettyPrinter.prettyPrint((Document)DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(bufferSchema.getBytes())));
                ConfigurationEventTypeXMLDOM eventcfg = new ConfigurationEventTypeXMLDOM();
                eventcfg.setXPathPropertyExpr(true);
                eventcfg.setRootElementName(entry.getCorrespondingEvent().getLocalPart());
                eventcfg.setSchemaText(schemaText);
                this.addEventType(entry.getCorrespondingEvent().getLocalPart(), eventcfg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notify(EJaxbNotify notify) {
        System.out.println("*********************** NEW NOTIFICATION ***********************");
        Integer n = this.cpt_notifications;
        Integer n2 = this.cpt_notifications = Integer.valueOf(this.cpt_notifications + 1);
        n = this.cpt_notifications;
        synchronized (n) {
            try {
                Document event = this.getEventInNotify(notify);
                System.out.println("****** Notify on DiCEPE: \n" + XMLPrettyPrinter.prettyPrint((Document)event));
                String EventTypeName = event.getFirstChild().getNodeName().replace(event.getFirstChild().getPrefix() + ":", "");
                this.addEventTypeNameToMap(EventTypeName);
                CEPEngine.getCEPEPRuntime().sendEvent((Node)event);
                System.out.println("****** Number of notifications received on DiCEPE:" + this.cpt_notifications);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private Document getEventInNotify(EJaxbNotify notify) throws WsnbException {
        Document doc = null;
        try {
            for (EJaxbNotificationMessageHolderType msgh : notify.getNotificationMessage()) {
                Element elmt = (Element)msgh.getMessage().getAny();
                doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.adoptNode(elmt));
            }
        }
        catch (ParserConfigurationException e) {
            throw new WsnbException((Throwable)e);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEventTypeNameToMap(String eventName) {
        Map<String, Integer> map = this.mapEventTypeName;
        synchronized (map) {
            if (!this.containsEventTypeName(eventName)) {
                this.mapEventTypeName.put(eventName, new Integer(1));
            } else {
                this.mapEventTypeName.put(eventName, this.mapEventTypeName.get(eventName) + 1);
            }
        }
    }

    public String getNumberOfEventsByName(String eventName) {
        if (this.containsEventTypeName(eventName)) {
            return Integer.toString(this.mapEventTypeName.get(eventName));
        }
        return "Event Type Name does not exists!";
    }

    private boolean containsEventTypeName(String eventName) {
        return this.mapEventTypeName.containsKey(eventName);
    }
}

