/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.soceda.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.fractal.api.Component;
import org.ow2.frascati.FraSCAti;
import org.ow2.frascati.soceda.api.CEPControllerInterfaces;
import org.ow2.frascati.util.FrascatiException;

public class StartDiCEPE {
    public static final String COMPOSITE = "CEP-server.composite";
    public static FraSCAti frascati;
    public static Component composite;

    public static void main(String[] args) {
        if (args.length == 1) {
            System.setProperty("org.ow2.frascati.binding.uri.base", StartDiCEPE.getURL(args[0]));
            try {
                frascati = FraSCAti.newFraSCAti();
                composite = frascati.getComposite(COMPOSITE);
                CEPControllerInterfaces cep = (CEPControllerInterfaces)frascati.getService(composite, "cepController", CEPControllerInterfaces.class);
                System.out.println("DiCEPE should be up now!");
            }
            catch (FrascatiException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Argument must be the DiCEPE address!");
        }
    }

    private static String getURL(String input) {
        String result = new String();
        Pattern pattern = Pattern.compile("\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[0-9+&@#]");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            result = result + matcher.group();
        }
        System.out.println(result);
        return result;
    }
}

