/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.soceda.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.LogManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.fractal.api.Component;
import org.ow2.frascati.FraSCAti;
import org.ow2.frascati.soceda.api.CEPControllerInterfaces;
import org.ow2.frascati.soceda.launcher.ConfigurationImpl;
import org.ow2.frascati.soceda.launcher.Launcher;
import org.ow2.frascati.soceda.launcher.util.CommandReader;
import org.ow2.frascati.soceda.launcher.util.Locker;
import org.ow2.frascati.soceda.launcher.util.SystemExitHook;

public class DiCEPELauncher
implements Launcher {
    protected static final String START_COMMAND = "start";
    protected static final String SHUTDOWN_COMMAND = "shutdown";
    protected static final String VERSION_COMMAND = "version";
    protected String banner = " -----------------------------------------------------------\n|                                                           |\n|                          DiCEPE                           |\n|                                                           |\n -----------------------------------------------------------\n";
    protected static final String LOGGER_FILE = "logger.properties";
    public static final String COMPOSITE = "CEP-server.composite";
    public static FraSCAti frascati;
    public static Component composite;
    protected SystemExitHook systemExitHook;
    protected final Locker locker = new Locker(new File("."));

    protected void showBanner() {
        System.out.println();
        System.out.println(this.banner);
        System.out.println();
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public void launch(String[] args) {
        this.showBanner();
        ArrayList<String> command = new ArrayList<String>();
        boolean console = true;
        if (args.length == 0) {
            command.add(START_COMMAND);
        }
        for (String arg : args) {
            command.add(arg);
        }
        try {
            if (command.contains(SHUTDOWN_COMMAND)) {
                System.out.println("DiCEPE is stopping...");
                this.shutdown();
            } else if (command.contains(VERSION_COMMAND)) {
                this.version();
            } else if (command.contains(START_COMMAND)) {
                System.out.println("DiCEPE is starting...");
                this.start();
                if (console) {
                    this.commandLineMode(composite);
                }
                if (this.systemExitHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
                }
                this.systemExitHook.run();
                System.exit(0);
            } else {
                System.out.println("Command '" + command + "' is unknown");
                this.printUsage();
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            System.out.println("Command processing error : " + command);
            e.printStackTrace(System.err);
            if (this.systemExitHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
            }
            System.exit(-1);
        }
    }

    public void start() throws Exception {
        if (this.locker.isLocked()) {
            throw new Exception("Can not start the DiCEPE server, remove lock file from EventCloud root path or stop server");
        }
        this.locker.lock();
        ConfigurationImpl conf = new ConfigurationImpl();
        String host = conf.getHost();
        int port = conf.getPort();
        if (host == null || port <= 0) {
            throw new Exception("Wrong host or port parameters!!!");
        }
        System.setProperty("org.ow2.frascati.binding.uri.base", DiCEPELauncher.getURL("http://" + host + ":" + port + "/services/dicepe"));
        frascati = FraSCAti.newFraSCAti();
        composite = frascati.getComposite(COMPOSITE);
        CEPControllerInterfaces dicepe = (CEPControllerInterfaces)frascati.getService(composite, "cepController", CEPControllerInterfaces.class);
        System.out.println("DiCEPE should be up now!");
        System.out.println("**************** Ping ****************");
        System.out.println("Ping's result = " + dicepe.ping());
        System.out.println("DiCEPE started at: http://" + host + ":" + port + "/services/dicepe");
        this.systemExitHook = new SystemExitHook(this.locker);
        Runtime.getRuntime().addShutdownHook(this.systemExitHook);
    }

    private static String getURL(String input) {
        String result = new String();
        Pattern pattern = Pattern.compile("\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[0-9+&@#]");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            result = result + matcher.group();
        }
        System.out.println(result);
        return result;
    }

    public void shutdown() throws Exception {
        if (this.systemExitHook == null) {
            this.systemExitHook = new SystemExitHook(this.locker);
        }
        this.systemExitHook.start();
    }

    public void version() throws Exception {
        System.out.println("No version");
    }

    protected void printUsage() {
        System.out.println("usage:");
        System.out.println(" -start                  start the DiCEPE container");
        System.out.println(" -shutdowm               shutdown the DiCEPE container");
        System.out.println(" -version                get the DiCEPE container version");
    }

    protected void printSpecificStartMessage() {
    }

    protected void commandLineMode(Object node) throws Exception {
        CommandReader console = new CommandReader(node);
        console.read();
    }

    static {
        try {
            FileInputStream inputStream = null;
            File logger = new File(LOGGER_FILE);
            if (logger.exists()) {
                inputStream = new FileInputStream(logger);
            }
            System.out.println("LOGGER : " + logger);
            System.out.println("inputStream" + inputStream);
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                ((InputStream)inputStream).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

