/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.soceda.listener;

import java.util.logging.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class CepAssigner {
    private Logger log = Logger.getLogger(CepAssigner.class.getName());

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public void affect(Object destination, Object source) {
        try {
            if (this.isEII(source) && this.isEII(destination)) {
                this.replaceElement((Element)source, (Element)destination, true);
                this.log.fine("Assignement resultat:  set source (" + ((Element)source).getName() + ") in destination (" + ((Element)destination).getName() + ")).\nNew value of destination:\n" + new XMLOutputter(Format.getPrettyFormat()).outputString((Element)destination));
            } else {
                this.replaceContent(source, destination);
                this.log.fine("Assignement resultat: destination = " + (this.isEII(destination) ? "New value of destination:\n" + new XMLOutputter(Format.getPrettyFormat()).outputString((Element)destination) : destination));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private final void replaceContent(Object source, Object destination) {
        if (this.isEII(destination)) {
            Element destinationEII = (Element)destination;
            destinationEII.removeContent();
            if (source instanceof String) {
                destinationEII.addContent((String)source);
            } else if (source instanceof Text) {
                Text textSource = (Text)source;
                destinationEII.addContent((Content)((Text)textSource.clone()));
            } else if (source instanceof Number) {
                destinationEII.addContent(String.valueOf(source));
            } else assert (false);
        } else if (this.isAII(destination)) {
            String sourceTII = this.asStringTII(source);
            Attribute destinationAII = (Attribute)destination;
            destinationAII.setValue(sourceTII);
        } else if (this.isTII(destination)) {
            String sourceTII = this.asStringTII(source);
            Text destinationTII = (Text)destination;
            destinationTII.setText(sourceTII);
        } else assert (false);
    }

    private String asStringTII(Object source) {
        if (source instanceof String) {
            return (String)source;
        }
        if (source instanceof Content) {
            return ((Content)source).getValue();
        }
        if (source instanceof Number) {
            return String.valueOf(source);
        }
        if (source instanceof Text) {
            return ((Text)source).getTextTrim();
        }
        assert (false);
        return null;
    }

    private final void replaceElement(Element source, Element destination, boolean keepSrcElementName) {
        if (keepSrcElementName) {
            destination.setName(source.getName());
            destination.setNamespace(source.getNamespace());
        }
        destination.removeContent();
        destination.getAttributes().clear();
        for (Content c : source.getContent()) {
            destination.addContent(((Content)c.clone()).detach());
        }
        for (Attribute a : source.getAttributes()) {
            destination.setAttribute(((Attribute)a.clone()).detach());
        }
        for (Namespace ns : source.getAdditionalNamespaces()) {
            if (ns.getPrefix().isEmpty()) continue;
            destination.addNamespaceDeclaration(ns);
        }
    }

    private final boolean isEII(Object obj) {
        return obj instanceof Element;
    }

    private final boolean isAII(Object obj) {
        return obj instanceof Attribute;
    }

    private final boolean isTII(Object obj) {
        return obj instanceof String || obj instanceof Text;
    }
}

