/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.soceda.listener;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluator {
    private static final Logger LOG = Logger.getLogger(ExpressionEvaluator.class.getName());

    public Object evaluateAsNode(Map<String, Element> varContext, String expression, List<Namespace> nss) throws JaxenException {
        LOG.finest("XPATH = " + expression);
        XPath xpath = this.createXPath(varContext, expression, nss);
        Object result = xpath.selectSingleNode(null);
        LOG.finest("XPATH RESULT = " + result);
        return result;
    }

    private final XPath createXPath(Map<String, Element> varContext, String expression, List<Namespace> nss) throws JaxenException {
        SimpleVariableContext variableContext = new SimpleVariableContext();
        JDOMXPath xpath = new JDOMXPath(expression);
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        for (Namespace namespace : nss) {
            namespaceContext.addNamespace(namespace.getPrefix(), namespace.getURI());
        }
        for (Map.Entry entry : varContext.entrySet()) {
            String variableName = (String)entry.getKey();
            assert (variableName != null);
            Element variableValue = (Element)entry.getValue();
            this.declareVariableInVariableContext(variableName, variableValue, variableContext, variableValue.getNamespace().getURI());
        }
        xpath.setNamespaceContext((NamespaceContext)namespaceContext);
        xpath.setVariableContext((VariableContext)variableContext);
        return xpath;
    }

    private void declareVariableInVariableContext(String variableName, Object variableValue, SimpleVariableContext variableContext, String namespace) {
        variableContext.setVariableValue(variableName, variableValue);
        variableContext.setVariableValue(namespace, variableName, variableValue);
    }
}

