/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink;

import com.ebmwebsourcing.easiestdemo.helper.BusManagement;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import fr.mines_albi.nuclearcrisisevent.provider.BusProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.BusProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.CarProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.CarProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.DriverProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.DriverProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.MotoristProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.MotoristProvider_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.VehicleProviderEvent_WSOUIServer;
import fr.mines_albi.nuclearcrisisevent.provider.VehicleProvider_WSOUIServer;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.officeofinfrastructure.OfficeOfInfrastructureEventProducer_WSOUIServer;
import org.petalslink.officeofinfrastructure.OfficeOfInfrastructure_WSOUIServer;
import org.petalslink.seacloud.SeaCloud_WSOUIServer;

public class OperationImplementCirculationPlanProcess_Main {
    public static final URL BPEL_LOCATION = Thread.currentThread().getContextClassLoader().getResource("crisis/management/generated/OperationImplementCirculationPlanProcess.bpel");
    private MotoristProviderEvent_WSOUIServer motoristProviderEvent_WSOUIServer = null;
    private MotoristProvider_WSOUIServer motoristProvider_WSOUIServer = null;
    private DriverProviderEvent_WSOUIServer driverProviderEvent_WSOUIServer = null;
    private DriverProvider_WSOUIServer driverProvider_WSOUIServer = null;
    private BusProviderEvent_WSOUIServer busProviderEvent_WSOUIServer = null;
    private BusProvider_WSOUIServer busProvider_WSOUIServer = null;
    private CarProviderEvent_WSOUIServer carProviderEvent_WSOUIServer = null;
    private CarProvider_WSOUIServer carProvider_WSOUIServer = null;
    private VehicleProviderEvent_WSOUIServer vehicleProviderEvent_WSOUIServer = null;
    private VehicleProvider_WSOUIServer vehicleProvider_WSOUIServer = null;
    private SeaCloud_WSOUIServer seaCloud_WSOUIServer = null;
    private OfficeOfInfrastructureEventProducer_WSOUIServer officeOfInfrastructureEventProducer_WSOUIServer = null;
    private OfficeOfInfrastructure_WSOUIServer officeOfInfrastructure_WSOUIServer = null;
    private com.ebmwebsourcing.easyesb.soa.api.node.Node node = null;
    private QName nodeName = new QName("http://www.petalslink.org/", "OperationImplementCirculationPlanProcess_EasyESBNode");
    private String nodeHost = "localhost";
    private int nodeInternalPort = 8000;
    private int nodeSoapPort = 8085;
    private String adminUrl = "http://" + this.nodeHost + ":" + this.nodeSoapPort + "/services/adminExternalEndpoint";
    private static boolean standalone;

    public static void main(String[] args) throws Exception {
        OperationImplementCirculationPlanProcess_Main main = new OperationImplementCirculationPlanProcess_Main();
        PrintStream err = System.err;
        try {
            boolean activeGUI = true;
            OperationImplementCirculationPlanProcess_Main.analyzeCommand(args);
            main.startAllWebServices();
            main.setGUIOnAllWebServices(false);
            Scanner sc = new Scanner(System.in);
            System.out.println("Hit Enter to exit :");
            sc.nextLine();
            main.createNode();
            List<URL> bpelUrls = main.deployAndExposeBPEL(BPEL_LOCATION);
            if (activeGUI) {
                main.createClient();
            }
        }
        catch (Exception e) {
            e.printStackTrace(err);
            main.stopAllWebServices();
            main.stopNode();
        }
    }

    public static void analyzeCommand(String[] args) {
        if (args != null && args.length == 1 && args[0].equals("standalone")) {
            standalone = true;
        }
    }

    public boolean isStandalone() {
        return standalone;
    }

    public void createNode() throws ESBException {
        this.node = BusManagement.getInstance().createNode(this.nodeName, this.nodeHost, this.nodeInternalPort, this.nodeSoapPort);
    }

    public List<URL> deployAndExposeBPEL(URL bpel) throws Exception {
        List urls = BusManagement.getInstance().deployAndExposeBPEL(bpel, new URL(this.adminUrl));
        System.out.println("BPEL " + bpel + " are exposed at url:");
        for (URL url : urls) {
            System.out.println("\t" + url);
        }
        return urls;
    }

    public void stopNode() throws TransportException {
        this.node.stop();
    }

    public void startAllWebServices() throws WSOUIException {
        if (!this.isStandalone()) {
            this.motoristProviderEvent_WSOUIServer = new MotoristProviderEvent_WSOUIServer();
            this.motoristProviderEvent_WSOUIServer.start();
            this.motoristProvider_WSOUIServer = new MotoristProvider_WSOUIServer();
            this.motoristProvider_WSOUIServer.start();
            this.driverProviderEvent_WSOUIServer = new DriverProviderEvent_WSOUIServer();
            this.driverProviderEvent_WSOUIServer.start();
            this.driverProvider_WSOUIServer = new DriverProvider_WSOUIServer();
            this.driverProvider_WSOUIServer.start();
            this.busProviderEvent_WSOUIServer = new BusProviderEvent_WSOUIServer();
            this.busProviderEvent_WSOUIServer.start();
            this.busProvider_WSOUIServer = new BusProvider_WSOUIServer();
            this.busProvider_WSOUIServer.start();
            this.carProviderEvent_WSOUIServer = new CarProviderEvent_WSOUIServer();
            this.carProviderEvent_WSOUIServer.start();
            this.carProvider_WSOUIServer = new CarProvider_WSOUIServer();
            this.carProvider_WSOUIServer.start();
            this.vehicleProviderEvent_WSOUIServer = new VehicleProviderEvent_WSOUIServer();
            this.vehicleProviderEvent_WSOUIServer.start();
            this.vehicleProvider_WSOUIServer = new VehicleProvider_WSOUIServer();
            this.vehicleProvider_WSOUIServer.start();
            this.seaCloud_WSOUIServer = new SeaCloud_WSOUIServer();
            this.seaCloud_WSOUIServer.start();
            this.officeOfInfrastructureEventProducer_WSOUIServer = new OfficeOfInfrastructureEventProducer_WSOUIServer();
            this.officeOfInfrastructureEventProducer_WSOUIServer.start();
            this.officeOfInfrastructure_WSOUIServer = new OfficeOfInfrastructure_WSOUIServer();
            this.officeOfInfrastructure_WSOUIServer.start();
        }
    }

    public void createClient() throws WSOUIException {
        try {
            WSOUIClient client = new WSOUIClient();
            Node n = client.addNewAdminWsdlofESBNode(new URL[]{new URL(this.adminUrl + "?wsdl")});
            n.setModel(this.node);
            client.setVisible(true);
        }
        catch (MalformedURLException e) {
            throw new WSOUIException((Throwable)e);
        }
        catch (WSOUIClientException e) {
            throw new WSOUIException((Throwable)e);
        }
    }

    public void setGUIOnAllWebServices(boolean activeGUI) throws WSOUIException {
        if (!this.isStandalone()) {
            if (this.motoristProviderEvent_WSOUIServer != null) {
                this.motoristProviderEvent_WSOUIServer.getProviderConfigurationFor_MotoristProviderEvent().setActiveGui(activeGUI);
            }
            if (this.motoristProvider_WSOUIServer != null) {
                this.motoristProvider_WSOUIServer.getProviderConfigurationFor_MotoristProvider().setActiveGui(activeGUI);
            }
            if (this.driverProviderEvent_WSOUIServer != null) {
                this.driverProviderEvent_WSOUIServer.getProviderConfigurationFor_DriverProviderEvent().setActiveGui(activeGUI);
            }
            if (this.driverProvider_WSOUIServer != null) {
                this.driverProvider_WSOUIServer.getProviderConfigurationFor_DriverProvider().setActiveGui(activeGUI);
            }
            if (this.busProviderEvent_WSOUIServer != null) {
                this.busProviderEvent_WSOUIServer.getProviderConfigurationFor_BusProviderEvent().setActiveGui(activeGUI);
            }
            if (this.busProvider_WSOUIServer != null) {
                this.busProvider_WSOUIServer.getProviderConfigurationFor_BusProvider().setActiveGui(activeGUI);
            }
            if (this.carProviderEvent_WSOUIServer != null) {
                this.carProviderEvent_WSOUIServer.getProviderConfigurationFor_CarProviderEvent().setActiveGui(activeGUI);
            }
            if (this.carProvider_WSOUIServer != null) {
                this.carProvider_WSOUIServer.getProviderConfigurationFor_CarProvider().setActiveGui(activeGUI);
            }
            if (this.vehicleProviderEvent_WSOUIServer != null) {
                this.vehicleProviderEvent_WSOUIServer.getProviderConfigurationFor_VehicleProviderEvent().setActiveGui(activeGUI);
            }
            if (this.vehicleProvider_WSOUIServer != null) {
                this.vehicleProvider_WSOUIServer.getProviderConfigurationFor_VehicleProvider().setActiveGui(activeGUI);
            }
            if (this.seaCloud_WSOUIServer != null) {
                this.seaCloud_WSOUIServer.getProviderConfigurationFor_SeaCloud().setActiveGui(activeGUI);
            }
            if (this.officeOfInfrastructureEventProducer_WSOUIServer != null) {
                this.officeOfInfrastructureEventProducer_WSOUIServer.getProviderConfigurationFor_OfficeOfInfrastructureEventProducer().setActiveGui(activeGUI);
            }
            if (this.officeOfInfrastructure_WSOUIServer != null) {
                this.officeOfInfrastructure_WSOUIServer.getProviderConfigurationFor_OfficeOfInfrastructure().setActiveGui(activeGUI);
            }
        }
    }

    public void stopAllWebServices() {
        if (!this.isStandalone()) {
            if (this.motoristProviderEvent_WSOUIServer != null) {
                this.motoristProviderEvent_WSOUIServer.stop();
            }
            if (this.motoristProvider_WSOUIServer != null) {
                this.motoristProvider_WSOUIServer.stop();
            }
            if (this.driverProviderEvent_WSOUIServer != null) {
                this.driverProviderEvent_WSOUIServer.stop();
            }
            if (this.driverProvider_WSOUIServer != null) {
                this.driverProvider_WSOUIServer.stop();
            }
            if (this.busProviderEvent_WSOUIServer != null) {
                this.busProviderEvent_WSOUIServer.stop();
            }
            if (this.busProvider_WSOUIServer != null) {
                this.busProvider_WSOUIServer.stop();
            }
            if (this.carProviderEvent_WSOUIServer != null) {
                this.carProviderEvent_WSOUIServer.stop();
            }
            if (this.carProvider_WSOUIServer != null) {
                this.carProvider_WSOUIServer.stop();
            }
            if (this.vehicleProviderEvent_WSOUIServer != null) {
                this.vehicleProviderEvent_WSOUIServer.stop();
            }
            if (this.vehicleProvider_WSOUIServer != null) {
                this.vehicleProvider_WSOUIServer.stop();
            }
            if (this.seaCloud_WSOUIServer != null) {
                this.seaCloud_WSOUIServer.stop();
            }
            if (this.officeOfInfrastructureEventProducer_WSOUIServer != null) {
                this.officeOfInfrastructureEventProducer_WSOUIServer.stop();
            }
            if (this.officeOfInfrastructure_WSOUIServer != null) {
                this.officeOfInfrastructure_WSOUIServer.stop();
            }
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("logger/easiestdemo-logging.properties");
            System.out.println("configFile = " + configFile);
            LogManager.getLogManager().readConfiguration(configFile);
            configFile.close();
        }
        catch (Exception ex) {
            try {
                InputStream configFile = new File("./src/main/resources/logger/easiestdemo-logging.properties").toURI().toURL().openStream();
                System.out.println("configFile = " + configFile);
                LogManager.getLogManager().readConfiguration(configFile);
                configFile.close();
            }
            catch (Exception ex1) {
                System.out.println("WARNING: Could not open configuration file");
                System.out.println("WARNING: Logging not configured (console output only)");
            }
        }
        standalone = false;
    }
}

