// SOCEDA integration
// ---------
// -- DSB --
// ---------

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var c2cComponentKey = "c2c";
var c2cConfigFilename = "c2c.config.properties";

function runC2C() {
	// Perform several checks and run the installation if required

	println("Checking Click2Call WS installation ... ");

	// Check if already installed
	var c2cDir = new File(instDir, c2cComponentKey);
	if (!c2cDir.exists() || c2cDir.listFiles().length == 0) {
		println("Click2Call WS not found, trying to install ...");
		c2cDir.mkdir();

		// Check if the installer is in origin
		var c2cInstallerFile = new File(originDir, findInstallerNameOfComponent(c2cComponentKey));
		if (!c2cInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(c2cComponentKey);
			println("Trying to download the Click2Call WS installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, c2cInstallerFile);
			} catch (e) {
				println("Unable to download the Click2Call WS installer due to " + e.javaException);
			}
			if (!c2cInstallerFile.exists()) {
				throw "Unable to find " + c2cInstallerFile + " please download "
				+ c2cInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();	
			}						
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(c2cInstallerFile, c2cDir);
		} catch (e) {
			println("Unable to extract Click2Call WS binaries " + e.javaStackTrace);
		}
		
		if (c2cDir.listFiles().length == 0) {
			throw "Unable to extract Click2Call WS please extract " + sccliInstallerFile + " manually into " + c2cDir;
		}
		
		println("Installation successfull ...");
	}

	var binDir = new File(c2cDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, c2cConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	deleteLockedFile(binDir);
	
	// Running c2c from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server.jar', 'start');
	return execCmdNewTermAsync("Click2Call WS", cmd, binDir);
}