/*
 * Decompiled with CFR 0.152.
 */
package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.inEvent;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;

public class UnexpectedEvent
extends inEvent {
    protected String status;
    protected String unexpectedMessage;
    protected String userType;
    protected String phoneNumber;

    public UnexpectedEvent() {
    }

    public UnexpectedEvent(String timeStamp, String uniqueId, String sequenceNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
    }

    public UnexpectedEvent(String timeStamp, String uniqueId, String sequenceNumber, String status, String unexpectedMessage, String userType, String phoneNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
        this.status = status;
        this.unexpectedMessage = unexpectedMessage;
        this.userType = userType;
        this.phoneNumber = phoneNumber;
    }

    public String toStringCEP1() {
        return "stream=UnexpectedEvent,uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber + ",status=" + this.status + ",timeStamp=" + this.timeStamp + ",unexpectedMessage=" + this.unexpectedMessage + ",userType=" + this.userType + ",phoneNumber=" + this.phoneNumber;
    }

    public String toRDF(String AppID) {
        String str1;
        String pattern05 = AppID;
        String pattern07 = "TaxiUCUnexpected";
        String pattern09 = "http://streams.event-processing.org/ids/TaxiUCUnexpected#stream";
        String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
        String Footer = "</mt:nativeMessage>\n";
        String avaTemplate = str1 = "@prefix :        <http://events.event-processing.org/types/> .\n@prefix e:       <http://events.event-processing.org/ids/> .\n@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\ne:#3# {\ne:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\nuctelco:uniqueId \"#6#\" ;\nuctelco:status \"#10#\" ;\nuctelco:unexpectedMessage \"#11#\" ;\nuctelco:userType \"#12#\" ;\nuctelco:phoneNumber \"#13#\" ;\n# but also some other data according to event format\na :#7# ;\n:endTime \"#8#\"^^xsd:dateTime ;\n:source <http://sources.event-processing.org/ids/#5##source> ;\n:stream <#9#> . \n}\n";
        int indexSep = this.uniqueId.indexOf(58);
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
        avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
        avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
        avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
        avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ', 'T'));
        avaTemplate = avaTemplate.replaceFirst("#9#", pattern09);
        avaTemplate = avaTemplate.replaceFirst("#10#", this.status);
        avaTemplate = avaTemplate.replaceFirst("#11#", this.unexpectedMessage);
        avaTemplate = avaTemplate.replaceFirst("#12#", this.userType);
        avaTemplate = avaTemplate.replaceFirst("#13#", this.phoneNumber);
        if (AppID == "Android") {
            return StringEscapeUtils.escapeXml((String)avaTemplate);
        }
        return Header + StringEscapeUtils.escapeXml((String)avaTemplate) + Footer;
    }

    public String getUnexpectedMessage() {
        return this.unexpectedMessage;
    }

    public void setUnexpectedMessage(String unexpectedMessage) {
        this.unexpectedMessage = unexpectedMessage;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toStringCEP() {
        return "stream=UnexpectedEvent,status=" + this.status + ",unexpectedMessage=" + this.unexpectedMessage + ",userType=" + this.userType + ",phoneNumber=" + this.phoneNumber + ",timeStamp=" + this.timeStamp + ",uniqueId=" + this.uniqueId + ",sequenceNumber=" + this.sequenceNumber;
    }

    public String toString() {
        return "UnexpectedEvent [uniqueId=" + this.uniqueId + ", sequenceNumber=" + this.sequenceNumber + ", timeStamp=" + this.timeStamp + ", status=" + this.status + ", unexpectedMessage=" + this.unexpectedMessage + ", userType=" + this.userType + ", phoneNumber=" + this.phoneNumber + "]";
    }

    public String toXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <UnexpectedEventEvent xmlns=\"http://www.orange.org/TaxiEventType\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<status>" + this.status + "</status>" + "<unexpectedMessage>" + this.unexpectedMessage + "</unexpectedMessage>" + "<userType>" + this.userType + "</userType>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "</UnexpectedEventEvent>";
    }

    public String toWSN() {
        return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "UnexpectedEventTopic", "evt"), "<OrangeLabsTaxiUC:UnexpectedEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.orangelabs.org/taxiEventTypes\" xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<status>" + this.status + "</status>" + "<unexpectedMessage>" + this.unexpectedMessage + "</unexpectedMessage>" + "<userType>" + this.userType + "</userType>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "</OrangeLabsTaxiUC:UnexpectedEvent>", null, null);
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }
}

