/*
 * Decompiled with CFR 0.152.
 */
package fr.Lille.inria.adam;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import fr.Lille.inria.adam.AllDevices;
import fr.Lille.inria.adam.AllDevicesIDsAndRegIDs;
import fr.Lille.inria.adam.AllRules;
import fr.Lille.inria.adam.Device;
import fr.Lille.inria.adam.Utils.GCM_MessageUtil;
import fr.Lille.inria.adam.Utils.UUID;
import fr.Lille.inria.adam.api.EarthquakeProxyInterfaces;
import fr.Lille.inria.adam.api.EarthquakeProxyPubSubInterfaces;
import fr.Lille.inria.adam.events.EarthquakeEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.xml.parsers.ParserConfigurationException;
import org.oasis_open.docs.wsn.b_2.NotificationMessageHolderType;
import org.oasis_open.docs.wsn.b_2.Notify;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Scope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Scope(value="COMPOSITE")
public class EarthquakeProxyImpl
implements EarthquakeProxyInterfaces,
EarthquakeProxyPubSubInterfaces {
    public List<Device> devices = new LinkedList<Device>();
    public static String registrationID;
    private final String TYPE_MESSAGE = "message";
    private final String TYPE_COMMAND = "command";
    private final String TYPE_ALERT = "alert";
    private final String api_key = "AIzaSyDc7cvxR1eB0Mhq7G9_CJs2GmsVomQGPwE";
    private static final String uuid;
    private final List<Notify> notifications = new ArrayList<Notify>();

    @Init
    public void init() {
    }

    public String sayHello(String deviceId) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " is back!");
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("message", device.getApi_key(), device.getRegistrationId(), "This is the serve, welcome back!");
            return "1";
        }
        System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " is not registred!");
        return "2";
    }

    public void register(String deviceId, String registrationId, String api_key, String status) {
        Device device = new Device(deviceId, registrationId, api_key, status);
        if (this.DeviceExist(device)) {
            System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " is already registred!");
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("message", device.getApi_key(), device.getRegistrationId(), "Your device is already registred!");
        } else {
            this.devices.add(device);
            System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " is registred!");
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("message", device.getApi_key(), device.getRegistrationId(), "Your device is registred!");
        }
    }

    public void unregister(String deviceId) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " is unregistred!");
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("message", device.getApi_key(), device.getRegistrationId(), "Your device is unregistred!");
            this.devices.remove(device);
        } else {
            System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " is already unregistred!");
        }
    }

    private boolean DeviceExist(Device device) {
        if (!this.devices.isEmpty()) {
            for (Device d : this.devices) {
                if (!d.getDeviceId().equals(device.getDeviceId())) continue;
                return true;
            }
        }
        return false;
    }

    public Device getDevice(String deviceId) {
        for (Device d : this.devices) {
            if (!d.getDeviceId().equals(deviceId)) continue;
            return d;
        }
        System.out.println("EarthquakeProxyImpl : getDevice ERROR!! Device not found");
        return null;
    }

    public void removeDevice(String deviceId, String registrationId, String api_key) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " is removed!");
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("message", device.getApi_key(), device.getRegistrationId(), "Your device is removed!");
            this.devices.remove(device);
        } else {
            System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " Device doesn't exist on server!");
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("message", api_key, registrationId, "Device doesn't exist on server!");
        }
    }

    public String addRule(String deviceId, String rule) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            try {
                rule = URLDecoder.decode(rule, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.println("EarthquakeProxyImpl : adding rule \"" + rule + "\" to the cep engine within the device = " + deviceId);
            String ruleId = UUID.uuid(15);
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("command", device.getApi_key(), device.getRegistrationId(), "<addRule><name>" + ruleId + "</name><rule>" + rule + "</rule></addRule>");
            this.getDevice(deviceId).addRule(ruleId, rule);
            return "rule added";
        }
        System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " not found on server!");
        return "Device not found";
    }

    public String addRuleToAllDevices(String rule) {
        ArrayList<String> registrationIds = new ArrayList<String>();
        if (!this.devices.isEmpty()) {
            for (Device device : this.devices) {
                registrationIds.add(device.getRegistrationId());
            }
            try {
                rule = URLDecoder.decode(rule, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.println("EarthquakeProxyImpl : adding rule \"" + rule + "\" to all cep engines");
            String ruleId = UUID.uuid(15);
            GCM_MessageUtil.sendMultipleMessagesToGCM_ThenToDevices("command", "AIzaSyDc7cvxR1eB0Mhq7G9_CJs2GmsVomQGPwE", registrationIds, "<addRule><name>" + ruleId + "</name><rule>" + rule + "</rule></addRule>");
            for (Device device : this.devices) {
                device.addRule(ruleId, rule);
            }
            return "rule added";
        }
        System.out.println("EarthquakeProxyImpl : No device registred on the server!");
        return "Device not found";
    }

    public String deleteRuleV1(String deviceId) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            System.out.println("EarthquakeProxyImpl : deleting rules within the cep engine of the device = " + deviceId);
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("command", device.getApi_key(), device.getRegistrationId(), "<deleteRule><name>" + deviceId + "</name></deleteRule>");
            this.getDevice(deviceId).deleteRule(deviceId);
            return "Rule deleted";
        }
        System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " not found on server!");
        return "Device not found";
    }

    public String deleteRuleOnAllDevices(String rule) {
        ArrayList<String> registrationIds = new ArrayList<String>();
        if (!this.devices.isEmpty()) {
            for (Device device : this.devices) {
                registrationIds.add(device.getRegistrationId());
            }
            try {
                rule = URLDecoder.decode(rule, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            String delims = "[|]";
            String[] tokens = rule.split(delims);
            System.out.println("EarthquakeProxyImpl : deleting rules within the cep engines of the involved devices");
            GCM_MessageUtil.sendMultipleMessagesToGCM_ThenToDevices("command", "AIzaSyDc7cvxR1eB0Mhq7G9_CJs2GmsVomQGPwE", registrationIds, "<deleteRule><name>" + tokens[0] + "</name></deleteRule>");
            for (Device device : this.devices) {
                device.deleteRule(tokens[0]);
            }
            return "rule deleted";
        }
        System.out.println("EarthquakeProxyImpl : No device registred on the server!");
        return "No registred device";
    }

    public String updateRule(String deviceId, String rule) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            try {
                rule = URLDecoder.decode(rule, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.println("EarthquakeProxyImpl : updating rule within the cep engine of the device = " + deviceId);
            System.out.println("EarthquakeProxyImpl : The new rule is = " + rule);
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("command", device.getApi_key(), device.getRegistrationId(), "<updateRule><name>" + deviceId + "</name><rule>" + rule + "</rule></updateRule>");
            this.getDevice(deviceId).deleteRule(deviceId);
            this.getDevice(deviceId).addRule(deviceId, rule);
            return "Rule updated";
        }
        System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " not found on server!");
        return "Device not found";
    }

    public String updateRuleOnAllDevices(String rule) {
        ArrayList<String> registrationIds = new ArrayList<String>();
        if (!this.devices.isEmpty()) {
            for (Device device : this.devices) {
                registrationIds.add(device.getRegistrationId());
            }
            try {
                rule = URLDecoder.decode(rule, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.println("EarthquakeProxyImpl : updating rule \"" + rule + "\" on all cep engines");
            String uuid = UUID.uuid(15);
            GCM_MessageUtil.sendMultipleMessagesToGCM_ThenToDevices("command", "AIzaSyDc7cvxR1eB0Mhq7G9_CJs2GmsVomQGPwE", registrationIds, "<addRule><name>" + uuid + "</name><rule>" + rule + "</rule></addRule>");
            for (Device device : this.devices) {
                device.addRule(uuid, rule);
            }
            return "rule added";
        }
        System.out.println("EarthquakeProxyImpl : No device registred on the server!");
        return "Device not found";
    }

    public String stopEngine(String deviceId) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            System.out.println("EarthquakeProxyImpl : cep engine of the device = " + deviceId + " is stoped!");
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("command", device.getApi_key(), device.getRegistrationId(), "<stopEngine></stopEngine>");
            return "CEP Engine stopped";
        }
        System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " not found on server!");
        return "Device not found";
    }

    public String stopEngines() {
        ArrayList<String> registrationIds = new ArrayList<String>();
        if (!this.devices.isEmpty()) {
            for (Device device : this.devices) {
                registrationIds.add(device.getRegistrationId());
            }
            System.out.println("EarthquakeProxyImpl : cep engine of devices = ");
            for (Device device : this.devices) {
                System.out.println(device.getDeviceId() + "  ");
            }
            System.out.print(" will be stopped!");
            GCM_MessageUtil.sendMultipleMessagesToGCM_ThenToDevices("command", "AIzaSyDc7cvxR1eB0Mhq7G9_CJs2GmsVomQGPwE", registrationIds, "<stopEngine></stopEngine>");
            return "CEP Engines are stopped";
        }
        System.out.println("EarthquakeProxyImpl : No device is available on server!");
        return "No device is available on server!";
    }

    public String startEngine(String deviceId) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            System.out.println("EarthquakeProxyImpl : cep engine of the device = " + deviceId + " is started!");
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("command", device.getApi_key(), device.getRegistrationId(), "<startEngine></startEngine>");
            try {
                Thread.sleep(7000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String[] rules = device.getRules();
            System.out.println("EarthquakeProxyImpl : cep engine of the device = " + deviceId + " has sent this rule: " + rules[0]);
            return rules[0];
        }
        System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " not found on server!");
        return "Device not found";
    }

    public String startEngines() {
        ArrayList<String> registrationIds = new ArrayList<String>();
        if (!this.devices.isEmpty()) {
            for (Device device : this.devices) {
                registrationIds.add(device.getRegistrationId());
            }
            System.out.println("EarthquakeProxyImpl : cep engine of devices = ");
            for (Device device : this.devices) {
                System.out.println(device.getDeviceId() + "  ");
            }
            System.out.print(" are started!");
            GCM_MessageUtil.sendMultipleMessagesToGCM_ThenToDevices("command", "AIzaSyDc7cvxR1eB0Mhq7G9_CJs2GmsVomQGPwE", registrationIds, "<startEngine></startEngine>");
            try {
                Thread.sleep(7000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return "CEP Engines Started";
        }
        System.out.println("EarthquakeProxyImpl : No device is available on server!");
        return "No device is available on server!";
    }

    public String[] getAllIDs() {
        String[] ids = new String[this.devices.size()];
        int i = 0;
        for (Device p : this.devices) {
            ids[i++] = p.getRegistrationId();
        }
        return ids;
    }

    public Response getAlldeviceIDs() {
        AllDevices allDevices = new AllDevices();
        for (Device d : this.devices) {
            allDevices.addDeviceID(d.getDeviceId());
        }
        System.out.println("EarthquakeProxyImpl : Response: all devices = " + Response.ok((Object)allDevices).build().toString());
        return Response.ok((Object)allDevices).build();
    }

    public Response getDevicesIDsAndRegIDs() {
        AllDevicesIDsAndRegIDs allDevices = new AllDevicesIDsAndRegIDs();
        for (Device d : this.devices) {
            allDevices.addDevice(d.getDeviceId(), d.getRegistrationId());
        }
        return Response.ok((Object)allDevices).build();
    }

    public String setDeviceRule(String deviceId, String rule) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            device.setRule(deviceId, rule);
            System.out.println("EarthquakeProxyImpl : Rule within the device Id = " + deviceId + " is saved on the server... ");
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("message", device.getApi_key(), device.getRegistrationId(), "The default rule is saved on the server");
            return "Rule saved";
        }
        System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " not found on server!");
        return "Device not found";
    }

    public Response getDeviceRule(String deviceId) {
        Device device = this.getDevice(deviceId);
        AllRules allRules = new AllRules();
        if (device != null && this.DeviceExist(device)) {
            if (!device.isRulesEmpty().booleanValue()) {
                String[] rules;
                for (String rule : rules = device.getRules()) {
                    allRules.addRule(rule);
                }
                System.out.println("EarthquakeProxyImpl : Rules within the device Id = " + deviceId + " are sent to the CEP Manager... ");
            } else {
                System.out.println("No rule with the device : " + device.getDeviceId());
                allRules.addRule(device.getDeviceId() + "|" + " *** No Rule ***");
            }
            return Response.ok((Object)allRules).build();
        }
        System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " not found on server!");
        return Response.notModified((String)"Device not found").build();
    }

    public Response getAllDeviceRules() {
        AllRules allRules = new AllRules();
        for (Device d : this.devices) {
            if (!d.isRulesEmpty().booleanValue()) {
                String[] rules;
                for (String rule : rules = d.getRules()) {
                    allRules.addRule(rule);
                }
                continue;
            }
            System.out.println("No rule with the device : " + d.getDeviceId());
            allRules.addRule(d.getDeviceId() + "|" + " *** No Rule ***");
        }
        return Response.ok((Object)allRules).build();
    }

    public String sendHelloMessage(String deviceId) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            System.out.println("EarthquakeProxyImpl : Hello message sent to the device = " + deviceId);
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("message", device.getApi_key(), device.getRegistrationId(), "This is the server and this is a Hello message!!!");
            return "Message sent to the device";
        }
        System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " not found on server!");
        return "Device not found";
    }

    public String sendEvent(String deviceId, String Time, String Latitude, String Longitude, String Magnitude) {
        Device device = this.getDevice(deviceId);
        if (device != null && this.DeviceExist(device)) {
            EarthquakeEvent event = new EarthquakeEvent(deviceId, Time, Double.parseDouble(Latitude), Double.parseDouble(Longitude), Float.parseFloat(Magnitude));
            System.out.println("EarthquakeProxyImpl : The server received an event = " + event);
            GCM_MessageUtil.sendMessageToGCM_ThenToDevice("message", device.getApi_key(), device.getRegistrationId(), "This is the server: I received your event!");
            System.out.println("EarthquakeProxyImpl : sending the event to the SeaCloud... ");
            return "Event received!";
        }
        System.out.println("EarthquakeProxyImpl : device with ID = " + deviceId + " not found on server!");
        return "Device not found";
    }

    public String ping(String name) {
        return "Hello " + name;
    }

    public void notify(Notify notify) {
        System.out.println("*********************** NEW NOTIFICATION ***********************");
        this.notifications.add(notify);
        System.out.println("****** Number of notifications received oc DiCEPE:" + this.notifications.size());
        try {
            Document event = this.getEventInNotify(notify);
            System.out.println("****** Notify on Earthquake Proxy: \n" + XMLPrettyPrinter.prettyPrint((Document)event));
            if (!this.devices.isEmpty()) {
                ArrayList<String> registrationIds = new ArrayList<String>();
                for (Device device : this.devices) {
                    registrationIds.add(device.getRegistrationId());
                }
                GCM_MessageUtil.sendMultipleMessagesToGCM_ThenToDevices("alert", "AIzaSyDc7cvxR1eB0Mhq7G9_CJs2GmsVomQGPwE", registrationIds, "ALERT!!! Potential Earthquake");
            } else {
                System.out.println("EarthquakeProxyImpl : No device registred on the server!");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private Document getEventInNotify(Notify notify) throws WsnbException {
        Document doc = null;
        try {
            for (NotificationMessageHolderType msgh : notify.getNotificationMessage()) {
                Element elmt = (Element)msgh.getMessage().getAny();
                doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.adoptNode(elmt));
            }
        }
        catch (ParserConfigurationException e) {
            throw new WsnbException((Throwable)e);
        }
        return doc;
    }

    static {
        uuid = UUID.uuid(15);
    }
}

