/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.soceda.integration.earthquake;

import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.resolver.URIMemoryMultipleResolvers;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.resolver.EasyESBInternalURIResolver;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;
import com.ebmwebsourcing.esstar.essynchronizer.generic.notifier.client.NotifierClientSOAP;
import com.ebmwebsourcing.seacloud.client.SeaCloudClientSOAP;
import com.ebmwebsourcing.seacloud.server.SeaCloud;
import com.ebmwebsourcing.soceda.CreateFramework;
import com.ebmwebsourcing.ws.mock.server.EarthquakeAlertNotifier;
import com.ebmwebsourcing.ws.mock.server.EarthquakeAlertWSServer;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.petalslink.data_api._1.PublishSchemaFromURL;
import com.petalslink.events_api._1.PublishTopicNamespaceFromURL;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.petalslink.abslayer.service.impl.wsdl11.DescriptionImpl;
import org.w3c.dom.Document;
import seacloud.petalslink.com.data._1.ObjectFactory;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;

public class Demo {
    private static Logger log;
    private EarthquakeAlertWSServer earthquakeAlertWSServer = null;

    public void startDemo(boolean activeGUI, boolean useCepMock, boolean useEventCloudMock) throws Exception {
        SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).setURIResolver((URIResolver)new URIMemoryMultipleResolvers(new URIResolver[]{new DefaultURIResolver(), new ClasspathURIResolver(), new EasyESBInternalURIResolver()}));
        DescriptionImpl.setXmlContext((XmlContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()));
        String seaCloudAddress = "http://localhost:9000/SeaCloudAdmin";
        ResourcesDescriptor descriptor = Demo.readDescriptor(Thread.currentThread().getContextClassLoader().getResource("com/ebmwebsourcing/soceda/earthquake/descriptor.xml"));
        System.out.println("========================================== 1. Create Soceda framework");
        CreateFramework.createRuntimeFrameworkFromDescriptor((String)seaCloudAddress, (SeaCloud.CEP_MODE)SeaCloud.CEP_MODE.ESPER, (ResourcesDescriptor)descriptor, (boolean)true, (boolean)useCepMock, (boolean)useEventCloudMock, (boolean)activeGUI);
        System.out.println("========================================== 2. start all business services");
        this.startAllWebServices(activeGUI);
        System.out.println("========================================== 3. connect all business services");
        NotifierClientSOAP earthquakeAlertServerClient = new NotifierClientSOAP("http://localhost:9444/services/earthquakeAlertService");
        earthquakeAlertServerClient.subscribeOn(seaCloudAddress, new QName("http://adam.lille.inria.fr/EventType", "EarthquakeAlertEventTopic"));
        System.out.println("========================================== all business services is connected");
        System.out.println("========================================== 3.1 publish topicNamespace in governance");
        EventManagerClientImplSOAP easiergovEventClient = new EventManagerClientImplSOAP("http://localhost:9005/services/eventManager");
        PublishTopicNamespaceFromURL request = new PublishTopicNamespaceFromURL();
        System.out.println("HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH TEST URL = " + Thread.currentThread().getContextClassLoader().getResource("earthquake/EventTopicNS.xml"));
        request.setTopicNamespaceUrl(Thread.currentThread().getContextClassLoader().getResource("earthquake/EventTopicNS.topns").toString());
        easiergovEventClient.publishTopicNamespaceFromURL(request);
        System.out.println("========================================== topicNamespace are published within the governance");
        System.out.println("========================================== 3.2 publish xsd in governance");
        DataManagerClientImplSOAP easiergovDataClient = new DataManagerClientImplSOAP("http://localhost:9005/services/dataManager");
        PublishSchemaFromURL schemaRequest = new PublishSchemaFromURL();
        schemaRequest.setXsdUrl(Thread.currentThread().getContextClassLoader().getResource("earthquake/EventType.xsd").toString());
        easiergovDataClient.publishSchemaFromURL(schemaRequest);
        System.out.println("========================================== xsd schema is published within the governance");
        SeaCloudClientSOAP cloudClient = new SeaCloudClientSOAP(seaCloudAddress);
        log.info("deploy cep rule");
        String cepFileName = "earthquake.cep";
        File folder = new File("./target/test-resources/earthquake/");
        File cep = new File(folder, cepFileName);
        EJaxbDeployementReport cepReport = cloudClient.deploy(cep, null);
        System.out.println("\n\n");
        System.out.println("***************************************************************************");
        System.out.println("***************************** START PROCESS *******************************");
        System.out.println("***************************************************************************");
        System.out.println("\n\n");
        String shakeevent1msg = "<adamEarthquakeUC:ShakeEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:adamEarthquakeUC=\"http://adam.lille.inria.fr/EventType\" xsi:schemaLocation=\"http://adam.lille.inria.fr/EventType EventType.xsd\"><adamEarthquakeUC:uniqueId>75887543346757</adamEarthquakeUC:uniqueId><adamEarthquakeUC:deviceId>df34533ZEes</adamEarthquakeUC:deviceId><adamEarthquakeUC:time>2013-02-06 15:29:34.521</adamEarthquakeUC:time><adamEarthquakeUC:latitude>53.24</adamEarthquakeUC:latitude><adamEarthquakeUC:longitude>3.12</adamEarthquakeUC:longitude><adamEarthquakeUC:magnitude>5.6</adamEarthquakeUC:magnitude></adamEarthquakeUC:ShakeEvent>";
        Document oe1 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(shakeevent1msg.getBytes()));
        Notify notifyOe1 = WSNHelper.createNotification((String)"http://localhost:9003/eventcloudsManagement", (String)"http://subscriptionProducer.com/", (QName)new QName("http://adam.lille.inria.fr/EventType", "ShakeEventTopic", "evt"), (Object)oe1);
        cloudClient.notify(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notifyOe1));
        String shakeevent2msg = "<adamEarthquakeUC:ShakeEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:adamEarthquakeUC=\"http://adam.lille.inria.fr/EventType\" xsi:schemaLocation=\"http://adam.lille.inria.fr/EventType EventType.xsd\"><adamEarthquakeUC:uniqueId>34784109346757</adamEarthquakeUC:uniqueId><adamEarthquakeUC:deviceId>ht67323abTs</adamEarthquakeUC:deviceId><adamEarthquakeUC:time>2013-02-06 15:31:34.521</adamEarthquakeUC:time><adamEarthquakeUC:latitude>53.22</adamEarthquakeUC:latitude><adamEarthquakeUC:longitude>3.40</adamEarthquakeUC:longitude><adamEarthquakeUC:magnitude>5.8</adamEarthquakeUC:magnitude></adamEarthquakeUC:ShakeEvent>";
        Document oe2 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(shakeevent2msg.getBytes()));
        Notify notifyOe2 = WSNHelper.createNotification((String)"http://localhost:9003/eventcloudsManagement", (String)"http://subscriptionProducer.com/", (QName)new QName("http://adam.lille.inria.fr/EventType", "ShakeEventTopic", "evt"), (Object)oe2);
        cloudClient.notify(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notifyOe2));
        String shakeevent3msg = "<adamEarthquakeUC:ShakeEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:adamEarthquakeUC=\"http://adam.lille.inria.fr/EventType\" xsi:schemaLocation=\"http://adam.lille.inria.fr/EventType EventType.xsd\"><adamEarthquakeUC:uniqueId>90562243179255</adamEarthquakeUC:uniqueId><adamEarthquakeUC:deviceId>ab90678lmTs</adamEarthquakeUC:deviceId><adamEarthquakeUC:time>2013-02-06 15:35:34.521</adamEarthquakeUC:time><adamEarthquakeUC:latitude>53.01</adamEarthquakeUC:latitude><adamEarthquakeUC:longitude>3.33</adamEarthquakeUC:longitude><adamEarthquakeUC:magnitude>6</adamEarthquakeUC:magnitude></adamEarthquakeUC:ShakeEvent>";
        Document oe3 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(shakeevent3msg.getBytes()));
        Notify notifyOe3 = WSNHelper.createNotification((String)"http://localhost:9003/eventcloudsManagement", (String)"http://subscriptionProducer.com/", (QName)new QName("http://adam.lille.inria.fr/EventType", "ShakeEventTopic", "evt"), (Object)oe3);
        cloudClient.notify(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notifyOe3));
        while (((EarthquakeAlertNotifier)this.earthquakeAlertWSServer.getImplementation()).getNotifications().size() == 0) {
            Thread.sleep(200L);
            System.out.println("Wait Earthquake Alert notification");
        }
    }

    public void startAllWebServices(boolean gui) throws Exception {
        this.earthquakeAlertWSServer = new EarthquakeAlertWSServer("http://localhost:9444/services/earthquakeAlertService", gui);
    }

    public static ResourcesDescriptor readDescriptor(URL resource) throws Exception {
        ResourcesDescriptor rsc = null;
        InputStream is = resource.openStream();
        Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
        rsc = (ResourcesDescriptor)SOAJAXBContext.getInstance().marshallAnyType(doc, ResourcesDescriptor.class);
        is.close();
        return rsc;
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("logger/easiestdemo-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
            configFile.close();
        }
        catch (Exception ex) {
            try {
                InputStream configFile = new File("./src/main/resources/logger/easiestdemo-logging.properties").toURI().toURL().openStream();
                LogManager.getLogManager().readConfiguration(configFile);
                configFile.close();
            }
            catch (Exception ex1) {
                System.out.println("WARNING: Could not open configuration file");
                System.out.println("WARNING: Logging not configured (console output only)");
            }
        }
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
        log = Logger.getLogger(Demo.class.getName());
    }
}

