/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.lille.adam.events.outEvents;

import java.io.Serializable;
import javax.xml.namespace.QName;

public class EarthquakeAlertEvent
implements Serializable {
    private static final long serialVersionUID = -1132797280805726112L;
    protected String uniqueId = "";
    protected String time = "";
    protected String alertMessage = "";
    protected double magnitude;

    public EarthquakeAlertEvent(String uniqueId, String time, String alertMessage, double magnitude) {
        this.uniqueId = uniqueId;
        this.time = time;
        this.alertMessage = alertMessage;
        this.magnitude = magnitude;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getAlertMessage() {
        return this.alertMessage;
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(double magnitude) {
        this.magnitude = magnitude;
    }

    public String toXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <EarthquakeAlertEvent xmlns=\"http://adam.lille.inria.fr/EventType\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://adam.lille.inria.fr/EventType EventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<time>" + this.time + "</time>" + "<alertMessage>" + this.alertMessage + "</alertMessage>" + "<magnitude>" + this.magnitude + "</magnitude>" + "</EarthquakeAlertEvent>";
    }

    public String toStringCEP1() {
        return "stream=EarthquakeAlertEvent,uniqueId=" + this.uniqueId + ",time=" + this.time + ",alertMessage=" + this.alertMessage + ",magnitude=" + this.magnitude;
    }

    public String toCEP() {
        return "stream=EarthquakeAlertEvent,uniqueId=" + this.uniqueId + ",time=" + this.time + ",alertMessage=" + this.alertMessage + ",magnitude=" + this.magnitude;
    }

    public String toWSN() {
        return this.formatToWsn(new QName("http://adam.lille.inria.fr/EventType", "EarthquakeAlertEventTopic", "evt"), "<adamEarthquakeUC:EarthquakeAlertEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://adam.lille.inria.fr/EventType\" xsi:schemaLocation=\"http://adam.lille.inria.fr/EventType EventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<time>" + this.time + "</time>" + "<alertMessage>" + this.alertMessage + "</alertMessage>" + "<magnitude>" + this.magnitude + "</magnitude>" + "</adamEarthquakeUC:EarthquakeAlertEvent>", null, null);
    }

    public String formatToWsn(QName topic, String payload, String subscriberAddress, String producerAddress) {
        String notify = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wsnt:Notify xmlns:ns11=\"http://www.ebmwebsourcing.com/wsn/t-1-extension\" xmlns:wsnt=\"http://docs.oasis-open.org/wsn/b-2\">\r\n  <wsnt:NotificationMessage>\r\n";
        if (subscriberAddress != null) {
            notify = notify + "    <wsnt:SubscriptionReference>\r\n" + "      <wsa:Address xmlns:wsa=\"http://www.w3.org/2005/08/addressing\">" + subscriberAddress + "</wsa:Address>\r\n" + "    </wsnt:SubscriptionReference>\r\n";
        }
        if (topic != null) {
            notify = notify + "    <wsnt:Topic Dialect=\"http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete\">\r\n" + "      <ns11:simpleTopicExpression xmlns:" + topic.getPrefix() + "=\"" + topic.getNamespaceURI() + "\">" + topic.getPrefix() + ":" + topic.getLocalPart() + "</ns11:simpleTopicExpression>\r\n" + "    </wsnt:Topic>\r\n";
        }
        if (producerAddress != null) {
            notify = notify + "    <wsnt:ProducerReference>\r\n" + "      <wsa:Address xmlns:wsa=\"http://www.w3.org/2005/08/addressing\">" + producerAddress + "</wsa:Address>\r\n" + "    </wsnt:ProducerReference>\r\n";
        }
        notify = notify + "    <wsnt:Message>\r\n" + payload + "    </wsnt:Message>\r\n" + "  </wsnt:NotificationMessage>\r\n" + "</wsnt:Notify>";
        return notify;
    }
}

