/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.salty.firemendynamicprocess;

import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.petalslink.salty.firemendynamicprocess.ESBEasyVIPERAdminFactory;
import easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.example.fireman.Fireman_WSOUIServer;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.util.ESBManagement;

public class FiremenDynamicProcess_Main {
    public static final URL BPEL_LOCATION = Thread.currentThread().getContextClassLoader().getResource("bpel2/FiremenDynamicProcess_FaultServiceInterception.bpel");
    private Fireman_WSOUIServer fireman_WSOUIServer = null;
    private Node node = null;
    private QName nodeName = new QName("http://petalslink.com/salty/firemendynamicprocess", "FiremenDynamicProcess_EasyESBNode");
    private String nodeHost = "localhost";
    private int nodeInternalPort = 8000;
    private int nodeSoapPort = 8085;
    private String adminUrl = "http://" + this.nodeHost + ":" + this.nodeSoapPort + "/services/adminExternalEndpoint";
    private static boolean standalone;

    public static void main(String[] args) throws Exception {
        FiremenDynamicProcess_Main main = new FiremenDynamicProcess_Main();
        PrintStream err = System.err;
        try {
            boolean activeGUI = true;
            FiremenDynamicProcess_Main.analyzeCommand(args);
            main.startAllWebServices();
            main.setGUIOnAllWebServices(activeGUI);
            main.createNode();
            List<URL> bpelUrls = main.deployAndExposeBPEL(BPEL_LOCATION);
            if (activeGUI) {
                main.createClient();
            }
            Scanner sc = new Scanner(System.in);
            System.out.println("Hit Enter to exit :");
            sc.nextLine();
        }
        catch (Exception e) {
            e.printStackTrace(err);
            main.stopAllWebServices();
            main.stopNode();
        }
    }

    public static void analyzeCommand(String[] args) {
        if (args != null && args.length == 1 && args[0].equals("standalone")) {
            standalone = true;
        }
    }

    public boolean isStandalone() {
        return standalone;
    }

    public void createNode() throws ESBException {
        ESBManagement.getInstance().setESBFactory((ESBFactory)new ESBEasyVIPERAdminFactory());
        this.node = ESBManagement.getInstance().createNode(this.nodeName, this.nodeHost, this.nodeInternalPort, this.nodeSoapPort);
    }

    public List<URL> deployAndExposeBPEL(URL bpel) throws MalformedURLException, AdminExceptionMsg {
        List urls = ESBManagement.getInstance().deployAndExposeBPEL(bpel, new URL(this.adminUrl));
        System.out.println("BPEL " + bpel + " are exposed at url:");
        for (URL url : urls) {
            System.out.println("\t" + url);
        }
        return urls;
    }

    public void stopNode() throws TransportException {
        this.node.stop();
    }

    public void startAllWebServices() throws WSOUIException {
        if (!this.isStandalone()) {
            this.fireman_WSOUIServer = new Fireman_WSOUIServer();
            this.fireman_WSOUIServer.start();
        }
    }

    public void createClient() throws WSOUIException {
        try {
            WSOUIClient client = new WSOUIClient();
            org.petalslink.easiestdemo.client.model.api.esb.Node n = client.addNewAdminWsdlofESBNode(new URL[]{new URL(this.adminUrl + "?wsdl")});
            n.setModel(this.node);
            client.setVisible(true);
        }
        catch (MalformedURLException e) {
            throw new WSOUIException((Throwable)e);
        }
        catch (WSOUIClientException e) {
            throw new WSOUIException((Throwable)e);
        }
    }

    public void setGUIOnAllWebServices(boolean activeGUI) throws WSOUIException {
        if (!this.isStandalone() && this.fireman_WSOUIServer != null) {
            this.fireman_WSOUIServer.getProviderConfigurationFor_Fireman().setActiveGui(activeGUI);
        }
    }

    public void stopAllWebServices() {
        if (!this.isStandalone() && this.fireman_WSOUIServer != null) {
            this.fireman_WSOUIServer.stop();
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("logger/easiestdemo-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (Exception ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
        standalone = false;
    }
}

