/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.ProjectHelper;
import com.ebmwebsourcing.tools.maven.SvnSection;
import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class DependenciesMustConformToInternalRules
extends AbstractRule {
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject parentProject;
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        String svnSection = ProjectHelper.guessMavenProjectSvnSection(mavenProject);
        if (svnSection == "unknown") {
            helper.getLog().warn((CharSequence)String.format("No svn section associated with project '%s'.", mavenProject.getName()));
        }
        if ((parentProject = mavenProject.getParent()) != null) {
            String parentSvnSection = ProjectHelper.guessMavenProjectSvnSection(parentProject);
            if (parentSvnSection == "unknown") {
                helper.getLog().warn((CharSequence)String.format("No svn section associated with project '%s'.", parentProject.getName()));
            }
            if (!SvnSection.canDependOn(svnSection, parentSvnSection)) {
                throw new EnforcerRuleException(String.format("A project in '%s' cannot inherit from a project in '%s'.", svnSection, parentSvnSection));
            }
        }
        for (Object o : mavenProject.getDependencies()) {
            Dependency dep = (Dependency)o;
            if (!dep.getGroupId().startsWith("com.ebmwebsourcing.")) continue;
            MavenProject dependencyMavenProject = this.findMavenProjectForDependency(helper, mavenProject, dep);
            String dependencySvnSection = ProjectHelper.guessMavenProjectSvnSection(dependencyMavenProject);
            helper.getLog().info((CharSequence)String.format("'%s', %s [%s] => '%s', %s [%s].", mavenProject.getName(), mavenProject.getScm().getConnection(), svnSection, dependencyMavenProject.getName(), dependencyMavenProject.getScm().getConnection(), dependencySvnSection));
            if (dependencySvnSection == "unknown") {
                helper.getLog().warn((CharSequence)String.format("No svn section associated with project '%s'.", dependencyMavenProject.getName()));
            }
            if (SvnSection.canDependOn(svnSection, dependencySvnSection)) continue;
            throw new EnforcerRuleException(String.format("A project in '%s' cannot depend on a project in '%s'.", svnSection, dependencySvnSection));
        }
    }
}

