/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.tools.maven.enforcerrules;

import com.ebmwebsourcing.tools.maven.ProjectHelper;
import com.ebmwebsourcing.tools.maven.enforcerrules.AbstractRule;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;

public class NoInternalDependencyInDependencyManagement
extends AbstractRule {
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject)helper.evaluate("${project}");
        DependencyManagement dependencyManagement = mavenProject.getDependencyManagement();
        if (dependencyManagement == null) {
            return;
        }
        List dependencies = dependencyManagement.getDependencies();
        for (Dependency dependency : dependencies) {
            String artifactId;
            String groupId = dependency.getGroupId();
            boolean isPetalsLinkProject = ProjectHelper.isPetalsLinkProject(groupId, artifactId = dependency.getArtifactId());
            if (!isPetalsLinkProject) continue;
            throw new EnforcerRuleException(String.format("The dependency %s:%s is not allowed in the dependencyManagement section.", groupId, artifactId));
        }
    }
}

